(ns utils.json-api-interceptors
  (:require [cheshire.parse :as parse]
            [cheshire.core :as json])
  (:import [java.io PushbackReader InputStreamReader InputStream]))

(defn- json-read [reader & options]
  (let [{:keys [bigdec key-fn array-coerce-fn]
         :or   {bigdec          false
                key-fn          keyword
                array-coerce-fn nil}} options]
    (binding [parse/*use-bigdecimals?* bigdec]
      (json/parse-stream (PushbackReader. reader) key-fn array-coerce-fn))))

(defn- json-stream-parser [request & options]
  (let [encoding (or (:character-encoding request) "UTF-8")]
    (assoc request
      :body
      (apply json-read
             (InputStreamReader.
               ^InputStream (:body request)
               ^String encoding)
             options))))

(def json-body-interceptor
  {:name :json-body-interceptor
   :enter
         (fn [context]
           (update context :request json-stream-parser))})

(def json-response-interceptor
  {:name :json-response-interceptor
   :leave
         (fn [context]
           (-> context
               (update-in [:response :body] json/generate-string)
               (update-in [:response :headers] #(merge % {"Content-Type" "application/json"}))))})