(ns utils.infiltrate-service
  (:require [utils.http :as http]))

(defn infiltrate-tenant [tenant-id]
  (get-in (http/POST (str "https://" (System/getenv "CSAPIHOST") "/api/login")
                     {:headers          {"Content-Type" "application/x-www-form-urlencoded"}
                      :form-params      {:username (str (System/getenv "API_HELPER_USERNAME") " : " tenant-id)
                                         :password (System/getenv "API_HELPER_PASSWORD")}
                      :throw-exceptions false}) [:cookies "access_token" :value]))

(defn logout-of-tenant [token]
  (http/GET (str "https://" (System/getenv "CSAPIHOST") "/api/logout")
            {:headers          {"Authorization" (str "Bearer " token)}
             :throw-exceptions false}))
