(ns utils.date-utils
  (:require [clj-time.core :as t]
            [clj-time.format :as time-format]
            [clj-time.coerce :as t-coerce])
  (:import (java.util Date)))

(defn convert-date [date]
  (if (nil? date)
    nil
    (try (time-format/unparse (:date time-format/formatters) date) (catch Exception _ nil))))

(defn convert-date-time [date-time]
  (if (nil? date-time)
    nil
    (try (time-format/unparse (:date-time-no-ms time-format/formatters) date-time) (catch Exception _ nil))))

(defn ^Date date-or-default
  ([^String maybe-date] (date-or-default maybe-date 0)) ;default offset value = 0 (today)
  ([^String maybe-date days-offset]
   (if (nil? maybe-date)
     (t-coerce/to-date (t/minus (t/now) (t/days days-offset)))
     (t-coerce/from-string maybe-date))))

(defn if-date-nil? [date date-format]
  (if (nil? date)
    nil
    (.toString (t-coerce/from-date date) date-format)))

(defn now-datetime-string []
  (convert-date-time (t/now)))