(ns utils.rethink
  (:require [utils.rethink-service :as rdb]))

(defprotocol Rethink-Queries
  (find-by-id [this id])
  (find-by-filter [this id])
  (delete-by-filter [this filter])
  (delete-by-id [this id])
  (find-by-index [this index value])
  (find-all [this])
  (replace-doc [this doc])
  (replace-one [this id doc])
  (update-doc [this doc])
  (update-one [this doc])
  (insert [this doc]))

(defrecord Rethink [db table]
  Rethink-Queries
  (find-by-id [{:keys [db table]} id]
    (rdb/find-by-id id table db))
  (find-by-filter [{:keys [db table]} filter]
    (rdb/find-by-filter filter table db))
  (delete-by-filter [{:keys [db table]} filter]
    (rdb/delete-by-filter filter table db))
  (delete-by-id [{:keys [db table]} id]
    (rdb/delete-by-id db table id))
  (find-by-index [{:keys [db table]} index value]
    (rdb/find-by-index value index table db))
  (find-all [{:keys [db table]}]
    (rdb/find-all table db))
  (replace-doc [{:keys [db table]} doc]
    (rdb/replace-doc db table doc))
  (replace-one [{:keys [db table]} id doc]
    (rdb/replace-one db table id doc))
  (update-doc [{:keys [db table]} doc]
    (rdb/update-doc db table doc))
  (update-one [{:keys [db table]} id doc]
    (rdb/update-one db table id doc))
  (insert [{:keys [db table]} doc]
    (rdb/insert db table doc)))
