(ns utils.logger
  (:require [clojure.tools.logging :as logging]))

(defmacro logger
  {:arglists '([level message & more] [level throwable message & more])}
  [level & args]
  `(do (logging/logp ~level ~@args))
  (last args))

(defmacro trace [& messages] `(logger :trace ~@messages))

(defmacro debug [& messages] `(logger :debug ~@messages))

(defmacro info [& messages] `(logger :info ~@messages))

(defmacro warn [& messages] `(logger :warn ~@messages))

(defmacro err [& messages] `(logger :error ~@messages))

(defmacro fatal [& messages] `(logger :fatal ~@messages))