(defproject clientsuccess/utils "1.5.21"
  :description "A set of utilities for use in projects for ClientSuccess"
  :dependencies [[org.clojure/clojure "1.8.0"]
                 [org.clojure/java.jdbc "0.6.1"]
                 [clojure.jdbc/clojure.jdbc-c3p0 "0.3.3"]
                 [mysql/mysql-connector-java "5.1.38"]
                 [com.apa512/rethinkdb "0.15.26"]
                 [clj-time "0.14.2"]
                 [clj-http "3.7.0"]
                 [cheshire "5.8.0"]
                 [io.pedestal/pedestal.service "0.5.3"]
                 [org.clojure/data.json "0.2.6"]
                 [camel-snake-kebab "0.4.0"]
                 [ch.qos.logback/logback-classic "1.2.3"]
                 [com.novemberain/langohr "3.5.0"]
                 [com.rabbitmq/amqp-client "3.6.0"]
                 [yleisradio/new-reliquary "1.0.0"]]

  :plugins [[lein-environ "1.0.3"]
            [lein-ring "0.7.3"]
            [s3-wagon-private "1.2.0"]]


  :release-tasks [["change" "version" "leiningen.release/bump-version"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag"]
                  ["deploy" "clojars-https"]
                  ["deploy" "artifacts"]]

  :deploy-repositories [["artifacts" {:url        "s3://clientsuccess-artifacts"
                                      :username   :env/S3DEPLOYUSER
                                      :passphrase :env/S3DEPLOYPASS
                                      :creds      :gpg}]
                        ["clojars-https" {:url           "https://clojars.org/repo"
                                          :username      :env/CLOJARSUSER
                                          :password      :env/CLOJARSPASS
                                          :sign-releases false}]
                        ["releases" :artifacts]])
