(ns utils.employee-info-service
  (:require [clj-http.client :as http]))

(defn- log [x] (prn x) x)

(defn do-remote-employee-info-call [token]
  (http/get (str "https://" (System/getenv "CSAPIHOST") "/api/api/employee/myinfo")
            {:headers          {:Authorization (str "Bearer " token)}
             :client-params    {:cookie-policy (constantly nil)}
             :content-type     :json
             :throw-exceptions false
             :as               :json
             :insecure?        true}))

(defn get-employee-info [token] (:body (do-remote-employee-info-call token))) ;TODO: we need to respond with error if invalid token

(defn get-tenant-id [token] (:tenantId (get-employee-info token)))
