(ns utils.employee-info-service
  (:require [clj-http.client :as http]
            [io.pedestal.interceptor.chain :as chain]))

(defn- log [x] (prn x) x)

(defn do-remote-employee-info-call [token]
  (http/get (str "https://" (System/getenv "CSAPIHOST") "/api/api/employee/myinfo")
            {:headers          {:Authorization (log (str (first token) \space (second token)))}
             :client-params    {:cookie-policy (constantly nil)}
             :content-type     :json
             :throw-exceptions false
             :as               :json
             :insecure?        true}))

(defn get-employee-info [token] (:body (do-remote-employee-info-call token))) ;TODO: we need to respond with error if invalid token

(defn get-tenant-id [token] (:tenantId (get-employee-info token)))
