(ns utils.date-utils
  (:require [clj-time.format :as time-format]
            [clj-time.coerce :as t-coerce]))

(defn convert-date [date]
  (if (nil? date)
    nil
    (try (time-format/unparse (:date time-format/formatters) date) (catch Exception _ nil))))

(defn convert-date-time [date-time]
  (if (nil? date-time)
    nil
    (try (time-format/unparse (:date-time-no-ms time-format/formatters) date-time) (catch Exception _ nil))))

(defn if-date-nil? [date date-format]
  (if (nil? date)
    nil
    (.toString (t-coerce/from-date date) date-format)))