(ns pedestal-utils.request-validation
  (:require [clojure.spec.alpha :as s]
            [io.pedestal.interceptor.chain :refer [terminate]]))

(defn validate-request-data
  "returns an interceptor that takes a spec and applies it to"
  ([spec]
   (validate-request-data spec identity))
  ([spec cb]
   (def validate-request-data
     {:name  :validate-request-data
      :enter (fn [{request :request :as context}]
               (if (s/valid? spec request)
                 (update context :request cb)
                 (-> context terminate
                     (assoc :response
                            {:status  400
                             :headers {}
                             :body    {:developerMessage (s/explain-str spec request)}}))))})))