#!/bin/bash

echo
echo "cli-lein-template :: Creating uberjar..."
echo

lein uberjar


echo
echo "cli-lein-template :: Create native executable..."
echo

mkdir -p build
cd build

NAME={{name}}-0.1.0-SNAPSHOT-standalone
docker run -it \
        --rm \
        -v $HOME:$HOME \
        -w `pwd` \
        -v `pwd`:`pwd` \
        -u $UID:$GID \
        quay.io/quarkus/centos-quarkus-native-s2i:graalvm-1.0.0-rc16 \
        sh -c "native-image -jar ../target/$NAME.jar"

mv ./$NAME ../{{name}}

cd ../
rm build -r
