(ns leiningen.new.cli-app
  (:require [clojure.string :as str]
            [leiningen.new.templates :refer [renderer year project-name
                                             ->files sanitize-ns name-to-path
                                             multi-segment group-name]]
            [leiningen.core.main :as main]))

(def render (renderer "cli-app"))

(defn cli-app
  "Generate a Clojure command line application"
  [name]
  (let [render (renderer "cli-app")
        sanitized (sanitize-ns name)
        project (project-name name)
        group (group-name sanitized)
        corens (multi-segment sanitized)
        configns (str (or group project) ".config")
        handlerns (str (or group project) ".handler")
        data {:raw-name name
              :name project
              :corens corens
              :corepath (name-to-path corens)
              :configns configns
              :configpath (name-to-path configns)
              :handlerns handlerns
              :handlerpath (name-to-path handlerns)
              :year (year)}]
    (main/info "Generating Clojure command line application project.")
    (main/info data)
    (->files data
             [".gitignore" (render "gitignore")]
             ["LICENSE" (render "LICENSE")]
             ["README.md" (render "README.md" data)]
             ["project.clj" (render "project.clj" data)]
             ["dev/user.clj" (render "user.clj" data)]
             ["src/{{corepath}}.clj" (render "core.clj" data)]
             ["src/{{configpath}}.clj" (render "config.clj" data)]
             ["src/{{handlerpath}}.clj" (render "handler.clj" data)]
             ["resources/{{name}}-config.clj" (render "cli-config.clj" data)])))
