(defproject clanhr/reports-api "2.0.0"
  :description "Reports-api service"

  :license {:name         "The MIT License"
            :url          "file://LICENSE"
            :distribution :repo
            :comments     "Copyright Selfcare All Rights Reserved."}

  :min-lein-version "2.5.0"

  :dependencies.edn "https://raw.githubusercontent.com/clanhr/dependencies/master/dependencies.edn?v=3"
  :dependencies []
  :dependency-sets [:clojure
                    :security
                    :common
                    :postgres
                    :ring
                    :document-generation
                    :clanhr
                    :aleph]

  :plugins [[lein-ring "0.8.10"]
            [lein-environ "1.0.2"]
            [lein-pprint "1.1.1"]
            [clanhr/shared-deps "0.2.6"]
            [lein-ancient "0.6.9"]]

  :aliases {"migrate"  ["run" "-m" "clanhr.reports-api.config.database/migrate"]
            "rollback" ["run" "-m" "clanhr.reports-api.config.database/rollback"]
            "users-excel-bench" ["run" "-m" "clanhr.reports-api.tasks.users-excel-bench/-main"]}

  :source-paths ["src"]
  :test-paths ["test"]

  :main clanhr.reports-api.controllers.routes
  :ring {:handler clanhr.reports-api.controllers.routes/app}
  :uberjar-name "clanhr.reports-api.jar"

  :profiles {:uberjar {:aot :all
                       :env {:gateway-provider :postgres}}
             :production {:env {:production "true"
                                :gateway-provider "postgres"}}
             :test {:env {:test "true"
                          :clanhr-env "test"
                          :secret "test"
                          :allow-drop-db "true"
                          :gateway-provider "memory"}}
             :dev {:env {:dev "true"
                         :secret "test"
                         :gateway-provider "postgres"}
                   :dependencies [[org.clojure/test.check "0.9.0"]
                                  [ring-mock "0.1.5"]
                                  [criterium "0.4.4"]]
                   :global-vars {*warn-on-reflection* false
                                 *assert* true}
                   :plugins [[com.jakemccrary/lein-test-refresh "0.14.0"]
                             [lein-cloverage "1.0.2"]]}}

  :test-refresh {:quiet true
                 :changes-only true})
