(ns clanhr.reports-api.models.vacations-and-absences
  "Vacations and absences representation and validation"
  (:require [result.core :as result]
            [schema.core :as s]))

(def schema
  "Representation of this model"
  {:id s/Uuid
   :name s/Str
   :teams [s/Str]
   :projects [s/Str]
   (s/optional-key :tags) s/Any
   :start_date s/Any
   (s/optional-key :start-date) s/Any
   :end_date s/Any
   (s/optional-key :end-date) s/Any
   :duration s/Num
   :absence-type s/Str
   :duration-type s/Str
   :user_id s/Uuid
   :colaborator_id s/Any
   :account_id s/Uuid
   :updated_at s/Any
   :created_at s/Any
   :manager_ids [s/Str]
   })
