(ns clanhr.reports-api.models.user-changes
  "User changes representation and validation"
  (:require [result.core :as result]
            [schema.core :as s]))

(def schema
  "Representation of this model"
  {:projects [s/Str]
   :teams [s/Str]
   :tags [s/Str]
   :position (s/maybe s/Str)
   :name s/Str
   :section s/Str
   :field s/Str
   :old_value (s/maybe s/Str)
   :new_value (s/maybe s/Str)
   :user_id s/Uuid
   :approver_id s/Uuid
   :colaborator_id (s/maybe s/Str)})
