(ns clanhr.reports-api.models.kms
  "Kms representation and validation"
  (:require [validateur.validation :refer :all]
            [clanhr.validators.core :as validators]
            [clj-time.coerce :as c]
            [clj-time.format :as f]
            [result.core :as result]))

(def validator (validation-set
                 (presence-of :user-id)
                 (presence-of :account-id)
                 (presence-of :date)
                 (presence-of :origin)
                 (presence-of :destination)
                 (presence-of :reason)
                 (presence-of :license-plate)
                 (presence-of :number-of-kms)
                 (presence-of :value-per-km)
                 (presence-of :total-with-tax)
                 (presence-of :state)
                 ))

(defn validate
  "Verifies if the kms specific given data format is valid"
  [contract]
  (let [validation (validator contract)]
    (result/enforce-empty validation)))
