(ns clanhr.reports-api.models.document
  "Kms representation and validation"
  (:require [validateur.validation :refer :all]
            [clanhr.validators.core :as validators]
            [clj-time.coerce :as c]
            [clj-time.format :as f]
            [result.core :as result]))

(def documents-validator (validation-set
                     (presence-of :account-id)
                     (presence-of :url)
                     (presence-of :name)
                     ))

(defn build
  "Builds a timelog with proper date objects"
  [document]
  (if (:global document)
    (dissoc document :user-id)
    document))

(defn validate
  "Verifies if the absence's format is valid"
  [model]
  (let [validation (documents-validator model)]
    (result/enforce-empty validation)))
