(ns clanhr.reports-api.models.absence
  "Absence representation and validation"
  (:require [validateur.validation :refer :all]
            [clanhr.validators.core :as validators]
            [result.core :as result]))

(def absence-validator (validation-set
                         (presence-of :absence-id)
                         (presence-of :account-id)
                         (presence-of :user-id)
                         (length-of :username :within (range 3 100))
                         (presence-of :type)
                         (presence-of :state)
                         (presence-of :start-date)
                         (validators/date-validator :start-date)
                         (presence-of :end-date)
                         (validators/date-validator :end-date)
                         (numericality-of :duration :only-integer false :gte 0)
                         (inclusion-of :duration-type :in #{"days" "hours" "partial-day"})
                         (numericality-of :total-days :only-integer false :gte 0)))

(defn validate
  "Verifies if the absence's format is valid"
  [absence]
  (let [validation (absence-validator absence)]
    (result/enforce-empty validation)))
