(ns clanhr.reports-api.lib.metrics
  "Utilities to register service metrics"
  (:require [clanhr.analytics.metrics :as metrics]))

(defn- metric-source
  "Builds the metric source"
  [specific-name source-key m]
  (str specific-name "." (get m source-key "list")))

(defn report-generated
  "Tracks a report generated event. The source can be given on the first
  argument as :report-metric-source. If not given, 'list' will be used."
  [report-name m]
  (metrics/track "report-generated"
                 (metric-source report-name :report-metric-source m) 1))
