(ns clanhr.reports-api.gateways.vacation-balance
  "Common interface for a vacation balance gateway")

(defprotocol VacationBalance
  (add-absence [this context user absence] "Stores an absence for a user")
  (get-absence [this context absence-id] "Gets the data for an absence")
  (setup-vacations [this context user] "Updates data from a absences-api user")
  (update-user [this context user] "Updates data from a directory-api user")
  (delete-user [this context user-id] "Deletes data from a directory-api user")
  (remove-absence [this context absence] "Removes an absence")
  (query [this context args] "Retrieves information"))
