(ns clanhr.reports-api.gateways.postgres.documents
  "Postgres documents gateway and component"
  (:require [clanhr.reports-api.gateways.documents :as dg]
            [clanhr.postgres-gateway.core :as gateway]
            [clanhr.postgres-gateway.utils :as pg-utils]
            [clanhr.reports-api.gateways.postgres.common :as common]
            [com.stuartsierra.component :as component]
            [clj-time.coerce :as c]
            [clj-time.core :as t]
            [clojure.core.async :refer [go <! <!!]]
            [result.core :as result]))

(def table-name common/documents-report-table-name)

(defrecord DocumentsPostgresGateway [pg-conn]

  component/Lifecycle

  (start [this] this)
  (stop [this] this)

  dg/Documents

  (add-document [this context user document]
    (gateway/save-data! {:id (java.util.UUID/randomUUID)
                         :user_id (:user-id document)
                         :account_id (:account-id document)
                         :url (:url document)
                         :name (:name document)}
                        (common/pg-config-for table-name context)))

  (query [this context args]
    (go
      (let [page (or (:page args) 1)
            per-page (or (:per-page args) 10)
            user-id (:user-id args)
            account-id (:account-id args)

            config (common/pg-config-for table-name context)

            results (gateway/query-data
                      [(str "select * from " table-name "  "
                            "where account_id = $1 and (user_id = $2 or user_id is null) "
                            "order by name desc")
                       account-id user-id]
                      (merge config {:page page :per-page per-page}))

            results (<! results)]

        (cond
          (result/failed? results) results
          :else (result/success {:data (:data results)
                                 :total-results (count (:data results))
                                 :current-page 1}))))))

(defn create
  "Creates the gateway instance component"
  []
  (component/using (map->DocumentsPostgresGateway {})
                   [:pg-conn]))
