(ns clanhr.reports-api.gateways.postgres.common
  "Postgres common"
  (:require [clanhr.postgres-gateway.config :as postgres-gateway-config]
            [environ.core :refer [env]]))

(def service-name "reports-api")
(def vacations-balance-user-table-name "reports.vacations_balances_users")
(def vacations-balance-table-name "reports.vacations_balances")
(def absence-report-table-name "reports.absence_reports")
(def timelog-report-table-name "reports.timelogs")
(def kms-report-table-name "reports.kms")
(def documents-report-table-name "reports.documents")
(def expenses-report-table-name "reports.expenses")
(def user-report-table-name "reports.users")
(def user-changes-report-table-name "reports.user_changes")

(defn conn-str
  "Gets the postgres conn string"
  []
  (or (env :clanhr-reports-api-postgres) (throw (Exception. "No postgres conn"))))

(defn pool-size
  "Gets the poolsize to use"
  []
  (if-let [size (env :clanhr-pg-pool-size)]
    (Integer/parseInt size)
    1))

(defn- db-map
  "Gets the map of settings to connect to the db"
  []
  (let [m (postgres-gateway-config/jdbc-str-to-map (conn-str))]
    (if (:ssl m)
      m
      (dissoc m :ssl))))

(defn config
  "Gets the settings for the db connection"
  []
  (-> (db-map)
      (assoc :pool-size (pool-size))))

(defn stream-config
  "Gets the settings for the db connection for a single stream query"
  []
  {:db-config (db-map)})

(defn pg-config-for
  "Prepares config to be given to the pg gateway"
  [table-name {:keys [pg-conn] :as context}]
  {:table table-name
   :service-name "reports-api"
   :env-name (env :clanhr-env)
   :conn pg-conn})
