(ns clanhr.reports-api.gateways.absence-report
  "Common interface for a absence report gateway")

(defprotocol AbsenceReport
  (add-absence [this context user absence] "Stores an absence")
  (get-absence [this context absence-id] "Gets the data for an absence")
  (update-user [this context user] "Updates data from a directory-api user")
  (delete-user [this context user-id] "Deletes data from a directory-api user")
  (remove-absence [this context absence-id] "Removes an absence")
  (query [this context args] "Retrieves information"))
