(ns clanhr.reports-api.core.sync-user
  "Syncs the user"
  (:refer-clojure :exclude [run!])
  (:require [result.core :as result]
            [clojure.core.async :refer [go <!]]
            [clanhr-api.core :as clanhr-api]
            [clanhr.reports-api.models.absence :as absence-model]
            [clanhr.reports-api.middlewares.context :as context]
            [clanhr.reports-api.gateways.vacation-balance :as vbg]
            [clanhr.reports-api.gateways.timelog-report :as tlg]
            [clanhr.reports-api.gateways.user-report :as urg]
            [clanhr.reports-api.gateways.absence-report :as arg]))

(defn- persist!
  "Processes the updates"
  [{:keys [vacations-balance-gateway
           absence-report-gateway
           user-report-gateway
           user-changes-report-gateway
           timelog-gateway] :as context}
   user]
  (go
    (result/enforce-let [absence-report (<! (arg/update-user absence-report-gateway context user))
                         timelog (<! (tlg/update-user timelog-gateway context user))
                         user-report (<! (urg/update-user user-report-gateway context user))
                         user-changes-report (<! (urg/update-user user-changes-report-gateway context user))
                         vacations-balance (<! (vbg/update-user vacations-balance-gateway context user))]
      (result/success {:absence-report absence-report
                       :timelog timelog
                       :user-report user-report
                       :user-changes-report user-changes-report
                       :vacations-balance vacations-balance}))))

(defn atomic-run!
  "Registers a user"
  [context user]
  (context/transaction-run! context
                            (fn [context] (persist! context user))))

