(ns clanhr.reports-api.core.setup-vacations
  "Setups vacations for users"
  (:refer-clojure :exclude [run!])
  (:require [result.core :as result]
            [clojure.core.async :refer [go <!]]
            [clanhr-api.core :as clanhr-api]
            [clanhr.reports-api.models.absence :as absence-model]
            [clanhr.reports-api.middlewares.context :as context]
            [clanhr.reports-api.gateways.vacation-balance :as vbg]
            [clanhr.reports-api.gateways.absence-report :as arg]))

(defn- persist!
  "Processes the updates"
  [{:keys [vacations-balance-gateway] :as context} user]
  (go
    (result/enforce-let [vacations-balance (<! (vbg/setup-vacations vacations-balance-gateway context user))]
      vacations-balance)))

(defn atomic-run!
  "Registers a user"
  [context user]
  (context/transaction-run! context
                            (fn [context] (persist! context user))))

