(ns clanhr.reports-api.core.register-timelog
  "Registers a timelog for a user"
  (:refer-clojure :exclude [run!])
  (:require [result.core :as result]
            [clojure.core.async :refer [go <!]]
            [clanhr-api.core :as clanhr-api]
            [clanhr.reports-api.models.timelog :as timelog-model]
            [clanhr.reports-api.middlewares.context :as context]
            [clanhr.reports-api.gateways.timelog-report :as tlg]))

(defn register-timelog-report
  "Registers the timelog"
  [{:keys [timelog-gateway] :as context} user timelog]
  (tlg/add-timelog timelog-gateway context user timelog))

(defn validate
  "Validates the given data"
  [context timelog]
  (timelog-model/validate timelog))

(defn- get-user
  "Gets the user information for the given absence"
  [context absence]
  (if-let [result (:get-user-result context)]
    (go result)
    (clanhr-api/http-get {:service :directory-api
                          :path (str "/user/" (:user-id absence))
                          :token (:token context)})))

(defn run!
  "Registers a timelog"
  [context timelog]
  (go
    (result/enforce-let [valid? (validate context timelog)
                         user (<! (get-user context timelog))]
      (<! (register-timelog-report context user (timelog-model/build timelog))))))

