(ns clanhr.reports-api.core.register-kms
  "Registers kms for a user"
  (:refer-clojure :exclude [run!])
  (:require [result.core :as result]
            [clojure.core.async :refer [go <!]]
            [clanhr-api.core :as clanhr-api]
            [clanhr.reports-api.models.kms :as kms-model]
            [clanhr.reports-api.middlewares.context :as context]
            [clanhr.reports-api.gateways.kms :as kg]))

(defn register-kms
  "Registers the kms"
  [{:keys [kms-gateway] :as context} kms]
  (kg/add-kms kms-gateway context kms))

(defn validate
  "Validates the given data"
  [context kms]
  (kms-model/validate kms))

(defn run!
  "Registers kms"
  [context kms]
  (go
    (result/enforce-let [_ (validate context kms)]
      (<! (register-kms context kms)))))
