(ns clanhr.reports-api.core.register-expense
  "Registers expense for a user"
  (:refer-clojure :exclude [run!])
  (:require [result.core :as result]
            [clojure.core.async :refer [go <!]]
            [clanhr-api.core :as clanhr-api]
            [clanhr.reports-api.models.expense :as expense-model]
            [clanhr.reports-api.middlewares.context :as context]
            [clanhr.reports-api.gateways.expenses :as dg]))

(defn register-expenses
  "Registers the expenses"
  [{:keys [expenses-gateway] :as context} expense]
  (dg/add-expense expenses-gateway context expense))

(defn validate
  "Validates the given data"
  [context expense]
  (expense-model/validate expense))

(defn run!
  "Registers expenses"
  [context expense]
  (go
    (result/enforce-let [valid? (validate context expense)]
      (<! (register-expenses context (expense-model/build expense))))))

