(ns clanhr.reports-api.core.register-document
  "Registers document for a user"
  (:refer-clojure :exclude [run!])
  (:require [result.core :as result]
            [clojure.core.async :refer [go <!]]
            [clanhr-api.core :as clanhr-api]
            [clanhr.reports-api.models.document :as document-model]
            [clanhr.reports-api.middlewares.context :as context]
            [clanhr.reports-api.gateways.documents :as dg]))

(defn register-documents
  "Registers the documents"
  [{:keys [documents-gateway] :as context} user documents]
  (dg/add-document documents-gateway context user documents))

(defn validate
  "Validates the given data"
  [context documents]
  (document-model/validate documents))

(defn- get-user
  "Gets the user information for the given absence"
  [context absence]
  (if-let [result (:get-user-result context)]
    (go result)
    (clanhr-api/http-get {:service :directory-api
                          :path (str "/user/" (:user-id absence))
                          :token (:token context)})))

(defn run!
  "Registers documents"
  [context documents]
  (go
    (result/enforce-let [valid? (validate context documents)
                         user (<! (get-user context documents))]
      (<! (register-documents context user (document-model/build documents))))))

