(ns clanhr.reports-api.core.list-users
  "List the registered users"
  (:refer-clojure :exclude [run!])
  (:require [clojure.core.async :refer [go]]
            [result.core :as result]
            [clj-time.coerce :as c]
            [clj-time.core :as t]
            [clanhr.reports-api.lib.utils :as utils]
            [clanhr.reports-api.lib.metrics :as metrics]
            [clanhr.auth.authorized :as auth]
            [clanhr.work-days.core :as work-days]
            [clojure.core.async :refer [<! go]]
            [clanhr.reports-api.core.get-account-settings :as get-account-settings]
            [clanhr.reports-api.gateways.user-report :as urg]))

(defn query-builder
  [context data]
  (let [query {:per-page (:per-page data)
               :page (:page data)
               :name (:name data)
               :positions (:positions data)
               :teams (:teams data)
               :tags (:tags data)
               :projects (:projects data)
               :managers-ids (:managers-ids data)
               :account-id (:account-id context)}]
    (apply dissoc query
                  (for [[k v] query :when (nil? v)] k))))

(defn prepare-query
  "Ensure presence of per-page and page query params"
  [context data]
  (result/success (merge utils/query-defaults (query-builder context data))))

(defn run
  "List users report by query"
  [{:keys [user-report-gateway] :as context} data]
  (go
    (let [query (prepare-query context data)
          auth-ch (auth/authorized? (assoc context :action :reports-access))
          query-ch (urg/query user-report-gateway context query)]
      (metrics/report-generated "users" data)
      (result/enforce-let [auth-result (<! auth-ch)
                           query-result (<! query-ch)]))))
