(ns clanhr.reports-api.core.list-timelogs
  "List timelogs report"
  (:refer-clojure :exclude [run!])
  (:require [clojure.core.async :refer [go]]
            [result.core :as result]
            [clj-time.coerce :as c]
            [clj-time.core :as t]
            [clanhr.auth.authorized :as auth]
            [clanhr.work-days.core :as work-days]
            [clojure.core.async :refer [<! go]]
            [clanhr.reports-api.gateways.timelog-report :as tlg]))

(def ^:private query-defaults {:per-page 10
                               :page 1})

(defn query-builder
  [context data]
  (let [query {:per-page (:per-page data)
               :page (:page data)
               :name (:name data)
               :teams (:teams data)
               :projects (:projects data)
               :start-date (:start-date data)
               :end-date (:end-date data)
               :account-id (:account-id context)}]
    (apply dissoc query
                  (for [[k v] query :when (nil? v)] k))))

(defn prepare-query
  "Ensure presence of per-page and page query params"
  [context data]
  (result/success (merge query-defaults (query-builder context data))))

(defn run!
  "List notifications in state to-process"
  [{:keys [timelog-gateway] :as context} data]
  (go
    (result/enforce-let [query (prepare-query context data)
                         result (<! (auth/authorized? (assoc context :action :reports-access)))]
      (-> (<! (tlg/query timelog-gateway context query))))))
