(ns clanhr.reports-api.core.get-account-settings
  "Gets the account settings"
  (:refer-clojure :exclude [run!])
  (:require [clojure.core.async :refer [go]]
            [environ.core :refer [env]]
            [clanhr-api.core :as clanhr-api]
            [result.core :as result]
            [clj-time.coerce :as c]
            [clj-time.core :as t]
            [clanhr.auth.authorized :as auth]
            [clanhr.work-days.core :as work-days]
            [clojure.core.async :refer [<! go]]
            [clanhr.reports-api.gateways.kms :as kg]))

(defn force-get-account-settings? [] (some #{"production" "staging"} [(env :clanhr-env)]))

(defn get-account-settings
  "Gets the account settings for the tiven account"
  [token]
  (if (force-get-account-settings?)
    (clanhr-api/http-get {:service :directory-api
                          :path "/account/settings"
                          :token token})
    (go (result/success {}))))

(defn run
  "Gets the account settings"
  [{:keys [token] :as context}]
  (get-account-settings token))
