(ns clanhr.reports-api.core.delete-user
  "Deletes a user"
  (:require [result.core :as result]
            [clojure.core.async :refer [go <!]]
            [clanhr-api.core :as clanhr-api]
            [clanhr.reports-api.models.absence :as absence-model]
            [clanhr.reports-api.middlewares.context :as context]
            [clanhr.reports-api.gateways.vacation-balance :as vbg]
            [clanhr.reports-api.gateways.timelog-report :as tlg]
            [clanhr.reports-api.gateways.absence-report :as arg]))

(defn- persist!
  "Delestes all the user reports data"
  [{:keys [vacations-balance-gateway absence-report-gateway timelog-gateway] :as context} user-id]
  (go
    (result/enforce-let [absence-report (<! (arg/delete-user absence-report-gateway context user-id))
                         timelog (<! (tlg/delete-user timelog-gateway context user-id))
                         vacations-balance (<! (vbg/delete-user vacations-balance-gateway context user-id))]
      (result/success))))

(defn atomic-run!
  "Deletes a user"
  [context user-id]
  (context/transaction-run! context
                            (fn [context] (persist! context user-id))))

