(ns clanhr.reports-api.controllers.sync-user
  (:require [clanhr.reply.core :as reply]
            [clanhr.reply.json :as json]
            [clojure.core.async :refer [<!]]
            [clanhr.reports-api.core.sync-user :as sync-user]
            [result.core :as result]))

(defn handler
  "Sync user data handler"
  [request]
  (reply/async-reply
    (let [user (json/build (slurp (:body request)))
          result (<! (sync-user/atomic-run! (:context request) user))]
      (reply/result result))))
