(ns clanhr.reports-api.controllers.sync-absence-data
  (:require [clanhr.reply.core :as reply]
            [clanhr.reply.json :as json]
            [clojure.core.async :refer [<!]]
            [clanhr.reports-api.core.register-absence :as register-absence]
            [result.core :as result]))

(defn handler
  "Sync absence data handler"
  [request]
  (reply/async-reply
    (let [absence (json/build (slurp (:body request)))
          result (<! (register-absence/atomic-run! (:context request) absence))]
      (reply/result result))))
