(ns clanhr.reports-api.controllers.setup-vacations
  (:require [clanhr.reply.core :as reply]
            [clanhr.reply.json :as json]
            [clojure.core.async :refer [<!]]
            [clanhr.reports-api.core.setup-vacations :as setup-vacations]
            [result.core :as result]))

(defn handler
  "Setup vacations"
  [request]
  (reply/async-reply
    (let [absence-user (json/build (slurp (:body request)))
          result (<! (setup-vacations/atomic-run! (:context request) absence-user))]
      (reply/result result))))
