(ns clanhr.reports-api.controllers.sample-excel
  (:import
    [java.io File])
  (:require [clanhr.reply.core :as reply]
            [clanhr.reply.json :as json]
            [byte-streams :as bs]
            [clanhr.reports-api.gateways.postgres.common :as postgres-common]
            [clanhr.postgres-gateway.query-stream :as query-stream]
            [clanhr.reports-api.core.generate-excel :as generate-excel]
            [clanhr.reports-api.core.generate-excel :as generate-excel]))

(defn handler
  "Generate sample excel"
  [request]
  (let [context {}
        result (generate-excel/run context {})
        file-path (:file-name result)]
    (reply/excel-file file-path file-path)))
