(ns clanhr.reports-api.controllers.register-timelog
  (:require [clanhr.reply.core :as reply]
            [clanhr.reply.json :as json]
            [clojure.core.async :refer [<!]]
            [clanhr.reports-api.core.register-timelog :as register-timelog]
            [result.core :as result]))

(defn handler
  "Sync absence data handler"
  [request]
  (reply/async-reply
    (let [data (json/build (slurp (:body request)))
          result (<! (register-timelog/run! (:context request) data))]
      (reply/result result))))
