(ns clanhr.reports-api.controllers.register-kms
  (:require [clanhr.reply.core :as reply]
            [clanhr.reply.json :as json]
            [clojure.core.async :refer [<!]]
            [clanhr.reports-api.core.register-kms :as register-kms]
            [result.core :as result]))

(defn handler
  "Sync kms data handler"
  [request]
  (reply/async-reply
    (let [data (json/build (slurp (:body request)))
          result (<! (register-kms/run! (:context request) data))]
      (reply/result result))))
