(ns clanhr.reports-api.controllers.register-expense
  (:require [clanhr.reply.core :as reply]
            [clanhr.reply.json :as json]
            [clojure.core.async :refer [<!]]
            [clanhr.reports-api.core.register-expense :as register-expense]
            [result.core :as result]))

(defn handler
  "Sync expense data handler"
  [request]
  (reply/async-reply
    (let [data (json/build (slurp (:body request)))
          result (<! (register-expense/run! (:context request) data))]
      (reply/result result))))
