(ns clanhr.reports-api.controllers.register-document
  (:require [clanhr.reply.core :as reply]
            [clanhr.reply.json :as json]
            [clojure.core.async :refer [<!]]
            [clanhr.reports-api.core.register-document :as register-document]
            [result.core :as result]))

(defn handler
  "Sync document data handler"
  [request]
  (reply/async-reply
    (let [data (json/build (slurp (:body request)))
          result (<! (register-document/run! (:context request) data))]
      (reply/result result))))
