(ns clanhr.reports-api.controllers.list-user-changes
  (:require [clanhr.reply.core :as reply]
            [clanhr.reply.json :as json]
            [clanhr.i18n.core :as i18n]
            [result.core :as result]
            [clojure.string :as string]
            [clj-time.coerce :as c]
            [clojure.core.async :refer [go go-loop <! thread]]
            [clanhr.reports-api.core.list-user-changes :as list-user-changes]
            [clanhr.reports-api.core.generate-excel :as generate-excel]))

(defn handler
  "List users report"
  [request]
  (reply/async-result
    (list-user-changes/run (:context request) (:params request))))

(defn prepare-excel-data
  "Prepares the excel data to be a simple table"
  [lang result]
  {:data (into [[(i18n/t lang :colaborator-id)
                 (i18n/t lang :name)
                 (i18n/t lang :section)
                 (i18n/t lang :field)
                 (i18n/t lang :old-value)
                 (i18n/t lang :new-value)]]
           (mapv (fn [item]
                   [(:colaborator_id item)
                    (:name item)
                    (i18n/t lang (:section item))
                    (i18n/t lang (:field item))
                    (:old_value item)
                    (:new_value item)])
                 (:data result)))})

(defn excel
  "User changes excel report"
  [request]
  (reply/async-reply
    (let [context (:context request)
          params (-> (:params request)
                     (assoc :report-metric-source "excel")
                     (assoc :per-page 10000))
          lang (or (:lang params) "en")]
      (result/enforce-let [result (<! (list-user-changes/run context params))
                           excel (<! (thread (generate-excel/run context (prepare-excel-data lang result))))]
        (let [file-name (:file-name excel)]
          (reply/excel-file file-name (i18n/t lang :user-changes-excel-file "UserChanges.xlsx")))))))
