(ns clanhr.reports-api.controllers.delete-user
  (:require [clanhr.reply.core :as reply]
            [clanhr.reply.json :as json]
            [clojure.core.async :refer [<!]]
            [clanhr.reports-api.core.delete-user :as delete-user]
            [result.core :as result]))

(defn handler
  "Delete user data handler"
  [request]
  (reply/async-reply
    (let [user-id (get-in request [:params :user-id])
          result (<! (delete-user/atomic-run! (:context request) user-id))]
      (reply/result result))))
