(ns clanhr.reports-api.config.database
  (:require [ragtime.jdbc :as jdbc]
            [ragtime.strategy :as strategy]
            [taoensso.timbre :as logger]
            [ragtime.repl :as repl]))

(defn- load-config []
  {:datastore (jdbc/sql-database (System/getenv "CLANHR_REPORTS_API_POSTGRES")
                                 {:migrations-table "reports_ragtime_migrations"})
   :strategy strategy/apply-new
   :migrations (jdbc/load-directory "migrations")})

(defn migrate []
  (logger/info "Starting migrating...")
  (repl/migrate (load-config))
  (logger/info "Finished migrating.")
  (shutdown-agents))

(defn rollback []
  (repl/rollback (load-config)))
