/*
 * Decompiled with CFR 0.152.
 */
package cl.omp.logger;

import cl.omp.logger.LoggerConfig;
import cl.omp.logger.LoggerLevel;
import cl.omp.logger.StdoutLoggerPrinter;
import cl.omp.logger.SystemInfo;
import cl.omp.logger.Time;
import java.io.IOException;

public class OMPLogger {
    private Class<?> clazz;
    private LoggerConfig configuration;
    public static final String INFOCOLOR = "\u001b[32m";
    public static final String WARNINGCOLOR = "\u001b[33m";
    public static final String ERRORCOLOR = "\u001b[31m";
    public static final String RAWCOLOR = "\u001b[37m";

    public static OMPLogger getLogger(String className) {
        return new OMPLogger(className);
    }

    public static OMPLogger getLogger(Class<?> clazz) {
        return new OMPLogger(clazz);
    }

    public OMPLogger(String className) {
        this(className, LoggerLevel.ALL);
    }

    public OMPLogger(Class<?> clazz) {
        this(clazz, LoggerLevel.ALL);
    }

    public OMPLogger(String className, LoggerLevel level) {
        this(className, new LoggerConfig(level != null ? level : LoggerLevel.ALL, new StdoutLoggerPrinter()));
    }

    public OMPLogger(Class<?> clazz, LoggerLevel level) {
        this(clazz, new LoggerConfig(level != null ? level : LoggerLevel.ALL, new StdoutLoggerPrinter()));
    }

    public OMPLogger(String className, LoggerConfig configuration) {
        try {
            this.clazz = Class.forName(className);
            this.configuration = configuration;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public OMPLogger(Class<?> clazz, LoggerConfig configuration) {
        this.clazz = clazz;
        this.configuration = configuration;
    }

    private String buildMsg(String title, String body) {
        StringBuilder sbMsg = new StringBuilder();
        sbMsg.append("[OMPServer|");
        sbMsg.append(this.clazz.getSimpleName()).append(" class] ");
        sbMsg.append(Time.getCurrentTime()).append(" ");
        if (title != null) {
            sbMsg.append(title).append(" ");
        }
        sbMsg.append(": ");
        sbMsg.append(body);
        return sbMsg.toString();
    }

    private String addMsgColor(String color, String msg) {
        StringBuilder sbMsg = new StringBuilder();
        if (SystemInfo.IS_UNIX) {
            sbMsg.append(color);
            sbMsg.append(msg);
            sbMsg.append("\u001b[0m");
            return sbMsg.toString();
        }
        return msg;
    }

    private void println(String str) {
        try {
            this.configuration.getPrinter().println(str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void error(String msg) {
        this.error(null, msg);
    }

    public void error(String title, String msg) {
        switch (this.configuration.getLevel()) {
            case ALL: 
            case ERROR: {
                String formattedMsg = this.buildMsg(title, msg);
                this.println(this.addMsgColor(ERRORCOLOR, formattedMsg));
            }
        }
    }

    public void info(String msg) {
        this.info(null, msg);
    }

    public void info(String title, String msg) {
        switch (this.configuration.getLevel()) {
            case ALL: 
            case INFO: {
                String formattedMsg = this.buildMsg(title, msg);
                this.println(this.addMsgColor(INFOCOLOR, formattedMsg));
            }
        }
    }

    public void warning(String msg) {
        this.warning(null, msg);
    }

    public void warning(String title, String msg) {
        switch (this.configuration.getLevel()) {
            case ALL: 
            case WARNING: {
                String formattedMsg = this.buildMsg(title, msg);
                this.println(this.addMsgColor(WARNINGCOLOR, formattedMsg));
            }
        }
    }

    public void message(String msg) {
        this.message(null, msg);
    }

    public void message(String title, String msg) {
        switch (this.configuration.getLevel()) {
            case ALL: 
            case MESSAGE: {
                String formattedMsg = this.buildMsg(title, msg);
                this.println(this.addMsgColor(RAWCOLOR, formattedMsg));
            }
        }
    }

    public void rawError(String msg) {
        this.println(this.addMsgColor(ERRORCOLOR, msg));
    }

    public void rawInfo(String msg) {
        this.println(this.addMsgColor(INFOCOLOR, msg));
    }

    public void rawWarning(String msg) {
        this.println(this.addMsgColor(WARNINGCOLOR, msg));
    }

    public void rawMessage(String msg) {
        this.println(this.addMsgColor(RAWCOLOR, msg));
    }
}

