(ns optimus-img-transform.image-magic)

(ns repl
  (:require [kodemaker-no.web :refer [app]]
            [ring.adapter.jetty]
            [fivetonine.collage.util :as util])
  (:import [java.awt.image BufferedImage]
           [java.awt.color ColorSpace]))

(defn start-server []
  (defonce server (ring.adapter.jetty/run-jetty #'app {:port 3000 :join? false}))
  (.start server))

(defn stop-server []
  (.stop server))

(comment

  (require '[fivetonine.collage.util :as util])
  (require '[fivetonine.collage.core :as collage])

  (def image (util/load-image "/Users/christian/Downloads/klatre.jpg"))
  (def square (collage/crop image 0 0 (.getWidth image) (.getWidth image)))

  (type image)

  (.getWidth image)
  (.getHeight image)

  (defn jagged-circle [image]
    (let [width (.getWidth image)
          circle (BufferedImage. width width (.getType image))]
      (doto (.createGraphics circle)
        (.setClip (java.awt.geom.Ellipse2D$Float. 0 0 width width))
        (.drawImage image 0 0 width width nil)
        .dispose)
      circle))

  (defn position-polygon [pos w]
    (case pos
      :lower-left (java.awt.Polygon. (int-array [0 w 0]) (int-array [w w 0]) 3)
      :lower-right (java.awt.Polygon. (int-array [w w 0]) (int-array [w 0 w]) 3)
      :upper-right (java.awt.Polygon. (int-array [w 0 w]) (int-array [0 0 w]) 3)
      :upper-left (java.awt.Polygon. (int-array [0 0 w]) (int-array [0 w 0]) 3)))

  (defn triangle [image & [{:keys [position]}]]
    (let [width (.getWidth image)
          circle (BufferedImage. width width BufferedImage/TYPE_INT_ARGB)]
      (doto (.createGraphics circle)
        (.setComposite java.awt.AlphaComposite/Clear)
        (.fillRect 0 0 width width)
        (.setComposite java.awt.AlphaComposite/Src)
        (.setClip (position-polygon (or position :lower-left) width))
        (.drawImage image 0 0 width width nil)
        .dispose)
      circle))

  (defn smooth-circle [image]
    (let [width (.getWidth image)
          circle (BufferedImage. width width BufferedImage/TYPE_INT_ARGB #_(.getType image))]
      (doto (.createGraphics circle)
        (.setComposite java.awt.AlphaComposite/Clear)
        (.fillRect 0 0 width width)
        ;; fake soft-clipping by first drawing the desired clip shape in fully
        ;; opaque white with antialiasing enabled...
        (.setComposite java.awt.AlphaComposite/Src)
        (.setRenderingHint java.awt.RenderingHints/KEY_ANTIALIASING java.awt.RenderingHints/VALUE_ANTIALIAS_ON)
        (.setColor (java.awt.Color/WHITE))
        (.fill (java.awt.geom.Ellipse2D$Float. 0 0 width width))
        ;;(.fill (java.awt.geom.RoundRectangle2D$Float. 0 0 width width width width))
        ;; ...then compositing the image on top,
        (.setComposite java.awt.AlphaComposite/SrcAtop)
        (.drawImage image 0 0 nil)
        .dispose)
      circle))

  (defn triangle [image]
    (let [width (.getWidth image)
          triangle (BufferedImage. width width BufferedImage/TYPE_INT_ARGB #_(.getType image))]
      (doto (.createGraphics triangle)
        (.setComposite java.awt.AlphaComposite/Clear)
        (.fillRect 0 0 width width)
        ;; fake soft-clipping by first drawing the desired clip shape in fully
        ;; opaque white with antialiasing enabled...
        (.setComposite java.awt.AlphaComposite/Src)
        (.setRenderingHint java.awt.RenderingHints/KEY_ANTIALIASING java.awt.RenderingHints/VALUE_ANTIALIAS_ON)
        (.setColor (java.awt.Color/WHITE))
        ;;(.fill (java.awt.geom.Ellipse2D$Float. 0 0 width width))
        (.fillPolygon (int-array [0 width 0]) (int-array [width width 0]) 3)
        ;;(.fill (java.awt.geom.RoundRectangle2D$Float. 0 0 width width width width))
        ;; ...then compositing the image on top,
        (.setComposite java.awt.AlphaComposite/SrcAtop)
        (.drawImage image 0 0 nil)
        .dispose)
      triangle))

  ;;(int-array [1 2 3])

  (clojure.java.io/file "/Users/christian/Downloads/klatre-sirkel.png")

  (defn write-png [image filename]
    (javax.imageio.ImageIO/write image "png" (clojure.java.io/file filename)))

  (-> square
      jagged-circle
      (util/save "/Users/christian/Downloads/klatre-rund.jpg"))

  (-> square
      smooth-circle
      (write-png "/Users/christian/Downloads/klatre-sirkel2.png"))

  (-> square
      smooth-circle
      (triangle {:position :upper-right})
      (write-png "/Users/christian/Downloads/klatre-upper-right.png"))

  (-> square
      smooth-circle
      (triangle {:position :upper-left})
      (write-png "/Users/christian/Downloads/klatre-upper-left.png"))

  (-> square
      smooth-circle
      (triangle {:position :lower-left})
      (write-png "/Users/christian/Downloads/klatre-lower-left.png"))

  (-> square
      smooth-circle
      (triangle {:position :lower-right})
      (write-png "/Users/christian/Downloads/klatre-lower-right.png"))

  (-> square
      (triangle {:position :upper-right})
      (write-png "/Users/christian/Downloads/klatre-sq-upper-right.png"))

  (-> square
      (triangle {:position :upper-left})
      (write-png "/Users/christian/Downloads/klatre-sq-upper-left.png"))

  (-> square
      (triangle {:position :lower-left})
      (write-png "/Users/christian/Downloads/klatre-sq-lower-left.png"))

  (-> square
      (triangle {:position :lower-right})
      (write-png "/Users/christian/Downloads/klatre-sq-lower-right.png"))

  (defn duotone [^Raster raster from to]
    (let [dest (.createCompatibleWritableRaster raster)
          bands (.getNumBands dest)
          dest-pixel (int-array bands)
          w (.getWidth raster)
          h (.getHeight raster)
          [rd gd bd] (map #(- %1 %2) to from)
          [r g b] from]
      (loop [y 0]
        (when (< y h)
          (loop [x 0
                 pixel (int-array (repeat bands 0))]
            (when (< x w)
              (let [pixel (.getPixel raster x y pixel)
                    factor (/ (aget pixel 0) 255.0)]
                (aset dest-pixel 0 (int (+ r (* rd factor))))
                (aset dest-pixel 1 (int (+ g (* gd factor))))
                (aset dest-pixel 2 (int (+ b (* bd factor))))
                (.setPixel dest x y dest-pixel)
                (recur (inc x) pixel))))
          (recur (inc y))))
      dest))

  (defn duotone-filter-dotimes [^Raster raster from to]
    (let [dest (.createCompatibleWritableRaster raster)
          bands (.getNumBands dest)
          dest-pixel (int-array bands)
          w (dec (.getWidth raster))
          h (dec (.getHeight raster))
          a (int-array bands)

          ;; Diffs, regn ut kun én gang
          [rd gd bd] (map #(- %1 %2) to from)
          ;; Destrukturer fra-farge én gang
          [r g b] from
          ]
      (dotimes [y h]
        (dotimes [x w]
          (let [pixel (.getPixel raster (inc x) y a)
                grayscale (aget pixel 0) ;; antar gråtone-bilde: R = G = B
                factor (/ grayscale 255.0) ;; "hvor langt fra hvit til svart?"
                ]
            (aset dest-pixel 0 (int (+ r (int (* rd factor)))))
            (aset dest-pixel 1 (int (+ g (int (* gd factor)))))
            (aset dest-pixel 2 (int (+ b (int (* bd factor)))))

            (.setPixel dest x y dest-pixel))))
      dest))

  (defn duotone-image [^BufferedImage image from to]
    (let [color-model (.getColorModel image)
          raster (duotone (.getRaster image) from to)]
      (BufferedImage. color-model raster (.isAlphaPremultiplied color-model) nil)))

  (def raster (.getRaster (grayscale image)))
  (time (duotone raster [255 82 85] [255 255 255]))

  (time
   (-> image
       grayscale
       (duotone-image [255 82 85] [255 255 255])
       (write-png "/Users/christian/Downloads/klatre-duo-java.png")
       ))

  (time
   (-> image
       grayscale
       .getRaster
       (duotone [89 30 30] [255 255 255])
       (write-png "/Users/christian/Downloads/klatre-duo-java-chocolate.png")))


  (-> image
      grayscale
      (duotone )
      (write-png "/Users/christian/Downloads/klatre-sq-lower-right.png"))

  (defn apply-matrix [^java.awt.image.WritableRaster raster matrix]
    (let [bco (java.awt.image.BandCombineOp. (into-array (map float-array matrix)) nil)
          dest-raster (.createCompatibleDestRaster bco raster)]
      (.filter bco raster dest-raster)
      dest-raster))

  ;; BufferedImage in = ImageIO.read(inputFile);
  ;; BufferedImage out = new BufferedImage(in.getWidth(), in.getHeight(), BufferedImage.TYPE_INT_ARGB);
  ;; ColorConvertOp op = new ColorConvertOp(in.getColorModel().getColorSpace(), ColorSpace.getInstance(ColorSpace.CS_GRAY),  null);
  ;; op.filter(in, out);
  ;; ImageIO.write(out, "png", outputFile);



  (let [argb [255 120 120 120]
        from [255 120 0 0]
        to [255 255 255 255]]
    (map (fn [v f t]
           (int (+ f (* (- t f) (/ v 255)))))
         argb from to)
    )

  [120 120 120]

  [(+ 120 ())]

  [120 0 0]

  (defn grayscale [image]
    (let [output (BufferedImage. (.getWidth image) (.getHeight image) (.getType image))]
      (-> (java.awt.image.ColorConvertOp. (.. image getColorModel getColorSpace) (ColorSpace/getInstance ColorSpace/CS_GRAY) nil)
          (.filter image output))
      output))

  (import '[kodemaker Duotone])

  (time (Duotone/filter raster (int-array [255 82 85]) (int-array [255 255 255])))

  (defn duotone [image from to]
    (let [color-model (.getColorModel image)
          raster (Duotone/filter (.getRaster image) (int-array from) (int-array to))]
      (BufferedImage. color-model raster (.isAlphaPremultiplied color-model) nil)))

  (time
   (-> image
       grayscale
       (duotone [255 82 85] [255 255 255])
       (write-png "/Users/christian/Downloads/klatre-duo-java.png")))

  (time
   (-> image
       grayscale
       (duotone [89 30 30] [255 255 255])
       (write-png "/Users/christian/Downloads/klatre-duo-java-chocolate.png")))

  (into []
        (-> image
            grayscale
            .getRaster
            (.getPixel 0 0 nil)
            ))



  (let [arr (int-array [1 2 3])]
    (Duotone/grayscaleToDuotone
     (int-array [224.0 224.0 224.0])
     arr
     (int-array [255 82 85])
     (int-array [255 255 255]))
    (into [] arr))

  (let [tone (/ 224.0 255)]
    (+ 82 (int (* (- 255 82) tone))))

  (defn argb-vec [argb]
    [(bit-and (bit-shift-right argb 24) 0xff)
     (bit-and (bit-shift-right argb 16) 0xff)
     (bit-and (bit-shift-right argb 8) 0xff)
     (bit-and argb 0xff)])

  (defn duotone-rgb [v from to]
    (let [input (argb-vec v)
          output (map (fn [v f t]
                        (int (+ f (* (- t f) (/ v 255)))))
                      input from to)]
      (.getRGB (java.awt.Color. (nth output 1) (nth output 2) (nth output 3) (nth output 0)))))

  (defn duotone [image from to]
    (let [w (.getWidth image)
          h (.getHeight image)
          image (grayscale image)
          output (BufferedImage. w h (.getType image))]
      (doseq [x (range w)
              y (range h)]
        (.setRGB output x y (duotone-rgb (.getRGB image x y) from to)))
      output))

  (time
   (-> image
       (duotone [255 255 82 85] [255 255 255 255])
       (write-png "/Users/christian/Downloads/klatre-duo3.png")))

  (defn create-compatible-dest-raster [^java.awt.image.Raster raster]
    (.createCompatibleWritableRaster raster))

  (set! *unchecked-math* :warn-on-boxed)



  (time
   (duotone-filter (.getRaster image)))

  (def raster (.getRaster image))
  (time
   (kodemaker.Fuck/filter raster (.createCompatibleWritableRaster raster)))


  (type (.getRaster image))

  ;; (defn duotone [image from to]
  ;;   (let [color-model (.getColorModel image)
  ;;         op (java.awt.image.ColorConvertOp. )
  ;;         dest-raster (.createCompatibleDestRaster op (.getRaster image))]
  ;;     (.filter op raster dest-raster)
  ;;     (BufferedImage. color-model dest-raster (.isAlphaPremultiplied color-model) nil)))


  (.getRGB image 0 0)

  ;; (proxy [ColorSpace] []
  ;;   (fromCIEXYZ [color-value]
  ;;     (float-array [0 0 0]))

  ;;   (fromRGB [color-value]
  ;;     (float-array [0 0 0])))

  (into [] (.fromRGB (ColorSpace/getInstance ColorSpace/CS_GRAY) (float-array [0.5 0.5 0.5])))
  (into [] (.fromRGB (ColorSpace/getInstance ColorSpace/CS_LINEAR_RGB) (float-array [0.25 0.75 1])))


  (defn duotonize [pixels offset x from diff]
    (let [idx (+ offset x)
          v (aget pixels idx)
          f (nth from x)
          d (nth diff x)]
      (aset pixels idx (int (+ f (* d (/ v 255)))))))

  (def a (int-array [120 120 120]))
  (duotonize a 0 0 [255 234 109] [0 21 146])
  (duotonize a 0 1 [255 234 109] [0 21 146])
  (duotonize a 0 2 [255 234 109] [0 21 146])
  (into [] a)

  ;; (defn duotone [image from to]
  ;;   (let [image (grayscale image)
  ;;         raster (.getRaster image)
  ;;         color-model (.getColorModel image)
  ;;         components (.getNumComponents color-model)
  ;;         w (.getWidth image)
  ;;         h (.getHeight image)
  ;;         pixels (->> (int-array (* w h components))
  ;;                     (.getPixels raster 0 0 w h))
  ;;         diff (map #(- %1 %2) to from)]
  ;;     (doseq [offset (range (/ (count pixels) components))]
  ;;       (duotonize pixels offset 0 from diff)
  ;;       (duotonize pixels offset 1 from diff)
  ;;       (duotonize pixels offset 2 from diff))
  ;;     (.setPixels raster 0 0 w h pixels)
  ;;     (BufferedImage. color-model raster (.isAlphaPremultiplied color-model) nil)))

  (def a (int-array 5))
  (aset a 0 1)
  (count a)
  (prn (into [] a))

  (time
   (-> image
       (duotone [255 255 82 85] [255 255 255 255])
       (write-png "/Users/christian/Downloads/klatre-duo2.png")))

  (time
   (duotone (triangle image {:position :upper-left}) [] []))

  (defn get-pixels [image]
    (let [w (.getWidth image)
          h (.getHeight image)
          raster (.getRaster image)
          components (.getNumComponents (.getColorModel image))]
      (.getPixels raster 0 0 w h (int-array (* w h components)))))

  (time
   (get-pixels image))

  (.getNumComponents (.getColorModel image))

  (time
   (let [w (.getWidth image)
         h (.getHeight image)]
     (.getPixels (.getRaster image) 0 0 w h (int-array (* w h 3)))))

  (-> image
      (duotone [255 255 82 85] [255 255 255 255])
      (write-png "/Users/christian/Downloads/klatre-duo.png"))

  (-> image
      (duotone [255 89 30 30] [255 255 255 255])
      (write-png "/Users/christian/Downloads/klatre-chocolate.png"))






  (defn duotone [image]
    (let [gray-matrix [[0.11 0.59 0.3]
                       [0.11 0.59 0.3]
                       [0.11 0.59 0.3]]
          duotone-matrix [[0 0.62 0]
                          [0 0.2 0]
                          [0 0.18 0]]
          color-model (.getColorModel image)
          duotone-raster (-> (.getRaster image)
                             (apply-matrix gray-matrix)
                             ;;(apply-matrix duotone-matrix)
                             )]
      (BufferedImage. color-model duotone-raster (.isAlphaPremultiplied color-model) nil)))




  (bit-and (bit-shift-right -3487030 8) 0xff)

  (* 120 0x100)

[255 202 202 202]

(argb-vec (.getRGB (java.awt.Color. 202 202 202)))

(let [w 100
      h 100
      image (java.awt.image.BufferedImage. w h BufferedImage/TYPE_INT_ARGB)]
  (doseq [x (range w)
          y (range h)]
    (.setRGB image x y (.getRGB (java.awt.Color. 202 202 202 255))))
  (write-png image "/Users/christian/Downloads/gray.png"))

(argb-vec
 (bit-or (bit-shift-left 255 24)
         (bit-shift-left 202 16)
         (bit-shift-left 202 8)
         202)
 )

(-> image
      duotone
      (.getRGB 0 0)
      ;;argb-vec
      )

(-> image
    duotone
    (write-png "/Users/christian/Downloads/klatre-duotone.png"))


;;   BufferedImage src = ImageIO.read(new File("X:\\photoshop_image_effects.jpg"));
;;     WritableRaster srcRaster = src.getRaster();

;;     // make it gray
;;     BandCombineOp bco = new BandCombineOp(grayMatrix, null);
;;     WritableRaster dstRaster = bco.createCompatibleDestRaster(srcRaster);
;;     bco.filter(srcRaster, dstRaster);

;;     // apply duotone
;;     BandCombineOp duoToneBco = new BandCombineOp(duoToneMatrix, null);
;;     WritableRaster dstRaster2 = bco.createCompatibleDestRaster(dstRaster);
;;     duoToneBco.filter(dstRaster, dstRaster2);

;;     BufferedImage result = new BufferedImage(
;;                                              src.getColorModel(),
;;                                              dstRaster2,
;;                                              src.getColorModel().isAlphaPremultiplied(),
;;                                              null);
;;     ImageIO.write(result, "png", new File("X:\\result_duotone.png"));



;; java.awt.geom.Ellipse2D$Float

;; int width = bufferedImage.getWidth();
;; BufferedImage circleBuffer = new BufferedImage(width, width, BufferedImage.TYPE_INT_ARGB);
;; Graphics2D g2 = circleBuffer.createGraphics();
;; g2.setClip(new Ellipse2D.Float(0, 0, width, width));
;; g2.drawImage(bufferedImage, 0, 0, width, width, null);

(util/save image "/Users/christian/Downloads/klatre-rund.jpg" :quality 1.0)

  )





(import '[javax.imageio ImageIO]
        '[java.awt.image BufferedImage])
(require '[clojure.java.io :as io])

(def image (ImageIO/read (io/file "/Users/christian/Downloads/klatre.png")))

;;(import '[kodemaker Duotone])

(import '[java.awt.image Raster])

(defn duotone-filter-loop [^Raster raster]
  (let [dest (.createCompatibleWritableRaster raster)
        bands (.getNumBands dest)
        dest-pixel (int-array bands)
        w (.getWidth raster)
        h (.getHeight raster)]
    (loop [y 0]
      (when (< y h)
        (loop [x 0
               pixel (int-array bands)]
          (when (< x w)
            (let [pixel (.getPixel raster x y pixel)]
              (aset dest-pixel 0 (int (aget pixel 2)))
              (aset dest-pixel 1 (int (aget pixel 1)))
              (aset dest-pixel 2 (int (aget pixel 0)))
              (.setPixel dest x y dest-pixel)
              (recur (inc x) pixel))))
        (recur (inc y))))
    dest))

(defn duotone-filter-dotimes [^Raster raster]
  (let [dest (.createCompatibleWritableRaster raster)
        bands (.getNumBands dest)
        dest-pixel (int-array bands)
        w (dec (.getWidth raster))
        h (dec (.getHeight raster))
        a (int-array bands)]
    (dotimes [y h]
      (dotimes [x w]
        (let [pixel (.getPixel raster (inc x) y a)]
          (aset dest-pixel 0 (aget pixel 2))
          (aset dest-pixel 1 (aget pixel 1))
          (aset dest-pixel 2 (aget pixel 0))
          (.setPixel dest x y dest-pixel))))
    dest))

(defn duotone-filter-for [^Raster raster]
  (let [dest (.createCompatibleWritableRaster raster)
        bands (.getNumBands dest)
        dest-pixel (int-array bands)
        w  (range (dec (.getWidth raster)))
        h  (range (dec (.getHeight raster)))
        a (int-array bands)]
    (doall (for [^long y h
                 ^long x w
                 :let [pixel (.getPixel raster (inc x) y a)]]
             (do
               (aset dest-pixel 0 (aget pixel 2))
               (aset dest-pixel 1 (aget pixel 1))
               (aset dest-pixel 2 (aget pixel 0))
               (.setPixel dest x y dest-pixel))))
    dest))

(def raster (.getRaster image))

(time
 (do
   (println "loop")
   (dotimes [y 100]
     (duotone-filter-loop raster))))

(time
 (do
   (println "dotimes")
   (dotimes [y 100]
     (duotone-filter-dotimes raster))))

(time
 (do
   (println "for")
   (dotimes [y 100]
     (duotone-filter-for raster))))
(.getHeight raster)
(prn "dotimes")
(time
 (let [raster (duotone-filter (.getRaster image))
       color-model (.getColorModel image)
       image (BufferedImage. color-model raster (.isAlphaPremultiplied color-model) nil)]
   (ImageIO/write image "png" (clojure.java.io/file "/tmp/out.png"))))

(println "loop"
         (/ (+ 349.956947
               282.733385
               280.410938
               271.585995
               273.4487
               277.182977
               289.916504
               272.693191
               281.46049
               270.778282)
            10))

(println "dotimes"
         (/ (+ 317.080149
               365.80282
               329.96818
               281.780288
               271.485665
               288.565485
               281.651308
               278.648044
               278.708436
               274.289754)
            10))

(println "loop med pixel inisialisert til nil"
         (/ (+ 333.487988
               297.962589
               291.961554
               280.058315
               289.545747
               280.887278
               282.007036
               280.940019
               388.603486
               358.361414)
            10)
         )
