// Compiled by ClojureScript 1.10.866 {:optimizations :none}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('react');
sablono.core.global$module$react = goog.global["React"];
/**
 * The React.js create element function.
 */
sablono.core.create_element = sablono.core.global$module$react.createElement;
/**
 * The React.js Fragment.
 */
sablono.core.fragment = sablono.core.global$module$react.Fragment;
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__26383__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__26380 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__26381 = cljs.core.seq.call(null,vec__26380);
var first__26382 = cljs.core.first.call(null,seq__26381);
var seq__26381__$1 = cljs.core.next.call(null,seq__26381);
var tag = first__26382;
var body = seq__26381__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args))], null),cljs.core.rest.call(null,body));
} else {
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.first.call(null,args)], null),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__26383 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__26384__i = 0, G__26384__a = new Array(arguments.length -  0);
while (G__26384__i < G__26384__a.length) {G__26384__a[G__26384__i] = arguments[G__26384__i + 0]; ++G__26384__i;}
  args = new cljs.core.IndexedSeq(G__26384__a,0,null);
} 
return G__26383__delegate.call(this,args);};
G__26383.cljs$lang$maxFixedArity = 0;
G__26383.cljs$lang$applyTo = (function (arglist__26385){
var args = cljs.core.seq(arglist__26385);
return G__26383__delegate(args);
});
G__26383.cljs$core$IFn$_invoke$arity$variadic = G__26383__delegate;
return G__26383;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__4622__auto__ = (function sablono$core$update_arglists_$_iter__26386(s__26387){
return (new cljs.core.LazySeq(null,(function (){
var s__26387__$1 = s__26387;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__26387__$1);
if(temp__5753__auto__){
var s__26387__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__26387__$2)){
var c__4620__auto__ = cljs.core.chunk_first.call(null,s__26387__$2);
var size__4621__auto__ = cljs.core.count.call(null,c__4620__auto__);
var b__26389 = cljs.core.chunk_buffer.call(null,size__4621__auto__);
if((function (){var i__26388 = (0);
while(true){
if((i__26388 < size__4621__auto__)){
var args = cljs.core._nth.call(null,c__4620__auto__,i__26388);
cljs.core.chunk_append.call(null,b__26389,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__26390 = (i__26388 + (1));
i__26388 = G__26390;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26389),sablono$core$update_arglists_$_iter__26386.call(null,cljs.core.chunk_rest.call(null,s__26387__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26389),null);
}
} else {
var args = cljs.core.first.call(null,s__26387__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__26386.call(null,cljs.core.rest.call(null,s__26387__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__.call(null,arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__4835__auto__ = [];
var len__4829__auto___26396 = arguments.length;
var i__4830__auto___26397 = (0);
while(true){
if((i__4830__auto___26397 < len__4829__auto___26396)){
args__4835__auto__.push((arguments[i__4830__auto___26397]));

var G__26398 = (i__4830__auto___26397 + (1));
i__4830__auto___26397 = G__26398;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__4622__auto__ = (function sablono$core$iter__26392(s__26393){
return (new cljs.core.LazySeq(null,(function (){
var s__26393__$1 = s__26393;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__26393__$1);
if(temp__5753__auto__){
var s__26393__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__26393__$2)){
var c__4620__auto__ = cljs.core.chunk_first.call(null,s__26393__$2);
var size__4621__auto__ = cljs.core.count.call(null,c__4620__auto__);
var b__26395 = cljs.core.chunk_buffer.call(null,size__4621__auto__);
if((function (){var i__26394 = (0);
while(true){
if((i__26394 < size__4621__auto__)){
var style = cljs.core._nth.call(null,c__4620__auto__,i__26394);
cljs.core.chunk_append.call(null,b__26395,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__26399 = (i__26394 + (1));
i__26394 = G__26399;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26395),sablono$core$iter__26392.call(null,cljs.core.chunk_rest.call(null,s__26393__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26395),null);
}
} else {
var style = cljs.core.first.call(null,s__26393__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__26392.call(null,cljs.core.rest.call(null,s__26393__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__.call(null,styles);
}));

(sablono.core.include_css.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(sablono.core.include_css.cljs$lang$applyTo = (function (seq26391){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq26391));
}));

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to26400 = (function sablono$core$link_to26400(var_args){
var args__4835__auto__ = [];
var len__4829__auto___26403 = arguments.length;
var i__4830__auto___26404 = (0);
while(true){
if((i__4830__auto___26404 < len__4829__auto___26403)){
args__4835__auto__.push((arguments[i__4830__auto___26404]));

var G__26405 = (i__4830__auto___26404 + (1));
i__4830__auto___26404 = G__26405;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to26400.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(sablono.core.link_to26400.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
}));

(sablono.core.link_to26400.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sablono.core.link_to26400.cljs$lang$applyTo = (function (seq26401){
var G__26402 = cljs.core.first.call(null,seq26401);
var seq26401__$1 = cljs.core.next.call(null,seq26401);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__26402,seq26401__$1);
}));


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to26400);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to26406 = (function sablono$core$mail_to26406(var_args){
var args__4835__auto__ = [];
var len__4829__auto___26413 = arguments.length;
var i__4830__auto___26414 = (0);
while(true){
if((i__4830__auto___26414 < len__4829__auto___26413)){
args__4835__auto__.push((arguments[i__4830__auto___26414]));

var G__26415 = (i__4830__auto___26414 + (1));
i__4830__auto___26414 = G__26415;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to26406.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(sablono.core.mail_to26406.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__26409){
var vec__26410 = p__26409;
var content = cljs.core.nth.call(null,vec__26410,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),["mailto:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__4223__auto__ = content;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return e_mail;
}
})()], null);
}));

(sablono.core.mail_to26406.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sablono.core.mail_to26406.cljs$lang$applyTo = (function (seq26407){
var G__26408 = cljs.core.first.call(null,seq26407);
var seq26407__$1 = cljs.core.next.call(null,seq26407);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__26408,seq26407__$1);
}));


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to26406);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list26416 = (function sablono$core$unordered_list26416(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__4622__auto__ = (function sablono$core$unordered_list26416_$_iter__26417(s__26418){
return (new cljs.core.LazySeq(null,(function (){
var s__26418__$1 = s__26418;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__26418__$1);
if(temp__5753__auto__){
var s__26418__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__26418__$2)){
var c__4620__auto__ = cljs.core.chunk_first.call(null,s__26418__$2);
var size__4621__auto__ = cljs.core.count.call(null,c__4620__auto__);
var b__26420 = cljs.core.chunk_buffer.call(null,size__4621__auto__);
if((function (){var i__26419 = (0);
while(true){
if((i__26419 < size__4621__auto__)){
var x = cljs.core._nth.call(null,c__4620__auto__,i__26419);
cljs.core.chunk_append.call(null,b__26420,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__26421 = (i__26419 + (1));
i__26419 = G__26421;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26420),sablono$core$unordered_list26416_$_iter__26417.call(null,cljs.core.chunk_rest.call(null,s__26418__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26420),null);
}
} else {
var x = cljs.core.first.call(null,s__26418__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list26416_$_iter__26417.call(null,cljs.core.rest.call(null,s__26418__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list26416);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list26422 = (function sablono$core$ordered_list26422(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__4622__auto__ = (function sablono$core$ordered_list26422_$_iter__26423(s__26424){
return (new cljs.core.LazySeq(null,(function (){
var s__26424__$1 = s__26424;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__26424__$1);
if(temp__5753__auto__){
var s__26424__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__26424__$2)){
var c__4620__auto__ = cljs.core.chunk_first.call(null,s__26424__$2);
var size__4621__auto__ = cljs.core.count.call(null,c__4620__auto__);
var b__26426 = cljs.core.chunk_buffer.call(null,size__4621__auto__);
if((function (){var i__26425 = (0);
while(true){
if((i__26425 < size__4621__auto__)){
var x = cljs.core._nth.call(null,c__4620__auto__,i__26425);
cljs.core.chunk_append.call(null,b__26426,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__26427 = (i__26425 + (1));
i__26425 = G__26427;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26426),sablono$core$ordered_list26422_$_iter__26423.call(null,cljs.core.chunk_rest.call(null,s__26424__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26426),null);
}
} else {
var x = cljs.core.first.call(null,s__26424__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list26422_$_iter__26423.call(null,cljs.core.rest.call(null,s__26424__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list26422);
/**
 * Create an image element.
 */
sablono.core.image26428 = (function sablono$core$image26428(var_args){
var G__26430 = arguments.length;
switch (G__26430) {
case 1:
return sablono.core.image26428.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image26428.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.image26428.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
}));

(sablono.core.image26428.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
}));

(sablono.core.image26428.cljs$lang$maxFixedArity = 2);


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image26428);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__26432_SHARP_,p2__26433_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__26432_SHARP_),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__26433_SHARP_),"]"].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__26434_SHARP_,p2__26435_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__26434_SHARP_),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__26435_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(var_args){
var G__26437 = arguments.length;
switch (G__26437) {
case 2:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (type,name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null)], null);
}));

(sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4223__auto__ = value;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return undefined;
}
})()], null)], null);
}));

(sablono.core.input_field_STAR_.cljs$lang$maxFixedArity = 3);

/**
 * Creates a color input field.
 */
sablono.core.color_field26439 = (function sablono$core$color_field26439(var_args){
var G__26441 = arguments.length;
switch (G__26441) {
case 1:
return sablono.core.color_field26439.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field26439.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.color_field26439.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null)),name__26370__auto__);
}));

(sablono.core.color_field26439.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.color_field26439.cljs$lang$maxFixedArity = 2);


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field26439);

/**
 * Creates a date input field.
 */
sablono.core.date_field26442 = (function sablono$core$date_field26442(var_args){
var G__26444 = arguments.length;
switch (G__26444) {
case 1:
return sablono.core.date_field26442.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field26442.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.date_field26442.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null)),name__26370__auto__);
}));

(sablono.core.date_field26442.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.date_field26442.cljs$lang$maxFixedArity = 2);


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field26442);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field26445 = (function sablono$core$datetime_field26445(var_args){
var G__26447 = arguments.length;
switch (G__26447) {
case 1:
return sablono.core.datetime_field26445.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field26445.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.datetime_field26445.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null)),name__26370__auto__);
}));

(sablono.core.datetime_field26445.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.datetime_field26445.cljs$lang$maxFixedArity = 2);


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field26445);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field26448 = (function sablono$core$datetime_local_field26448(var_args){
var G__26450 = arguments.length;
switch (G__26450) {
case 1:
return sablono.core.datetime_local_field26448.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field26448.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.datetime_local_field26448.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null)),name__26370__auto__);
}));

(sablono.core.datetime_local_field26448.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.datetime_local_field26448.cljs$lang$maxFixedArity = 2);


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field26448);

/**
 * Creates a email input field.
 */
sablono.core.email_field26451 = (function sablono$core$email_field26451(var_args){
var G__26453 = arguments.length;
switch (G__26453) {
case 1:
return sablono.core.email_field26451.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field26451.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.email_field26451.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null)),name__26370__auto__);
}));

(sablono.core.email_field26451.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.email_field26451.cljs$lang$maxFixedArity = 2);


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field26451);

/**
 * Creates a file input field.
 */
sablono.core.file_field26454 = (function sablono$core$file_field26454(var_args){
var G__26456 = arguments.length;
switch (G__26456) {
case 1:
return sablono.core.file_field26454.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field26454.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.file_field26454.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null)),name__26370__auto__);
}));

(sablono.core.file_field26454.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.file_field26454.cljs$lang$maxFixedArity = 2);


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field26454);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field26457 = (function sablono$core$hidden_field26457(var_args){
var G__26459 = arguments.length;
switch (G__26459) {
case 1:
return sablono.core.hidden_field26457.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field26457.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.hidden_field26457.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null)),name__26370__auto__);
}));

(sablono.core.hidden_field26457.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.hidden_field26457.cljs$lang$maxFixedArity = 2);


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field26457);

/**
 * Creates a month input field.
 */
sablono.core.month_field26460 = (function sablono$core$month_field26460(var_args){
var G__26462 = arguments.length;
switch (G__26462) {
case 1:
return sablono.core.month_field26460.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field26460.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.month_field26460.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null)),name__26370__auto__);
}));

(sablono.core.month_field26460.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.month_field26460.cljs$lang$maxFixedArity = 2);


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field26460);

/**
 * Creates a number input field.
 */
sablono.core.number_field26463 = (function sablono$core$number_field26463(var_args){
var G__26465 = arguments.length;
switch (G__26465) {
case 1:
return sablono.core.number_field26463.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field26463.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.number_field26463.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null)),name__26370__auto__);
}));

(sablono.core.number_field26463.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.number_field26463.cljs$lang$maxFixedArity = 2);


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field26463);

/**
 * Creates a password input field.
 */
sablono.core.password_field26466 = (function sablono$core$password_field26466(var_args){
var G__26468 = arguments.length;
switch (G__26468) {
case 1:
return sablono.core.password_field26466.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field26466.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.password_field26466.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null)),name__26370__auto__);
}));

(sablono.core.password_field26466.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.password_field26466.cljs$lang$maxFixedArity = 2);


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field26466);

/**
 * Creates a range input field.
 */
sablono.core.range_field26469 = (function sablono$core$range_field26469(var_args){
var G__26471 = arguments.length;
switch (G__26471) {
case 1:
return sablono.core.range_field26469.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field26469.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.range_field26469.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null)),name__26370__auto__);
}));

(sablono.core.range_field26469.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.range_field26469.cljs$lang$maxFixedArity = 2);


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field26469);

/**
 * Creates a search input field.
 */
sablono.core.search_field26472 = (function sablono$core$search_field26472(var_args){
var G__26474 = arguments.length;
switch (G__26474) {
case 1:
return sablono.core.search_field26472.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field26472.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.search_field26472.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null)),name__26370__auto__);
}));

(sablono.core.search_field26472.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.search_field26472.cljs$lang$maxFixedArity = 2);


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field26472);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field26475 = (function sablono$core$tel_field26475(var_args){
var G__26477 = arguments.length;
switch (G__26477) {
case 1:
return sablono.core.tel_field26475.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field26475.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.tel_field26475.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null)),name__26370__auto__);
}));

(sablono.core.tel_field26475.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.tel_field26475.cljs$lang$maxFixedArity = 2);


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field26475);

/**
 * Creates a text input field.
 */
sablono.core.text_field26478 = (function sablono$core$text_field26478(var_args){
var G__26480 = arguments.length;
switch (G__26480) {
case 1:
return sablono.core.text_field26478.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field26478.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.text_field26478.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null)),name__26370__auto__);
}));

(sablono.core.text_field26478.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.text_field26478.cljs$lang$maxFixedArity = 2);


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field26478);

/**
 * Creates a time input field.
 */
sablono.core.time_field26481 = (function sablono$core$time_field26481(var_args){
var G__26483 = arguments.length;
switch (G__26483) {
case 1:
return sablono.core.time_field26481.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field26481.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.time_field26481.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null)),name__26370__auto__);
}));

(sablono.core.time_field26481.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.time_field26481.cljs$lang$maxFixedArity = 2);


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field26481);

/**
 * Creates a url input field.
 */
sablono.core.url_field26484 = (function sablono$core$url_field26484(var_args){
var G__26486 = arguments.length;
switch (G__26486) {
case 1:
return sablono.core.url_field26484.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field26484.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.url_field26484.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null)),name__26370__auto__);
}));

(sablono.core.url_field26484.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.url_field26484.cljs$lang$maxFixedArity = 2);


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field26484);

/**
 * Creates a week input field.
 */
sablono.core.week_field26487 = (function sablono$core$week_field26487(var_args){
var G__26489 = arguments.length;
switch (G__26489) {
case 1:
return sablono.core.week_field26487.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field26487.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.week_field26487.cljs$core$IFn$_invoke$arity$1 = (function (name__26370__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null)),name__26370__auto__);
}));

(sablono.core.week_field26487.cljs$core$IFn$_invoke$arity$2 = (function (name__26370__auto__,value__26371__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null)),name__26370__auto__,value__26371__auto__);
}));

(sablono.core.week_field26487.cljs$lang$maxFixedArity = 2);


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field26487);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box26507 = (function sablono$core$check_box26507(var_args){
var G__26509 = arguments.length;
switch (G__26509) {
case 1:
return sablono.core.check_box26507.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box26507.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box26507.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.check_box26507.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null)], null);
}));

(sablono.core.check_box26507.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.check_box26507.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.check_box26507.cljs$lang$maxFixedArity = 3);


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box26507);
/**
 * Creates a radio button.
 */
sablono.core.radio_button26511 = (function sablono$core$radio_button26511(var_args){
var G__26513 = arguments.length;
switch (G__26513) {
case 1:
return sablono.core.radio_button26511.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button26511.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button26511.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.radio_button26511.cljs$core$IFn$_invoke$arity$1 = (function (group){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,sablono.util.as_str.call(null,group))], null)], null);
}));

(sablono.core.radio_button26511.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,sablono.util.as_str.call(null,group)),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.radio_button26511.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[sablono.util.as_str.call(null,group),"-",sablono.util.as_str.call(null,value)].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.radio_button26511.cljs$lang$maxFixedArity = 3);


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button26511);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options26515 = (function sablono$core$select_options26515(coll){
var iter__4622__auto__ = (function sablono$core$select_options26515_$_iter__26516(s__26517){
return (new cljs.core.LazySeq(null,(function (){
var s__26517__$1 = s__26517;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__26517__$1);
if(temp__5753__auto__){
var s__26517__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__26517__$2)){
var c__4620__auto__ = cljs.core.chunk_first.call(null,s__26517__$2);
var size__4621__auto__ = cljs.core.count.call(null,c__4620__auto__);
var b__26519 = cljs.core.chunk_buffer.call(null,size__4621__auto__);
if((function (){var i__26518 = (0);
while(true){
if((i__26518 < size__4621__auto__)){
var x = cljs.core._nth.call(null,c__4620__auto__,i__26518);
cljs.core.chunk_append.call(null,b__26519,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__26520 = x;
var text = cljs.core.nth.call(null,vec__26520,(0),null);
var val = cljs.core.nth.call(null,vec__26520,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__26520,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options26515.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__26526 = (i__26518 + (1));
i__26518 = G__26526;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26519),sablono$core$select_options26515_$_iter__26516.call(null,cljs.core.chunk_rest.call(null,s__26517__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26519),null);
}
} else {
var x = cljs.core.first.call(null,s__26517__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__26523 = x;
var text = cljs.core.nth.call(null,vec__26523,(0),null);
var val = cljs.core.nth.call(null,vec__26523,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__26523,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options26515.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options26515_$_iter__26516.call(null,cljs.core.rest.call(null,s__26517__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options26515);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down26527 = (function sablono$core$drop_down26527(var_args){
var G__26529 = arguments.length;
switch (G__26529) {
case 2:
return sablono.core.drop_down26527.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down26527.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.drop_down26527.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down26527.call(null,name,options,null);
}));

(sablono.core.drop_down26527.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
}));

(sablono.core.drop_down26527.cljs$lang$maxFixedArity = 3);


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down26527);
/**
 * Creates a text area element.
 */
sablono.core.text_area26531 = (function sablono$core$text_area26531(var_args){
var G__26533 = arguments.length;
switch (G__26533) {
case 1:
return sablono.core.text_area26531.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area26531.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.text_area26531.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null)], null);
}));

(sablono.core.text_area26531.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4223__auto__ = value;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return undefined;
}
})()], null)], null);
}));

(sablono.core.text_area26531.cljs$lang$maxFixedArity = 2);


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area26531);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label26535 = (function sablono$core$label26535(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label26535);
/**
 * Creates a submit button.
 */
sablono.core.submit_button26536 = (function sablono$core$submit_button26536(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button26536);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button26537 = (function sablono$core$reset_button26537(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button26537);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to26538 = (function sablono$core$form_to26538(var_args){
var args__4835__auto__ = [];
var len__4829__auto___26545 = arguments.length;
var i__4830__auto___26546 = (0);
while(true){
if((i__4830__auto___26546 < len__4829__auto___26545)){
args__4835__auto__.push((arguments[i__4830__auto___26546]));

var G__26547 = (i__4830__auto___26546 + (1));
i__4830__auto___26546 = G__26547;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to26538.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(sablono.core.form_to26538.cljs$core$IFn$_invoke$arity$variadic = (function (p__26541,body){
var vec__26542 = p__26541;
var method = cljs.core.nth.call(null,vec__26542,(0),null);
var action = cljs.core.nth.call(null,vec__26542,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
}));

(sablono.core.form_to26538.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sablono.core.form_to26538.cljs$lang$applyTo = (function (seq26539){
var G__26540 = cljs.core.first.call(null,seq26539);
var seq26539__$1 = cljs.core.next.call(null,seq26539);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__26540,seq26539__$1);
}));


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to26538);

//# sourceMappingURL=core.js.map
