// Compiled by ClojureScript 1.10.866 {:optimizations :none}
goog.provide('dumdom.core');
goog.require('cljs.core');
goog.require('dumdom.component');
goog.require('dumdom.dom');
goog.require('dumdom.element');
goog.require('dumdom.string');
goog.require('snabbdom');
/**
 * A mapping from root DOM nodes to currently rendered virtual DOM trees. Used to
 *   reconcile (render component dom-node) to (patch old-vdom new-vdom)
 */
dumdom.core.current_nodes = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
 * A counter used to assign unique ids to root elements
 */
dumdom.core.element_id = cljs.core.atom.call(null,(-1));
dumdom.core.rendering_QMARK_ = cljs.core.atom.call(null,false);
/**
 * The snabbdom patch function used by render
 */
dumdom.core.patch = snabbdom.init([snabbdom.eventListenersModule,snabbdom.attributesModule,snabbdom.propsModule,snabbdom.styleModule,snabbdom.datasetModule]);
dumdom.core.set_root_id = (function dumdom$core$set_root_id(element){
return (element.dataset.dumdomId = cljs.core.swap_BANG_.call(null,dumdom.core.element_id,cljs.core.inc));
});
dumdom.core.root_node = (function dumdom$core$root_node(element){
return cljs.core.deref.call(null,dumdom.core.current_nodes).call(null,element.dataset.dumdomId);
});
dumdom.core.register_vnode = (function dumdom$core$register_vnode(element_id,vnode){
return cljs.core.swap_BANG_.call(null,dumdom.core.current_nodes,cljs.core.assoc,element_id,vnode);
});
dumdom.core.unregister_vnode = (function dumdom$core$unregister_vnode(element_id){
return cljs.core.swap_BANG_.call(null,dumdom.core.current_nodes,cljs.core.dissoc,element_id);
});
/**
 * Snabbdom will replace the element provided as the original target for patch.
 *   When rendering into a new DOM node, we therefore create an intermediate in it
 *   and use that as Snabbdom's root, to avoid destroying the provided root node.
 */
dumdom.core.init_node_BANG_ = (function dumdom$core$init_node_BANG_(element){
(element.innerHTML = "<div></div>");

dumdom.core.set_root_id.call(null,element);

return element.firstElementChild;
});
dumdom.core.purge_BANG_ = (function dumdom$core$purge_BANG_(){
return cljs.core.reset_BANG_.call(null,dumdom.core.current_nodes,cljs.core.PersistentArrayMap.EMPTY);
});
dumdom.core.create_vdom = (function dumdom$core$create_vdom(component,element_id,p__38020){
var map__38021 = p__38020;
var map__38021__$1 = cljs.core.__destructure_map.call(null,map__38021);
var handle_event = cljs.core.get.call(null,map__38021__$1,new cljs.core.Keyword(null,"handle-event","handle-event",2098778308));
var temp__5753__auto__ = dumdom.element.inflate_hiccup.call(null,component);
if(cljs.core.truth_(temp__5753__auto__)){
var component__$1 = temp__5753__auto__;
var _STAR_handle_event_STAR__orig_val__38022 = dumdom.element._STAR_handle_event_STAR_;
var _STAR_handle_event_STAR__temp_val__38023 = (function (){var or__4223__auto__ = handle_event;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return dumdom.element._STAR_handle_event_STAR_;
}
})();
(dumdom.element._STAR_handle_event_STAR_ = _STAR_handle_event_STAR__temp_val__38023);

try{var G__38024 = component__$1.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [element_id], null),cljs.core.PersistentArrayMap.EMPTY);
if((G__38024 == null)){
return null;
} else {
return cljs.core.clj__GT_js.call(null,G__38024);
}
}finally {(dumdom.element._STAR_handle_event_STAR_ = _STAR_handle_event_STAR__orig_val__38022);
}} else {
return null;
}
});
dumdom.core.set_event_handler_BANG_ = (function dumdom$core$set_event_handler_BANG_(f){
if(cljs.core.truth_((function (){var and__4221__auto__ = f;
if(cljs.core.truth_(and__4221__auto__)){
return (!(cljs.core.ifn_QMARK_.call(null,f)));
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Event handler must be a function",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"f","f",-1597136552),f], null));
} else {
}

return (dumdom.element._STAR_handle_event_STAR_ = f);
});
/**
 * Dispatch
 */
dumdom.core.dispatch_event_data = (function dumdom$core$dispatch_event_data(e,data){
if(cljs.core.truth_(dumdom.element._STAR_handle_event_STAR_)){
if(cljs.core.truth_(cljs.core.deref.call(null,dumdom.core.rendering_QMARK_))){
return requestAnimationFrame((function (){
return dumdom.element._STAR_handle_event_STAR_.call(null,e,data);
}));
} else {
return dumdom.element._STAR_handle_event_STAR_.call(null,e,data);
}
} else {
throw (new Error("Cannot dispatch custom event data without a global event handler. Call dumdom.core/set-event-handler!"));
}
});
goog.exportSymbol('dumdom.core.dispatch_event_data', dumdom.core.dispatch_event_data);
/**
 * Render the virtual DOM node created by the component into the specified DOM
 *   element, and mount it for fast future re-renders.
 */
dumdom.core.render = (function dumdom$core$render(var_args){
var args__4835__auto__ = [];
var len__4829__auto___38032 = arguments.length;
var i__4830__auto___38033 = (0);
while(true){
if((i__4830__auto___38033 < len__4829__auto___38032)){
args__4835__auto__.push((arguments[i__4830__auto___38033]));

var G__38034 = (i__4830__auto___38033 + (1));
i__4830__auto___38033 = G__38034;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return dumdom.core.render.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(dumdom.core.render.cljs$core$IFn$_invoke$arity$variadic = (function (component,element,p__38028){
var vec__38029 = p__38028;
var opt = cljs.core.nth.call(null,vec__38029,(0),null);
cljs.core.reset_BANG_.call(null,dumdom.core.rendering_QMARK_,true);

if(cljs.core.truth_((function (){var and__4221__auto__ = new cljs.core.Keyword(null,"handle-event","handle-event",2098778308).cljs$core$IFn$_invoke$arity$1(opt);
if(cljs.core.truth_(and__4221__auto__)){
return (!(cljs.core.ifn_QMARK_.call(null,new cljs.core.Keyword(null,"handle-event","handle-event",2098778308).cljs$core$IFn$_invoke$arity$1(opt))));
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Called dumdom.core/render with a handle-event that is not a function",opt);
} else {
}

var current_node = (function (){var or__4223__auto__ = dumdom.core.root_node.call(null,element);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return dumdom.core.init_node_BANG_.call(null,element);
}
})();
var element_id = element.dataset.dumdomId;
var temp__5751__auto___38035 = dumdom.core.create_vdom.call(null,component,element_id,opt);
if(cljs.core.truth_(temp__5751__auto___38035)){
var vnode_38036 = temp__5751__auto___38035;
if(cljs.core.truth_(vnode_38036.key)){
} else {
(vnode_38036.key = "root-node");
}

dumdom.core.patch.call(null,current_node,vnode_38036);

dumdom.core.register_vnode.call(null,element_id,vnode_38036);
} else {
(element.innerHTML = "");

dumdom.core.unregister_vnode.call(null,element_id);
}

if(cljs.core.truth_(dumdom.component._STAR_render_eagerly_QMARK__STAR_)){
cljs.core.reset_BANG_.call(null,dumdom.component.eager_render_required_QMARK_,false);
} else {
}

return cljs.core.reset_BANG_.call(null,dumdom.core.rendering_QMARK_,false);
}));

(dumdom.core.render.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(dumdom.core.render.cljs$lang$applyTo = (function (seq38025){
var G__38026 = cljs.core.first.call(null,seq38025);
var seq38025__$1 = cljs.core.next.call(null,seq38025);
var G__38027 = cljs.core.first.call(null,seq38025__$1);
var seq38025__$2 = cljs.core.next.call(null,seq38025__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38026,G__38027,seq38025__$2);
}));

/**
 * Like render, but without mounting the element for future updates. This should
 *   only be used when you don't expect to re-render the component into the same
 *   element. Subsequent calls to render into the same element will always cause a
 *   full rebuild of the DOM. This function does not acumulate state.
 */
dumdom.core.render_once = (function dumdom$core$render_once(var_args){
var args__4835__auto__ = [];
var len__4829__auto___38044 = arguments.length;
var i__4830__auto___38045 = (0);
while(true){
if((i__4830__auto___38045 < len__4829__auto___38044)){
args__4835__auto__.push((arguments[i__4830__auto___38045]));

var G__38046 = (i__4830__auto___38045 + (1));
i__4830__auto___38045 = G__38046;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return dumdom.core.render_once.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(dumdom.core.render_once.cljs$core$IFn$_invoke$arity$variadic = (function (component,element,p__38040){
var vec__38041 = p__38040;
var opt = cljs.core.nth.call(null,vec__38041,(0),null);
cljs.core.reset_BANG_.call(null,dumdom.core.rendering_QMARK_,true);

if(cljs.core.truth_((function (){var and__4221__auto__ = new cljs.core.Keyword(null,"handle-event","handle-event",2098778308).cljs$core$IFn$_invoke$arity$1(opt);
if(cljs.core.truth_(and__4221__auto__)){
return (!(cljs.core.ifn_QMARK_.call(null,new cljs.core.Keyword(null,"handle-event","handle-event",2098778308).cljs$core$IFn$_invoke$arity$1(opt))));
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Called dumdom.core/render-once with a handle-event that is not a function",opt);
} else {
}

var current_node_38047 = dumdom.core.init_node_BANG_.call(null,element);
var element_id_38048 = element.dataset.dumdomId;
var temp__5753__auto___38049 = dumdom.core.create_vdom.call(null,component,element_id_38048,opt);
if(cljs.core.truth_(temp__5753__auto___38049)){
var vnode_38050 = temp__5753__auto___38049;
dumdom.core.patch.call(null,current_node_38047,vnode_38050);
} else {
}

if(cljs.core.truth_(dumdom.component._STAR_render_eagerly_QMARK__STAR_)){
cljs.core.reset_BANG_.call(null,dumdom.component.eager_render_required_QMARK_,false);
} else {
}

return cljs.core.reset_BANG_.call(null,dumdom.core.rendering_QMARK_,false);
}));

(dumdom.core.render_once.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(dumdom.core.render_once.cljs$lang$applyTo = (function (seq38037){
var G__38038 = cljs.core.first.call(null,seq38037);
var seq38037__$1 = cljs.core.next.call(null,seq38037);
var G__38039 = cljs.core.first.call(null,seq38037__$1);
var seq38037__$2 = cljs.core.next.call(null,seq38037__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38038,G__38039,seq38037__$2);
}));

/**
 * Unmount an element previously mounted by dumdom.core/render
 */
dumdom.core.unmount = (function dumdom$core$unmount(element){
return dumdom.core.unregister_vnode.call(null,element.dataset.dumdomId);
});
dumdom.core.component = dumdom.component.component;
dumdom.core.component_QMARK_ = dumdom.component.component_QMARK_;
dumdom.core.render_string = dumdom.string.render;
dumdom.core.TransitionGroup = (function dumdom$core$TransitionGroup(opt,children){
return dumdom.component.TransitionGroup.call(null,dumdom.dom.el,opt,children);
});
dumdom.core.CSSTransitionGroup = (function dumdom$core$CSSTransitionGroup(opt,children){
return dumdom.component.CSSTransitionGroup.call(null,dumdom.dom.el,opt,children);
});

//# sourceMappingURL=core.js.map
