// Compiled by ClojureScript 1.10.866 {:optimizations :none}
goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__33575){
var map__33576 = p__33575;
var map__33576__$1 = cljs.core.__destructure_map.call(null,map__33576);
var m = map__33576__$1;
var n = cljs.core.get.call(null,map__33576__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.call(null,map__33576__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.call(null,"-------------------------");

cljs.core.println.call(null,(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return [(function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5753__auto__)){
var ns = temp__5753__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})());

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Protocol");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__33577_33605 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__33578_33606 = null;
var count__33579_33607 = (0);
var i__33580_33608 = (0);
while(true){
if((i__33580_33608 < count__33579_33607)){
var f_33609 = cljs.core._nth.call(null,chunk__33578_33606,i__33580_33608);
cljs.core.println.call(null,"  ",f_33609);


var G__33610 = seq__33577_33605;
var G__33611 = chunk__33578_33606;
var G__33612 = count__33579_33607;
var G__33613 = (i__33580_33608 + (1));
seq__33577_33605 = G__33610;
chunk__33578_33606 = G__33611;
count__33579_33607 = G__33612;
i__33580_33608 = G__33613;
continue;
} else {
var temp__5753__auto___33614 = cljs.core.seq.call(null,seq__33577_33605);
if(temp__5753__auto___33614){
var seq__33577_33615__$1 = temp__5753__auto___33614;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33577_33615__$1)){
var c__4649__auto___33616 = cljs.core.chunk_first.call(null,seq__33577_33615__$1);
var G__33617 = cljs.core.chunk_rest.call(null,seq__33577_33615__$1);
var G__33618 = c__4649__auto___33616;
var G__33619 = cljs.core.count.call(null,c__4649__auto___33616);
var G__33620 = (0);
seq__33577_33605 = G__33617;
chunk__33578_33606 = G__33618;
count__33579_33607 = G__33619;
i__33580_33608 = G__33620;
continue;
} else {
var f_33621 = cljs.core.first.call(null,seq__33577_33615__$1);
cljs.core.println.call(null,"  ",f_33621);


var G__33622 = cljs.core.next.call(null,seq__33577_33615__$1);
var G__33623 = null;
var G__33624 = (0);
var G__33625 = (0);
seq__33577_33605 = G__33622;
chunk__33578_33606 = G__33623;
count__33579_33607 = G__33624;
i__33580_33608 = G__33625;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_33626 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__4223__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.call(null,arglists_33626);
} else {
cljs.core.prn.call(null,((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,arglists_33626)))?cljs.core.second.call(null,arglists_33626):arglists_33626));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Special Form");

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.call(null,["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join(''));
} else {
return null;
}
} else {
return cljs.core.println.call(null,["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join(''));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Macro");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Spec");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"REPL Special Function");
} else {
}

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__33581_33627 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__33582_33628 = null;
var count__33583_33629 = (0);
var i__33584_33630 = (0);
while(true){
if((i__33584_33630 < count__33583_33629)){
var vec__33593_33631 = cljs.core._nth.call(null,chunk__33582_33628,i__33584_33630);
var name_33632 = cljs.core.nth.call(null,vec__33593_33631,(0),null);
var map__33596_33633 = cljs.core.nth.call(null,vec__33593_33631,(1),null);
var map__33596_33634__$1 = cljs.core.__destructure_map.call(null,map__33596_33633);
var doc_33635 = cljs.core.get.call(null,map__33596_33634__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_33636 = cljs.core.get.call(null,map__33596_33634__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_33632);

cljs.core.println.call(null," ",arglists_33636);

if(cljs.core.truth_(doc_33635)){
cljs.core.println.call(null," ",doc_33635);
} else {
}


var G__33637 = seq__33581_33627;
var G__33638 = chunk__33582_33628;
var G__33639 = count__33583_33629;
var G__33640 = (i__33584_33630 + (1));
seq__33581_33627 = G__33637;
chunk__33582_33628 = G__33638;
count__33583_33629 = G__33639;
i__33584_33630 = G__33640;
continue;
} else {
var temp__5753__auto___33641 = cljs.core.seq.call(null,seq__33581_33627);
if(temp__5753__auto___33641){
var seq__33581_33642__$1 = temp__5753__auto___33641;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33581_33642__$1)){
var c__4649__auto___33643 = cljs.core.chunk_first.call(null,seq__33581_33642__$1);
var G__33644 = cljs.core.chunk_rest.call(null,seq__33581_33642__$1);
var G__33645 = c__4649__auto___33643;
var G__33646 = cljs.core.count.call(null,c__4649__auto___33643);
var G__33647 = (0);
seq__33581_33627 = G__33644;
chunk__33582_33628 = G__33645;
count__33583_33629 = G__33646;
i__33584_33630 = G__33647;
continue;
} else {
var vec__33597_33648 = cljs.core.first.call(null,seq__33581_33642__$1);
var name_33649 = cljs.core.nth.call(null,vec__33597_33648,(0),null);
var map__33600_33650 = cljs.core.nth.call(null,vec__33597_33648,(1),null);
var map__33600_33651__$1 = cljs.core.__destructure_map.call(null,map__33600_33650);
var doc_33652 = cljs.core.get.call(null,map__33600_33651__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_33653 = cljs.core.get.call(null,map__33600_33651__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_33649);

cljs.core.println.call(null," ",arglists_33653);

if(cljs.core.truth_(doc_33652)){
cljs.core.println.call(null," ",doc_33652);
} else {
}


var G__33654 = cljs.core.next.call(null,seq__33581_33642__$1);
var G__33655 = null;
var G__33656 = (0);
var G__33657 = (0);
seq__33581_33627 = G__33654;
chunk__33582_33628 = G__33655;
count__33583_33629 = G__33656;
i__33584_33630 = G__33657;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5753__auto__ = cljs.spec.alpha.get_spec.call(null,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name.call(null,n)),cljs.core.name.call(null,nm)));
if(cljs.core.truth_(temp__5753__auto__)){
var fnspec = temp__5753__auto__;
cljs.core.print.call(null,"Spec");

var seq__33601 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__33602 = null;
var count__33603 = (0);
var i__33604 = (0);
while(true){
if((i__33604 < count__33603)){
var role = cljs.core._nth.call(null,chunk__33602,i__33604);
var temp__5753__auto___33658__$1 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5753__auto___33658__$1)){
var spec_33659 = temp__5753__auto___33658__$1;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_33659));
} else {
}


var G__33660 = seq__33601;
var G__33661 = chunk__33602;
var G__33662 = count__33603;
var G__33663 = (i__33604 + (1));
seq__33601 = G__33660;
chunk__33602 = G__33661;
count__33603 = G__33662;
i__33604 = G__33663;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq.call(null,seq__33601);
if(temp__5753__auto____$1){
var seq__33601__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33601__$1)){
var c__4649__auto__ = cljs.core.chunk_first.call(null,seq__33601__$1);
var G__33664 = cljs.core.chunk_rest.call(null,seq__33601__$1);
var G__33665 = c__4649__auto__;
var G__33666 = cljs.core.count.call(null,c__4649__auto__);
var G__33667 = (0);
seq__33601 = G__33664;
chunk__33602 = G__33665;
count__33603 = G__33666;
i__33604 = G__33667;
continue;
} else {
var role = cljs.core.first.call(null,seq__33601__$1);
var temp__5753__auto___33668__$2 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5753__auto___33668__$2)){
var spec_33669 = temp__5753__auto___33668__$2;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_33669));
} else {
}


var G__33670 = cljs.core.next.call(null,seq__33601__$1);
var G__33671 = null;
var G__33672 = (0);
var G__33673 = (0);
seq__33601 = G__33670;
chunk__33602 = G__33671;
count__33603 = G__33672;
i__33604 = G__33673;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol("cljs.core","ExceptionInfo","cljs.core/ExceptionInfo",701839050,null):(((t instanceof Error))?cljs.core.symbol.call(null,"js",t.name):null
))], null),(function (){var temp__5753__auto__ = cljs.core.ex_message.call(null,t);
if(cljs.core.truth_(temp__5753__auto__)){
var msg = temp__5753__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5753__auto__ = cljs.core.ex_data.call(null,t);
if(cljs.core.truth_(temp__5753__auto__)){
var ed = temp__5753__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})());
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__33674 = cljs.core.conj.call(null,via,t);
var G__33675 = cljs.core.ex_cause.call(null,t);
via = G__33674;
t = G__33675;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek.call(null,via);
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec.call(null,cljs.core.map.call(null,base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5753__auto__ = cljs.core.ex_message.call(null,root);
if(cljs.core.truth_(temp__5753__auto__)){
var root_msg = temp__5753__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5753__auto__ = cljs.core.ex_data.call(null,root);
if(cljs.core.truth_(temp__5753__auto__)){
var data = temp__5753__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5753__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,o));
if(cljs.core.truth_(temp__5753__auto__)){
var phase = temp__5753__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})());
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__33678 = datafied_throwable;
var map__33678__$1 = cljs.core.__destructure_map.call(null,map__33678);
var via = cljs.core.get.call(null,map__33678__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.call(null,map__33678__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.call(null,map__33678__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__33679 = cljs.core.last.call(null,via);
var map__33679__$1 = cljs.core.__destructure_map.call(null,map__33679);
var type = cljs.core.get.call(null,map__33679__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.call(null,map__33679__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.call(null,map__33679__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__33680 = data;
var map__33680__$1 = cljs.core.__destructure_map.call(null,map__33680);
var problems = cljs.core.get.call(null,map__33680__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.call(null,map__33680__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.call(null,map__33680__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__33681 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,via));
var map__33681__$1 = cljs.core.__destructure_map.call(null,map__33681);
var top_data = map__33681__$1;
var source = cljs.core.get.call(null,map__33681__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.call(null,(function (){var G__33682 = phase;
var G__33682__$1 = (((G__33682 instanceof cljs.core.Keyword))?G__33682.fqn:null);
switch (G__33682__$1) {
case "read-source":
var map__33683 = data;
var map__33683__$1 = cljs.core.__destructure_map.call(null,map__33683);
var line = cljs.core.get.call(null,map__33683__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__33683__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__33684 = cljs.core.merge.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,via)),top_data);
var G__33684__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__33684,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__33684);
var G__33684__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__33684__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__33684__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__33684__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__33684__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__33685 = top_data;
var G__33685__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__33685,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__33685);
var G__33685__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__33685__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__33685__$1);
var G__33685__$3 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__33685__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__33685__$2);
var G__33685__$4 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__33685__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__33685__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__33685__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__33685__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__33686 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__33686,(0),null);
var method = cljs.core.nth.call(null,vec__33686,(1),null);
var file = cljs.core.nth.call(null,vec__33686,(2),null);
var line = cljs.core.nth.call(null,vec__33686,(3),null);
var G__33689 = top_data;
var G__33689__$1 = (cljs.core.truth_(line)?cljs.core.assoc.call(null,G__33689,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__33689);
var G__33689__$2 = (cljs.core.truth_(file)?cljs.core.assoc.call(null,G__33689__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__33689__$1);
var G__33689__$3 = (cljs.core.truth_((function (){var and__4221__auto__ = source__$1;
if(cljs.core.truth_(and__4221__auto__)){
return method;
} else {
return and__4221__auto__;
}
})())?cljs.core.assoc.call(null,G__33689__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__33689__$2);
var G__33689__$4 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__33689__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__33689__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__33689__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__33689__$4;
}

break;
case "execution":
var vec__33690 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__33690,(0),null);
var method = cljs.core.nth.call(null,vec__33690,(1),null);
var file = cljs.core.nth.call(null,vec__33690,(2),null);
var line = cljs.core.nth.call(null,vec__33690,(3),null);
var file__$1 = cljs.core.first.call(null,cljs.core.remove.call(null,(function (p1__33677_SHARP_){
var or__4223__auto__ = (p1__33677_SHARP_ == null);
if(or__4223__auto__){
return or__4223__auto__;
} else {
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,p1__33677_SHARP_);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return line;
}
})();
var G__33693 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__33693__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.call(null,G__33693,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__33693);
var G__33693__$2 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__33693__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__33693__$1);
var G__33693__$3 = (cljs.core.truth_((function (){var or__4223__auto__ = fn;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto__ = source__$1;
if(cljs.core.truth_(and__4221__auto__)){
return method;
} else {
return and__4221__auto__;
}
}
})())?cljs.core.assoc.call(null,G__33693__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__4223__auto__ = fn;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__33693__$2);
var G__33693__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.call(null,G__33693__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__33693__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__33693__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__33693__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33682__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__33697){
var map__33698 = p__33697;
var map__33698__$1 = cljs.core.__destructure_map.call(null,map__33698);
var triage_data = map__33698__$1;
var phase = cljs.core.get.call(null,map__33698__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.call(null,map__33698__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.call(null,map__33698__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__33698__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.call(null,map__33698__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.call(null,map__33698__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.call(null,map__33698__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.call(null,map__33698__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4223__auto__ = source;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4223__auto__ = line;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name.call(null,(function (){var or__4223__auto__ = class$;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__33699 = phase;
var G__33699__$1 = (((G__33699 instanceof cljs.core.Keyword))?G__33699.fqn:null);
switch (G__33699__$1) {
case "read-source":
return format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause);

break;
case "macro-syntax-check":
return format.call(null,"Syntax error macroexpanding %sat (%s).\n%s",(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,(cljs.core.truth_(spec)?(function (){var sb__4760__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__33700_33709 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__33701_33710 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__33702_33711 = true;
var _STAR_print_fn_STAR__temp_val__33703_33712 = (function (x__4761__auto__){
return sb__4760__auto__.append(x__4761__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__33702_33711);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__33703_33712);

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.call(null,(function (p1__33695_SHARP_){
return cljs.core.dissoc.call(null,p1__33695_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__33701_33710);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__33700_33709);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4760__auto__);
})():format.call(null,"%s\n",cause)));

break;
case "macroexpansion":
return format.call(null,"Unexpected error%s macroexpanding %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compile-syntax-check":
return format.call(null,"Syntax error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compilation":
return format.call(null,"Unexpected error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "read-eval-result":
return format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "print-eval-result":
return format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "execution":
if(cljs.core.truth_(spec)){
return format.call(null,"Execution error - invalid arguments to %s at (%s).\n%s",symbol,loc,(function (){var sb__4760__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__33704_33713 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__33705_33714 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__33706_33715 = true;
var _STAR_print_fn_STAR__temp_val__33707_33716 = (function (x__4761__auto__){
return sb__4760__auto__.append(x__4761__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__33706_33715);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__33707_33716);

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.call(null,(function (p1__33696_SHARP_){
return cljs.core.dissoc.call(null,p1__33696_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__33705_33714);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__33704_33713);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4760__auto__);
})());
} else {
return format.call(null,"Execution error%s at %s(%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33699__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str.call(null,cljs.repl.ex_triage.call(null,cljs.repl.Error__GT_map.call(null,error)));
});

//# sourceMappingURL=repl.js.map
