// Compiled by ClojureScript 1.10.866 {:optimizations :none}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__22726 = arguments.length;
switch (G__22726) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async22727 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22727 = (function (f,blockable,meta22728){
this.f = f;
this.blockable = blockable;
this.meta22728 = meta22728;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async22727.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22729,meta22728__$1){
var self__ = this;
var _22729__$1 = this;
return (new cljs.core.async.t_cljs$core$async22727(self__.f,self__.blockable,meta22728__$1));
}));

(cljs.core.async.t_cljs$core$async22727.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22729){
var self__ = this;
var _22729__$1 = this;
return self__.meta22728;
}));

(cljs.core.async.t_cljs$core$async22727.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async22727.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async22727.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async22727.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async22727.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta22728","meta22728",-38478301,null)], null);
}));

(cljs.core.async.t_cljs$core$async22727.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async22727.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22727");

(cljs.core.async.t_cljs$core$async22727.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async22727");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async22727.
 */
cljs.core.async.__GT_t_cljs$core$async22727 = (function cljs$core$async$__GT_t_cljs$core$async22727(f__$1,blockable__$1,meta22728){
return (new cljs.core.async.t_cljs$core$async22727(f__$1,blockable__$1,meta22728));
});

}

return (new cljs.core.async.t_cljs$core$async22727(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__22733 = arguments.length;
switch (G__22733) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__22736 = arguments.length;
switch (G__22736) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__22739 = arguments.length;
switch (G__22739) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_22741 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_22741);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_22741);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__22743 = arguments.length;
switch (G__22743) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4706__auto___22745 = n;
var x_22746 = (0);
while(true){
if((x_22746 < n__4706__auto___22745)){
(a[x_22746] = (0));

var G__22747 = (x_22746 + (1));
x_22746 = G__22747;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__22748 = (i + (1));
i = G__22748;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async22749 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22749 = (function (flag,meta22750){
this.flag = flag;
this.meta22750 = meta22750;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async22749.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22751,meta22750__$1){
var self__ = this;
var _22751__$1 = this;
return (new cljs.core.async.t_cljs$core$async22749(self__.flag,meta22750__$1));
}));

(cljs.core.async.t_cljs$core$async22749.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22751){
var self__ = this;
var _22751__$1 = this;
return self__.meta22750;
}));

(cljs.core.async.t_cljs$core$async22749.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async22749.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async22749.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async22749.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async22749.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta22750","meta22750",2026181156,null)], null);
}));

(cljs.core.async.t_cljs$core$async22749.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async22749.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22749");

(cljs.core.async.t_cljs$core$async22749.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async22749");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async22749.
 */
cljs.core.async.__GT_t_cljs$core$async22749 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async22749(flag__$1,meta22750){
return (new cljs.core.async.t_cljs$core$async22749(flag__$1,meta22750));
});

}

return (new cljs.core.async.t_cljs$core$async22749(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async22752 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22752 = (function (flag,cb,meta22753){
this.flag = flag;
this.cb = cb;
this.meta22753 = meta22753;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async22752.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22754,meta22753__$1){
var self__ = this;
var _22754__$1 = this;
return (new cljs.core.async.t_cljs$core$async22752(self__.flag,self__.cb,meta22753__$1));
}));

(cljs.core.async.t_cljs$core$async22752.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22754){
var self__ = this;
var _22754__$1 = this;
return self__.meta22753;
}));

(cljs.core.async.t_cljs$core$async22752.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async22752.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async22752.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async22752.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async22752.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta22753","meta22753",-990339812,null)], null);
}));

(cljs.core.async.t_cljs$core$async22752.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async22752.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22752");

(cljs.core.async.t_cljs$core$async22752.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async22752");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async22752.
 */
cljs.core.async.__GT_t_cljs$core$async22752 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async22752(flag__$1,cb__$1,meta22753){
return (new cljs.core.async.t_cljs$core$async22752(flag__$1,cb__$1,meta22753));
});

}

return (new cljs.core.async.t_cljs$core$async22752(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__22755_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22755_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__22756_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22756_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4223__auto__ = wport;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return port;
}
})()], null));
} else {
var G__22757 = (i + (1));
i = G__22757;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4223__auto__ = ret;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4221__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___22762 = arguments.length;
var i__4830__auto___22763 = (0);
while(true){
if((i__4830__auto___22763 < len__4829__auto___22762)){
args__4835__auto__.push((arguments[i__4830__auto___22763]));

var G__22764 = (i__4830__auto___22763 + (1));
i__4830__auto___22763 = G__22764;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__22760){
var map__22761 = p__22760;
var map__22761__$1 = cljs.core.__destructure_map.call(null,map__22761);
var opts = map__22761__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq22758){
var G__22759 = cljs.core.first.call(null,seq22758);
var seq22758__$1 = cljs.core.next.call(null,seq22758);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__22759,seq22758__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__22766 = arguments.length;
switch (G__22766) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__22666__auto___22812 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_22790){
var state_val_22791 = (state_22790[(1)]);
if((state_val_22791 === (7))){
var inst_22786 = (state_22790[(2)]);
var state_22790__$1 = state_22790;
var statearr_22792_22813 = state_22790__$1;
(statearr_22792_22813[(2)] = inst_22786);

(statearr_22792_22813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22791 === (1))){
var state_22790__$1 = state_22790;
var statearr_22793_22814 = state_22790__$1;
(statearr_22793_22814[(2)] = null);

(statearr_22793_22814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22791 === (4))){
var inst_22769 = (state_22790[(7)]);
var inst_22769__$1 = (state_22790[(2)]);
var inst_22770 = (inst_22769__$1 == null);
var state_22790__$1 = (function (){var statearr_22794 = state_22790;
(statearr_22794[(7)] = inst_22769__$1);

return statearr_22794;
})();
if(cljs.core.truth_(inst_22770)){
var statearr_22795_22815 = state_22790__$1;
(statearr_22795_22815[(1)] = (5));

} else {
var statearr_22796_22816 = state_22790__$1;
(statearr_22796_22816[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22791 === (13))){
var state_22790__$1 = state_22790;
var statearr_22797_22817 = state_22790__$1;
(statearr_22797_22817[(2)] = null);

(statearr_22797_22817[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22791 === (6))){
var inst_22769 = (state_22790[(7)]);
var state_22790__$1 = state_22790;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22790__$1,(11),to,inst_22769);
} else {
if((state_val_22791 === (3))){
var inst_22788 = (state_22790[(2)]);
var state_22790__$1 = state_22790;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22790__$1,inst_22788);
} else {
if((state_val_22791 === (12))){
var state_22790__$1 = state_22790;
var statearr_22798_22818 = state_22790__$1;
(statearr_22798_22818[(2)] = null);

(statearr_22798_22818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22791 === (2))){
var state_22790__$1 = state_22790;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22790__$1,(4),from);
} else {
if((state_val_22791 === (11))){
var inst_22779 = (state_22790[(2)]);
var state_22790__$1 = state_22790;
if(cljs.core.truth_(inst_22779)){
var statearr_22799_22819 = state_22790__$1;
(statearr_22799_22819[(1)] = (12));

} else {
var statearr_22800_22820 = state_22790__$1;
(statearr_22800_22820[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22791 === (9))){
var state_22790__$1 = state_22790;
var statearr_22801_22821 = state_22790__$1;
(statearr_22801_22821[(2)] = null);

(statearr_22801_22821[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22791 === (5))){
var state_22790__$1 = state_22790;
if(cljs.core.truth_(close_QMARK_)){
var statearr_22802_22822 = state_22790__$1;
(statearr_22802_22822[(1)] = (8));

} else {
var statearr_22803_22823 = state_22790__$1;
(statearr_22803_22823[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22791 === (14))){
var inst_22784 = (state_22790[(2)]);
var state_22790__$1 = state_22790;
var statearr_22804_22824 = state_22790__$1;
(statearr_22804_22824[(2)] = inst_22784);

(statearr_22804_22824[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22791 === (10))){
var inst_22776 = (state_22790[(2)]);
var state_22790__$1 = state_22790;
var statearr_22805_22825 = state_22790__$1;
(statearr_22805_22825[(2)] = inst_22776);

(statearr_22805_22825[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22791 === (8))){
var inst_22773 = cljs.core.async.close_BANG_.call(null,to);
var state_22790__$1 = state_22790;
var statearr_22806_22826 = state_22790__$1;
(statearr_22806_22826[(2)] = inst_22773);

(statearr_22806_22826[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__22570__auto__ = null;
var cljs$core$async$state_machine__22570__auto____0 = (function (){
var statearr_22807 = [null,null,null,null,null,null,null,null];
(statearr_22807[(0)] = cljs$core$async$state_machine__22570__auto__);

(statearr_22807[(1)] = (1));

return statearr_22807;
});
var cljs$core$async$state_machine__22570__auto____1 = (function (state_22790){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_22790);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e22808){if((e22808 instanceof Object)){
var ex__22573__auto__ = e22808;
var statearr_22809_22827 = state_22790;
(statearr_22809_22827[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22790);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22808;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22828 = state_22790;
state_22790 = G__22828;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$state_machine__22570__auto__ = function(state_22790){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22570__auto____1.call(this,state_22790);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22570__auto____0;
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22570__auto____1;
return cljs$core$async$state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_22810 = f__22667__auto__.call(null);
(statearr_22810[(6)] = c__22666__auto___22812);

return statearr_22810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__22829){
var vec__22830 = p__22829;
var v = cljs.core.nth.call(null,vec__22830,(0),null);
var p = cljs.core.nth.call(null,vec__22830,(1),null);
var job = vec__22830;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__22666__auto___23001 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_22837){
var state_val_22838 = (state_22837[(1)]);
if((state_val_22838 === (1))){
var state_22837__$1 = state_22837;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22837__$1,(2),res,v);
} else {
if((state_val_22838 === (2))){
var inst_22834 = (state_22837[(2)]);
var inst_22835 = cljs.core.async.close_BANG_.call(null,res);
var state_22837__$1 = (function (){var statearr_22839 = state_22837;
(statearr_22839[(7)] = inst_22834);

return statearr_22839;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22837__$1,inst_22835);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____0 = (function (){
var statearr_22840 = [null,null,null,null,null,null,null,null];
(statearr_22840[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__);

(statearr_22840[(1)] = (1));

return statearr_22840;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____1 = (function (state_22837){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_22837);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e22841){if((e22841 instanceof Object)){
var ex__22573__auto__ = e22841;
var statearr_22842_23002 = state_22837;
(statearr_22842_23002[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22837);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22841;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23003 = state_22837;
state_22837 = G__23003;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__ = function(state_22837){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____1.call(this,state_22837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_22843 = f__22667__auto__.call(null);
(statearr_22843[(6)] = c__22666__auto___23001);

return statearr_22843;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__22844){
var vec__22845 = p__22844;
var v = cljs.core.nth.call(null,vec__22845,(0),null);
var p = cljs.core.nth.call(null,vec__22845,(1),null);
var job = vec__22845;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__4706__auto___23004 = n;
var __23005 = (0);
while(true){
if((__23005 < n__4706__auto___23004)){
var G__22848_23006 = type;
var G__22848_23007__$1 = (((G__22848_23006 instanceof cljs.core.Keyword))?G__22848_23006.fqn:null);
switch (G__22848_23007__$1) {
case "compute":
var c__22666__auto___23009 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23005,c__22666__auto___23009,G__22848_23006,G__22848_23007__$1,n__4706__auto___23004,jobs,results,process,async){
return (function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = ((function (__23005,c__22666__auto___23009,G__22848_23006,G__22848_23007__$1,n__4706__auto___23004,jobs,results,process,async){
return (function (state_22861){
var state_val_22862 = (state_22861[(1)]);
if((state_val_22862 === (1))){
var state_22861__$1 = state_22861;
var statearr_22863_23010 = state_22861__$1;
(statearr_22863_23010[(2)] = null);

(statearr_22863_23010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22862 === (2))){
var state_22861__$1 = state_22861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22861__$1,(4),jobs);
} else {
if((state_val_22862 === (3))){
var inst_22859 = (state_22861[(2)]);
var state_22861__$1 = state_22861;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22861__$1,inst_22859);
} else {
if((state_val_22862 === (4))){
var inst_22851 = (state_22861[(2)]);
var inst_22852 = process.call(null,inst_22851);
var state_22861__$1 = state_22861;
if(cljs.core.truth_(inst_22852)){
var statearr_22864_23011 = state_22861__$1;
(statearr_22864_23011[(1)] = (5));

} else {
var statearr_22865_23012 = state_22861__$1;
(statearr_22865_23012[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22862 === (5))){
var state_22861__$1 = state_22861;
var statearr_22866_23013 = state_22861__$1;
(statearr_22866_23013[(2)] = null);

(statearr_22866_23013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22862 === (6))){
var state_22861__$1 = state_22861;
var statearr_22867_23014 = state_22861__$1;
(statearr_22867_23014[(2)] = null);

(statearr_22867_23014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22862 === (7))){
var inst_22857 = (state_22861[(2)]);
var state_22861__$1 = state_22861;
var statearr_22868_23015 = state_22861__$1;
(statearr_22868_23015[(2)] = inst_22857);

(statearr_22868_23015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23005,c__22666__auto___23009,G__22848_23006,G__22848_23007__$1,n__4706__auto___23004,jobs,results,process,async))
;
return ((function (__23005,switch__22569__auto__,c__22666__auto___23009,G__22848_23006,G__22848_23007__$1,n__4706__auto___23004,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____0 = (function (){
var statearr_22869 = [null,null,null,null,null,null,null];
(statearr_22869[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__);

(statearr_22869[(1)] = (1));

return statearr_22869;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____1 = (function (state_22861){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_22861);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e22870){if((e22870 instanceof Object)){
var ex__22573__auto__ = e22870;
var statearr_22871_23016 = state_22861;
(statearr_22871_23016[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22861);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22870;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23017 = state_22861;
state_22861 = G__23017;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__ = function(state_22861){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____1.call(this,state_22861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__;
})()
;})(__23005,switch__22569__auto__,c__22666__auto___23009,G__22848_23006,G__22848_23007__$1,n__4706__auto___23004,jobs,results,process,async))
})();
var state__22668__auto__ = (function (){var statearr_22872 = f__22667__auto__.call(null);
(statearr_22872[(6)] = c__22666__auto___23009);

return statearr_22872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
});})(__23005,c__22666__auto___23009,G__22848_23006,G__22848_23007__$1,n__4706__auto___23004,jobs,results,process,async))
);


break;
case "async":
var c__22666__auto___23018 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23005,c__22666__auto___23018,G__22848_23006,G__22848_23007__$1,n__4706__auto___23004,jobs,results,process,async){
return (function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = ((function (__23005,c__22666__auto___23018,G__22848_23006,G__22848_23007__$1,n__4706__auto___23004,jobs,results,process,async){
return (function (state_22885){
var state_val_22886 = (state_22885[(1)]);
if((state_val_22886 === (1))){
var state_22885__$1 = state_22885;
var statearr_22887_23019 = state_22885__$1;
(statearr_22887_23019[(2)] = null);

(statearr_22887_23019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22886 === (2))){
var state_22885__$1 = state_22885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22885__$1,(4),jobs);
} else {
if((state_val_22886 === (3))){
var inst_22883 = (state_22885[(2)]);
var state_22885__$1 = state_22885;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22885__$1,inst_22883);
} else {
if((state_val_22886 === (4))){
var inst_22875 = (state_22885[(2)]);
var inst_22876 = async.call(null,inst_22875);
var state_22885__$1 = state_22885;
if(cljs.core.truth_(inst_22876)){
var statearr_22888_23020 = state_22885__$1;
(statearr_22888_23020[(1)] = (5));

} else {
var statearr_22889_23021 = state_22885__$1;
(statearr_22889_23021[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22886 === (5))){
var state_22885__$1 = state_22885;
var statearr_22890_23022 = state_22885__$1;
(statearr_22890_23022[(2)] = null);

(statearr_22890_23022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22886 === (6))){
var state_22885__$1 = state_22885;
var statearr_22891_23023 = state_22885__$1;
(statearr_22891_23023[(2)] = null);

(statearr_22891_23023[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22886 === (7))){
var inst_22881 = (state_22885[(2)]);
var state_22885__$1 = state_22885;
var statearr_22892_23024 = state_22885__$1;
(statearr_22892_23024[(2)] = inst_22881);

(statearr_22892_23024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23005,c__22666__auto___23018,G__22848_23006,G__22848_23007__$1,n__4706__auto___23004,jobs,results,process,async))
;
return ((function (__23005,switch__22569__auto__,c__22666__auto___23018,G__22848_23006,G__22848_23007__$1,n__4706__auto___23004,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____0 = (function (){
var statearr_22893 = [null,null,null,null,null,null,null];
(statearr_22893[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__);

(statearr_22893[(1)] = (1));

return statearr_22893;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____1 = (function (state_22885){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_22885);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e22894){if((e22894 instanceof Object)){
var ex__22573__auto__ = e22894;
var statearr_22895_23025 = state_22885;
(statearr_22895_23025[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22885);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22894;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23026 = state_22885;
state_22885 = G__23026;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__ = function(state_22885){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____1.call(this,state_22885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__;
})()
;})(__23005,switch__22569__auto__,c__22666__auto___23018,G__22848_23006,G__22848_23007__$1,n__4706__auto___23004,jobs,results,process,async))
})();
var state__22668__auto__ = (function (){var statearr_22896 = f__22667__auto__.call(null);
(statearr_22896[(6)] = c__22666__auto___23018);

return statearr_22896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
});})(__23005,c__22666__auto___23018,G__22848_23006,G__22848_23007__$1,n__4706__auto___23004,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__22848_23007__$1)].join('')));

}

var G__23027 = (__23005 + (1));
__23005 = G__23027;
continue;
} else {
}
break;
}

var c__22666__auto___23028 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_22918){
var state_val_22919 = (state_22918[(1)]);
if((state_val_22919 === (7))){
var inst_22914 = (state_22918[(2)]);
var state_22918__$1 = state_22918;
var statearr_22920_23029 = state_22918__$1;
(statearr_22920_23029[(2)] = inst_22914);

(statearr_22920_23029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22919 === (1))){
var state_22918__$1 = state_22918;
var statearr_22921_23030 = state_22918__$1;
(statearr_22921_23030[(2)] = null);

(statearr_22921_23030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22919 === (4))){
var inst_22899 = (state_22918[(7)]);
var inst_22899__$1 = (state_22918[(2)]);
var inst_22900 = (inst_22899__$1 == null);
var state_22918__$1 = (function (){var statearr_22922 = state_22918;
(statearr_22922[(7)] = inst_22899__$1);

return statearr_22922;
})();
if(cljs.core.truth_(inst_22900)){
var statearr_22923_23031 = state_22918__$1;
(statearr_22923_23031[(1)] = (5));

} else {
var statearr_22924_23032 = state_22918__$1;
(statearr_22924_23032[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22919 === (6))){
var inst_22899 = (state_22918[(7)]);
var inst_22904 = (state_22918[(8)]);
var inst_22904__$1 = cljs.core.async.chan.call(null,(1));
var inst_22905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22906 = [inst_22899,inst_22904__$1];
var inst_22907 = (new cljs.core.PersistentVector(null,2,(5),inst_22905,inst_22906,null));
var state_22918__$1 = (function (){var statearr_22925 = state_22918;
(statearr_22925[(8)] = inst_22904__$1);

return statearr_22925;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22918__$1,(8),jobs,inst_22907);
} else {
if((state_val_22919 === (3))){
var inst_22916 = (state_22918[(2)]);
var state_22918__$1 = state_22918;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22918__$1,inst_22916);
} else {
if((state_val_22919 === (2))){
var state_22918__$1 = state_22918;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22918__$1,(4),from);
} else {
if((state_val_22919 === (9))){
var inst_22911 = (state_22918[(2)]);
var state_22918__$1 = (function (){var statearr_22926 = state_22918;
(statearr_22926[(9)] = inst_22911);

return statearr_22926;
})();
var statearr_22927_23033 = state_22918__$1;
(statearr_22927_23033[(2)] = null);

(statearr_22927_23033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22919 === (5))){
var inst_22902 = cljs.core.async.close_BANG_.call(null,jobs);
var state_22918__$1 = state_22918;
var statearr_22928_23034 = state_22918__$1;
(statearr_22928_23034[(2)] = inst_22902);

(statearr_22928_23034[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22919 === (8))){
var inst_22904 = (state_22918[(8)]);
var inst_22909 = (state_22918[(2)]);
var state_22918__$1 = (function (){var statearr_22929 = state_22918;
(statearr_22929[(10)] = inst_22909);

return statearr_22929;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22918__$1,(9),results,inst_22904);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____0 = (function (){
var statearr_22930 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22930[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__);

(statearr_22930[(1)] = (1));

return statearr_22930;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____1 = (function (state_22918){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_22918);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e22931){if((e22931 instanceof Object)){
var ex__22573__auto__ = e22931;
var statearr_22932_23035 = state_22918;
(statearr_22932_23035[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22918);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22931;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23036 = state_22918;
state_22918 = G__23036;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__ = function(state_22918){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____1.call(this,state_22918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_22933 = f__22667__auto__.call(null);
(statearr_22933[(6)] = c__22666__auto___23028);

return statearr_22933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));


var c__22666__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_22971){
var state_val_22972 = (state_22971[(1)]);
if((state_val_22972 === (7))){
var inst_22967 = (state_22971[(2)]);
var state_22971__$1 = state_22971;
var statearr_22973_23037 = state_22971__$1;
(statearr_22973_23037[(2)] = inst_22967);

(statearr_22973_23037[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22972 === (20))){
var state_22971__$1 = state_22971;
var statearr_22974_23038 = state_22971__$1;
(statearr_22974_23038[(2)] = null);

(statearr_22974_23038[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22972 === (1))){
var state_22971__$1 = state_22971;
var statearr_22975_23039 = state_22971__$1;
(statearr_22975_23039[(2)] = null);

(statearr_22975_23039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22972 === (4))){
var inst_22936 = (state_22971[(7)]);
var inst_22936__$1 = (state_22971[(2)]);
var inst_22937 = (inst_22936__$1 == null);
var state_22971__$1 = (function (){var statearr_22976 = state_22971;
(statearr_22976[(7)] = inst_22936__$1);

return statearr_22976;
})();
if(cljs.core.truth_(inst_22937)){
var statearr_22977_23040 = state_22971__$1;
(statearr_22977_23040[(1)] = (5));

} else {
var statearr_22978_23041 = state_22971__$1;
(statearr_22978_23041[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22972 === (15))){
var inst_22949 = (state_22971[(8)]);
var state_22971__$1 = state_22971;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22971__$1,(18),to,inst_22949);
} else {
if((state_val_22972 === (21))){
var inst_22962 = (state_22971[(2)]);
var state_22971__$1 = state_22971;
var statearr_22979_23042 = state_22971__$1;
(statearr_22979_23042[(2)] = inst_22962);

(statearr_22979_23042[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22972 === (13))){
var inst_22964 = (state_22971[(2)]);
var state_22971__$1 = (function (){var statearr_22980 = state_22971;
(statearr_22980[(9)] = inst_22964);

return statearr_22980;
})();
var statearr_22981_23043 = state_22971__$1;
(statearr_22981_23043[(2)] = null);

(statearr_22981_23043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22972 === (6))){
var inst_22936 = (state_22971[(7)]);
var state_22971__$1 = state_22971;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22971__$1,(11),inst_22936);
} else {
if((state_val_22972 === (17))){
var inst_22957 = (state_22971[(2)]);
var state_22971__$1 = state_22971;
if(cljs.core.truth_(inst_22957)){
var statearr_22982_23044 = state_22971__$1;
(statearr_22982_23044[(1)] = (19));

} else {
var statearr_22983_23045 = state_22971__$1;
(statearr_22983_23045[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22972 === (3))){
var inst_22969 = (state_22971[(2)]);
var state_22971__$1 = state_22971;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22971__$1,inst_22969);
} else {
if((state_val_22972 === (12))){
var inst_22946 = (state_22971[(10)]);
var state_22971__$1 = state_22971;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22971__$1,(14),inst_22946);
} else {
if((state_val_22972 === (2))){
var state_22971__$1 = state_22971;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22971__$1,(4),results);
} else {
if((state_val_22972 === (19))){
var state_22971__$1 = state_22971;
var statearr_22984_23046 = state_22971__$1;
(statearr_22984_23046[(2)] = null);

(statearr_22984_23046[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22972 === (11))){
var inst_22946 = (state_22971[(2)]);
var state_22971__$1 = (function (){var statearr_22985 = state_22971;
(statearr_22985[(10)] = inst_22946);

return statearr_22985;
})();
var statearr_22986_23047 = state_22971__$1;
(statearr_22986_23047[(2)] = null);

(statearr_22986_23047[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22972 === (9))){
var state_22971__$1 = state_22971;
var statearr_22987_23048 = state_22971__$1;
(statearr_22987_23048[(2)] = null);

(statearr_22987_23048[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22972 === (5))){
var state_22971__$1 = state_22971;
if(cljs.core.truth_(close_QMARK_)){
var statearr_22988_23049 = state_22971__$1;
(statearr_22988_23049[(1)] = (8));

} else {
var statearr_22989_23050 = state_22971__$1;
(statearr_22989_23050[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22972 === (14))){
var inst_22951 = (state_22971[(11)]);
var inst_22949 = (state_22971[(8)]);
var inst_22949__$1 = (state_22971[(2)]);
var inst_22950 = (inst_22949__$1 == null);
var inst_22951__$1 = cljs.core.not.call(null,inst_22950);
var state_22971__$1 = (function (){var statearr_22990 = state_22971;
(statearr_22990[(11)] = inst_22951__$1);

(statearr_22990[(8)] = inst_22949__$1);

return statearr_22990;
})();
if(inst_22951__$1){
var statearr_22991_23051 = state_22971__$1;
(statearr_22991_23051[(1)] = (15));

} else {
var statearr_22992_23052 = state_22971__$1;
(statearr_22992_23052[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22972 === (16))){
var inst_22951 = (state_22971[(11)]);
var state_22971__$1 = state_22971;
var statearr_22993_23053 = state_22971__$1;
(statearr_22993_23053[(2)] = inst_22951);

(statearr_22993_23053[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22972 === (10))){
var inst_22943 = (state_22971[(2)]);
var state_22971__$1 = state_22971;
var statearr_22994_23054 = state_22971__$1;
(statearr_22994_23054[(2)] = inst_22943);

(statearr_22994_23054[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22972 === (18))){
var inst_22954 = (state_22971[(2)]);
var state_22971__$1 = state_22971;
var statearr_22995_23055 = state_22971__$1;
(statearr_22995_23055[(2)] = inst_22954);

(statearr_22995_23055[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22972 === (8))){
var inst_22940 = cljs.core.async.close_BANG_.call(null,to);
var state_22971__$1 = state_22971;
var statearr_22996_23056 = state_22971__$1;
(statearr_22996_23056[(2)] = inst_22940);

(statearr_22996_23056[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____0 = (function (){
var statearr_22997 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22997[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__);

(statearr_22997[(1)] = (1));

return statearr_22997;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____1 = (function (state_22971){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_22971);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e22998){if((e22998 instanceof Object)){
var ex__22573__auto__ = e22998;
var statearr_22999_23057 = state_22971;
(statearr_22999_23057[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22971);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22998;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23058 = state_22971;
state_22971 = G__23058;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__ = function(state_22971){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____1.call(this,state_22971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22570__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_23000 = f__22667__auto__.call(null);
(statearr_23000[(6)] = c__22666__auto__);

return statearr_23000;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));

return c__22666__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__23060 = arguments.length;
switch (G__23060) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__23063 = arguments.length;
switch (G__23063) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__23066 = arguments.length;
switch (G__23066) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__22666__auto___23115 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_23092){
var state_val_23093 = (state_23092[(1)]);
if((state_val_23093 === (7))){
var inst_23088 = (state_23092[(2)]);
var state_23092__$1 = state_23092;
var statearr_23094_23116 = state_23092__$1;
(statearr_23094_23116[(2)] = inst_23088);

(statearr_23094_23116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23093 === (1))){
var state_23092__$1 = state_23092;
var statearr_23095_23117 = state_23092__$1;
(statearr_23095_23117[(2)] = null);

(statearr_23095_23117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23093 === (4))){
var inst_23069 = (state_23092[(7)]);
var inst_23069__$1 = (state_23092[(2)]);
var inst_23070 = (inst_23069__$1 == null);
var state_23092__$1 = (function (){var statearr_23096 = state_23092;
(statearr_23096[(7)] = inst_23069__$1);

return statearr_23096;
})();
if(cljs.core.truth_(inst_23070)){
var statearr_23097_23118 = state_23092__$1;
(statearr_23097_23118[(1)] = (5));

} else {
var statearr_23098_23119 = state_23092__$1;
(statearr_23098_23119[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23093 === (13))){
var state_23092__$1 = state_23092;
var statearr_23099_23120 = state_23092__$1;
(statearr_23099_23120[(2)] = null);

(statearr_23099_23120[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23093 === (6))){
var inst_23069 = (state_23092[(7)]);
var inst_23075 = p.call(null,inst_23069);
var state_23092__$1 = state_23092;
if(cljs.core.truth_(inst_23075)){
var statearr_23100_23121 = state_23092__$1;
(statearr_23100_23121[(1)] = (9));

} else {
var statearr_23101_23122 = state_23092__$1;
(statearr_23101_23122[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23093 === (3))){
var inst_23090 = (state_23092[(2)]);
var state_23092__$1 = state_23092;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23092__$1,inst_23090);
} else {
if((state_val_23093 === (12))){
var state_23092__$1 = state_23092;
var statearr_23102_23123 = state_23092__$1;
(statearr_23102_23123[(2)] = null);

(statearr_23102_23123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23093 === (2))){
var state_23092__$1 = state_23092;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23092__$1,(4),ch);
} else {
if((state_val_23093 === (11))){
var inst_23069 = (state_23092[(7)]);
var inst_23079 = (state_23092[(2)]);
var state_23092__$1 = state_23092;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23092__$1,(8),inst_23079,inst_23069);
} else {
if((state_val_23093 === (9))){
var state_23092__$1 = state_23092;
var statearr_23103_23124 = state_23092__$1;
(statearr_23103_23124[(2)] = tc);

(statearr_23103_23124[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23093 === (5))){
var inst_23072 = cljs.core.async.close_BANG_.call(null,tc);
var inst_23073 = cljs.core.async.close_BANG_.call(null,fc);
var state_23092__$1 = (function (){var statearr_23104 = state_23092;
(statearr_23104[(8)] = inst_23072);

return statearr_23104;
})();
var statearr_23105_23125 = state_23092__$1;
(statearr_23105_23125[(2)] = inst_23073);

(statearr_23105_23125[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23093 === (14))){
var inst_23086 = (state_23092[(2)]);
var state_23092__$1 = state_23092;
var statearr_23106_23126 = state_23092__$1;
(statearr_23106_23126[(2)] = inst_23086);

(statearr_23106_23126[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23093 === (10))){
var state_23092__$1 = state_23092;
var statearr_23107_23127 = state_23092__$1;
(statearr_23107_23127[(2)] = fc);

(statearr_23107_23127[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23093 === (8))){
var inst_23081 = (state_23092[(2)]);
var state_23092__$1 = state_23092;
if(cljs.core.truth_(inst_23081)){
var statearr_23108_23128 = state_23092__$1;
(statearr_23108_23128[(1)] = (12));

} else {
var statearr_23109_23129 = state_23092__$1;
(statearr_23109_23129[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__22570__auto__ = null;
var cljs$core$async$state_machine__22570__auto____0 = (function (){
var statearr_23110 = [null,null,null,null,null,null,null,null,null];
(statearr_23110[(0)] = cljs$core$async$state_machine__22570__auto__);

(statearr_23110[(1)] = (1));

return statearr_23110;
});
var cljs$core$async$state_machine__22570__auto____1 = (function (state_23092){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_23092);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e23111){if((e23111 instanceof Object)){
var ex__22573__auto__ = e23111;
var statearr_23112_23130 = state_23092;
(statearr_23112_23130[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23092);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23111;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23131 = state_23092;
state_23092 = G__23131;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$state_machine__22570__auto__ = function(state_23092){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22570__auto____1.call(this,state_23092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22570__auto____0;
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22570__auto____1;
return cljs$core$async$state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_23113 = f__22667__auto__.call(null);
(statearr_23113[(6)] = c__22666__auto___23115);

return statearr_23113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__22666__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_23152){
var state_val_23153 = (state_23152[(1)]);
if((state_val_23153 === (7))){
var inst_23148 = (state_23152[(2)]);
var state_23152__$1 = state_23152;
var statearr_23154_23172 = state_23152__$1;
(statearr_23154_23172[(2)] = inst_23148);

(statearr_23154_23172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23153 === (1))){
var inst_23132 = init;
var state_23152__$1 = (function (){var statearr_23155 = state_23152;
(statearr_23155[(7)] = inst_23132);

return statearr_23155;
})();
var statearr_23156_23173 = state_23152__$1;
(statearr_23156_23173[(2)] = null);

(statearr_23156_23173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23153 === (4))){
var inst_23135 = (state_23152[(8)]);
var inst_23135__$1 = (state_23152[(2)]);
var inst_23136 = (inst_23135__$1 == null);
var state_23152__$1 = (function (){var statearr_23157 = state_23152;
(statearr_23157[(8)] = inst_23135__$1);

return statearr_23157;
})();
if(cljs.core.truth_(inst_23136)){
var statearr_23158_23174 = state_23152__$1;
(statearr_23158_23174[(1)] = (5));

} else {
var statearr_23159_23175 = state_23152__$1;
(statearr_23159_23175[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23153 === (6))){
var inst_23139 = (state_23152[(9)]);
var inst_23135 = (state_23152[(8)]);
var inst_23132 = (state_23152[(7)]);
var inst_23139__$1 = f.call(null,inst_23132,inst_23135);
var inst_23140 = cljs.core.reduced_QMARK_.call(null,inst_23139__$1);
var state_23152__$1 = (function (){var statearr_23160 = state_23152;
(statearr_23160[(9)] = inst_23139__$1);

return statearr_23160;
})();
if(inst_23140){
var statearr_23161_23176 = state_23152__$1;
(statearr_23161_23176[(1)] = (8));

} else {
var statearr_23162_23177 = state_23152__$1;
(statearr_23162_23177[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23153 === (3))){
var inst_23150 = (state_23152[(2)]);
var state_23152__$1 = state_23152;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23152__$1,inst_23150);
} else {
if((state_val_23153 === (2))){
var state_23152__$1 = state_23152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23152__$1,(4),ch);
} else {
if((state_val_23153 === (9))){
var inst_23139 = (state_23152[(9)]);
var inst_23132 = inst_23139;
var state_23152__$1 = (function (){var statearr_23163 = state_23152;
(statearr_23163[(7)] = inst_23132);

return statearr_23163;
})();
var statearr_23164_23178 = state_23152__$1;
(statearr_23164_23178[(2)] = null);

(statearr_23164_23178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23153 === (5))){
var inst_23132 = (state_23152[(7)]);
var state_23152__$1 = state_23152;
var statearr_23165_23179 = state_23152__$1;
(statearr_23165_23179[(2)] = inst_23132);

(statearr_23165_23179[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23153 === (10))){
var inst_23146 = (state_23152[(2)]);
var state_23152__$1 = state_23152;
var statearr_23166_23180 = state_23152__$1;
(statearr_23166_23180[(2)] = inst_23146);

(statearr_23166_23180[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23153 === (8))){
var inst_23139 = (state_23152[(9)]);
var inst_23142 = cljs.core.deref.call(null,inst_23139);
var state_23152__$1 = state_23152;
var statearr_23167_23181 = state_23152__$1;
(statearr_23167_23181[(2)] = inst_23142);

(statearr_23167_23181[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__22570__auto__ = null;
var cljs$core$async$reduce_$_state_machine__22570__auto____0 = (function (){
var statearr_23168 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23168[(0)] = cljs$core$async$reduce_$_state_machine__22570__auto__);

(statearr_23168[(1)] = (1));

return statearr_23168;
});
var cljs$core$async$reduce_$_state_machine__22570__auto____1 = (function (state_23152){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_23152);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e23169){if((e23169 instanceof Object)){
var ex__22573__auto__ = e23169;
var statearr_23170_23182 = state_23152;
(statearr_23170_23182[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23152);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23169;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23183 = state_23152;
state_23152 = G__23183;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__22570__auto__ = function(state_23152){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__22570__auto____1.call(this,state_23152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__22570__auto____0;
cljs$core$async$reduce_$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__22570__auto____1;
return cljs$core$async$reduce_$_state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_23171 = f__22667__auto__.call(null);
(statearr_23171[(6)] = c__22666__auto__);

return statearr_23171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));

return c__22666__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__22666__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_23189){
var state_val_23190 = (state_23189[(1)]);
if((state_val_23190 === (1))){
var inst_23184 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_23189__$1 = state_23189;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23189__$1,(2),inst_23184);
} else {
if((state_val_23190 === (2))){
var inst_23186 = (state_23189[(2)]);
var inst_23187 = f__$1.call(null,inst_23186);
var state_23189__$1 = state_23189;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23189__$1,inst_23187);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__22570__auto__ = null;
var cljs$core$async$transduce_$_state_machine__22570__auto____0 = (function (){
var statearr_23191 = [null,null,null,null,null,null,null];
(statearr_23191[(0)] = cljs$core$async$transduce_$_state_machine__22570__auto__);

(statearr_23191[(1)] = (1));

return statearr_23191;
});
var cljs$core$async$transduce_$_state_machine__22570__auto____1 = (function (state_23189){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_23189);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e23192){if((e23192 instanceof Object)){
var ex__22573__auto__ = e23192;
var statearr_23193_23195 = state_23189;
(statearr_23193_23195[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23189);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23192;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23196 = state_23189;
state_23189 = G__23196;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__22570__auto__ = function(state_23189){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__22570__auto____1.call(this,state_23189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__22570__auto____0;
cljs$core$async$transduce_$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__22570__auto____1;
return cljs$core$async$transduce_$_state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_23194 = f__22667__auto__.call(null);
(statearr_23194[(6)] = c__22666__auto__);

return statearr_23194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));

return c__22666__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__23198 = arguments.length;
switch (G__23198) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__22666__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_23223){
var state_val_23224 = (state_23223[(1)]);
if((state_val_23224 === (7))){
var inst_23205 = (state_23223[(2)]);
var state_23223__$1 = state_23223;
var statearr_23225_23246 = state_23223__$1;
(statearr_23225_23246[(2)] = inst_23205);

(statearr_23225_23246[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23224 === (1))){
var inst_23199 = cljs.core.seq.call(null,coll);
var inst_23200 = inst_23199;
var state_23223__$1 = (function (){var statearr_23226 = state_23223;
(statearr_23226[(7)] = inst_23200);

return statearr_23226;
})();
var statearr_23227_23247 = state_23223__$1;
(statearr_23227_23247[(2)] = null);

(statearr_23227_23247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23224 === (4))){
var inst_23200 = (state_23223[(7)]);
var inst_23203 = cljs.core.first.call(null,inst_23200);
var state_23223__$1 = state_23223;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23223__$1,(7),ch,inst_23203);
} else {
if((state_val_23224 === (13))){
var inst_23217 = (state_23223[(2)]);
var state_23223__$1 = state_23223;
var statearr_23228_23248 = state_23223__$1;
(statearr_23228_23248[(2)] = inst_23217);

(statearr_23228_23248[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23224 === (6))){
var inst_23208 = (state_23223[(2)]);
var state_23223__$1 = state_23223;
if(cljs.core.truth_(inst_23208)){
var statearr_23229_23249 = state_23223__$1;
(statearr_23229_23249[(1)] = (8));

} else {
var statearr_23230_23250 = state_23223__$1;
(statearr_23230_23250[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23224 === (3))){
var inst_23221 = (state_23223[(2)]);
var state_23223__$1 = state_23223;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23223__$1,inst_23221);
} else {
if((state_val_23224 === (12))){
var state_23223__$1 = state_23223;
var statearr_23231_23251 = state_23223__$1;
(statearr_23231_23251[(2)] = null);

(statearr_23231_23251[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23224 === (2))){
var inst_23200 = (state_23223[(7)]);
var state_23223__$1 = state_23223;
if(cljs.core.truth_(inst_23200)){
var statearr_23232_23252 = state_23223__$1;
(statearr_23232_23252[(1)] = (4));

} else {
var statearr_23233_23253 = state_23223__$1;
(statearr_23233_23253[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23224 === (11))){
var inst_23214 = cljs.core.async.close_BANG_.call(null,ch);
var state_23223__$1 = state_23223;
var statearr_23234_23254 = state_23223__$1;
(statearr_23234_23254[(2)] = inst_23214);

(statearr_23234_23254[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23224 === (9))){
var state_23223__$1 = state_23223;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23235_23255 = state_23223__$1;
(statearr_23235_23255[(1)] = (11));

} else {
var statearr_23236_23256 = state_23223__$1;
(statearr_23236_23256[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23224 === (5))){
var inst_23200 = (state_23223[(7)]);
var state_23223__$1 = state_23223;
var statearr_23237_23257 = state_23223__$1;
(statearr_23237_23257[(2)] = inst_23200);

(statearr_23237_23257[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23224 === (10))){
var inst_23219 = (state_23223[(2)]);
var state_23223__$1 = state_23223;
var statearr_23238_23258 = state_23223__$1;
(statearr_23238_23258[(2)] = inst_23219);

(statearr_23238_23258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23224 === (8))){
var inst_23200 = (state_23223[(7)]);
var inst_23210 = cljs.core.next.call(null,inst_23200);
var inst_23200__$1 = inst_23210;
var state_23223__$1 = (function (){var statearr_23239 = state_23223;
(statearr_23239[(7)] = inst_23200__$1);

return statearr_23239;
})();
var statearr_23240_23259 = state_23223__$1;
(statearr_23240_23259[(2)] = null);

(statearr_23240_23259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__22570__auto__ = null;
var cljs$core$async$state_machine__22570__auto____0 = (function (){
var statearr_23241 = [null,null,null,null,null,null,null,null];
(statearr_23241[(0)] = cljs$core$async$state_machine__22570__auto__);

(statearr_23241[(1)] = (1));

return statearr_23241;
});
var cljs$core$async$state_machine__22570__auto____1 = (function (state_23223){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_23223);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e23242){if((e23242 instanceof Object)){
var ex__22573__auto__ = e23242;
var statearr_23243_23260 = state_23223;
(statearr_23243_23260[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23223);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23242;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23261 = state_23223;
state_23223 = G__23261;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$state_machine__22570__auto__ = function(state_23223){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22570__auto____1.call(this,state_23223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22570__auto____0;
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22570__auto____1;
return cljs$core$async$state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_23244 = f__22667__auto__.call(null);
(statearr_23244[(6)] = c__22666__auto__);

return statearr_23244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));

return c__22666__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_23262 = (function (_){
var x__4521__auto__ = (((_ == null))?null:_);
var m__4522__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,_);
} else {
var m__4519__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_23262.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_23263 = (function (m,ch,close_QMARK_){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4519__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_23263.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_23264 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m,ch);
} else {
var m__4519__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_23264.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_23265 = (function (m){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m);
} else {
var m__4519__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_23265.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23266 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23266 = (function (ch,cs,meta23267){
this.ch = ch;
this.cs = cs;
this.meta23267 = meta23267;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23266.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23268,meta23267__$1){
var self__ = this;
var _23268__$1 = this;
return (new cljs.core.async.t_cljs$core$async23266(self__.ch,self__.cs,meta23267__$1));
}));

(cljs.core.async.t_cljs$core$async23266.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23268){
var self__ = this;
var _23268__$1 = this;
return self__.meta23267;
}));

(cljs.core.async.t_cljs$core$async23266.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23266.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async23266.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23266.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async23266.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async23266.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async23266.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta23267","meta23267",730639623,null)], null);
}));

(cljs.core.async.t_cljs$core$async23266.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23266.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23266");

(cljs.core.async.t_cljs$core$async23266.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async23266");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23266.
 */
cljs.core.async.__GT_t_cljs$core$async23266 = (function cljs$core$async$mult_$___GT_t_cljs$core$async23266(ch__$1,cs__$1,meta23267){
return (new cljs.core.async.t_cljs$core$async23266(ch__$1,cs__$1,meta23267));
});

}

return (new cljs.core.async.t_cljs$core$async23266(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__22666__auto___23488 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_23403){
var state_val_23404 = (state_23403[(1)]);
if((state_val_23404 === (7))){
var inst_23399 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23405_23489 = state_23403__$1;
(statearr_23405_23489[(2)] = inst_23399);

(statearr_23405_23489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (20))){
var inst_23302 = (state_23403[(7)]);
var inst_23314 = cljs.core.first.call(null,inst_23302);
var inst_23315 = cljs.core.nth.call(null,inst_23314,(0),null);
var inst_23316 = cljs.core.nth.call(null,inst_23314,(1),null);
var state_23403__$1 = (function (){var statearr_23406 = state_23403;
(statearr_23406[(8)] = inst_23315);

return statearr_23406;
})();
if(cljs.core.truth_(inst_23316)){
var statearr_23407_23490 = state_23403__$1;
(statearr_23407_23490[(1)] = (22));

} else {
var statearr_23408_23491 = state_23403__$1;
(statearr_23408_23491[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (27))){
var inst_23351 = (state_23403[(9)]);
var inst_23344 = (state_23403[(10)]);
var inst_23271 = (state_23403[(11)]);
var inst_23346 = (state_23403[(12)]);
var inst_23351__$1 = cljs.core._nth.call(null,inst_23344,inst_23346);
var inst_23352 = cljs.core.async.put_BANG_.call(null,inst_23351__$1,inst_23271,done);
var state_23403__$1 = (function (){var statearr_23409 = state_23403;
(statearr_23409[(9)] = inst_23351__$1);

return statearr_23409;
})();
if(cljs.core.truth_(inst_23352)){
var statearr_23410_23492 = state_23403__$1;
(statearr_23410_23492[(1)] = (30));

} else {
var statearr_23411_23493 = state_23403__$1;
(statearr_23411_23493[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (1))){
var state_23403__$1 = state_23403;
var statearr_23412_23494 = state_23403__$1;
(statearr_23412_23494[(2)] = null);

(statearr_23412_23494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (24))){
var inst_23302 = (state_23403[(7)]);
var inst_23321 = (state_23403[(2)]);
var inst_23322 = cljs.core.next.call(null,inst_23302);
var inst_23280 = inst_23322;
var inst_23281 = null;
var inst_23282 = (0);
var inst_23283 = (0);
var state_23403__$1 = (function (){var statearr_23413 = state_23403;
(statearr_23413[(13)] = inst_23321);

(statearr_23413[(14)] = inst_23282);

(statearr_23413[(15)] = inst_23281);

(statearr_23413[(16)] = inst_23280);

(statearr_23413[(17)] = inst_23283);

return statearr_23413;
})();
var statearr_23414_23495 = state_23403__$1;
(statearr_23414_23495[(2)] = null);

(statearr_23414_23495[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (39))){
var state_23403__$1 = state_23403;
var statearr_23418_23496 = state_23403__$1;
(statearr_23418_23496[(2)] = null);

(statearr_23418_23496[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (4))){
var inst_23271 = (state_23403[(11)]);
var inst_23271__$1 = (state_23403[(2)]);
var inst_23272 = (inst_23271__$1 == null);
var state_23403__$1 = (function (){var statearr_23419 = state_23403;
(statearr_23419[(11)] = inst_23271__$1);

return statearr_23419;
})();
if(cljs.core.truth_(inst_23272)){
var statearr_23420_23497 = state_23403__$1;
(statearr_23420_23497[(1)] = (5));

} else {
var statearr_23421_23498 = state_23403__$1;
(statearr_23421_23498[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (15))){
var inst_23282 = (state_23403[(14)]);
var inst_23281 = (state_23403[(15)]);
var inst_23280 = (state_23403[(16)]);
var inst_23283 = (state_23403[(17)]);
var inst_23298 = (state_23403[(2)]);
var inst_23299 = (inst_23283 + (1));
var tmp23415 = inst_23282;
var tmp23416 = inst_23281;
var tmp23417 = inst_23280;
var inst_23280__$1 = tmp23417;
var inst_23281__$1 = tmp23416;
var inst_23282__$1 = tmp23415;
var inst_23283__$1 = inst_23299;
var state_23403__$1 = (function (){var statearr_23422 = state_23403;
(statearr_23422[(18)] = inst_23298);

(statearr_23422[(14)] = inst_23282__$1);

(statearr_23422[(15)] = inst_23281__$1);

(statearr_23422[(16)] = inst_23280__$1);

(statearr_23422[(17)] = inst_23283__$1);

return statearr_23422;
})();
var statearr_23423_23499 = state_23403__$1;
(statearr_23423_23499[(2)] = null);

(statearr_23423_23499[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (21))){
var inst_23325 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23427_23500 = state_23403__$1;
(statearr_23427_23500[(2)] = inst_23325);

(statearr_23427_23500[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (31))){
var inst_23351 = (state_23403[(9)]);
var inst_23355 = done.call(null,null);
var inst_23356 = cljs.core.async.untap_STAR_.call(null,m,inst_23351);
var state_23403__$1 = (function (){var statearr_23428 = state_23403;
(statearr_23428[(19)] = inst_23355);

return statearr_23428;
})();
var statearr_23429_23501 = state_23403__$1;
(statearr_23429_23501[(2)] = inst_23356);

(statearr_23429_23501[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (32))){
var inst_23343 = (state_23403[(20)]);
var inst_23345 = (state_23403[(21)]);
var inst_23344 = (state_23403[(10)]);
var inst_23346 = (state_23403[(12)]);
var inst_23358 = (state_23403[(2)]);
var inst_23359 = (inst_23346 + (1));
var tmp23424 = inst_23343;
var tmp23425 = inst_23345;
var tmp23426 = inst_23344;
var inst_23343__$1 = tmp23424;
var inst_23344__$1 = tmp23426;
var inst_23345__$1 = tmp23425;
var inst_23346__$1 = inst_23359;
var state_23403__$1 = (function (){var statearr_23430 = state_23403;
(statearr_23430[(20)] = inst_23343__$1);

(statearr_23430[(22)] = inst_23358);

(statearr_23430[(21)] = inst_23345__$1);

(statearr_23430[(10)] = inst_23344__$1);

(statearr_23430[(12)] = inst_23346__$1);

return statearr_23430;
})();
var statearr_23431_23502 = state_23403__$1;
(statearr_23431_23502[(2)] = null);

(statearr_23431_23502[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (40))){
var inst_23371 = (state_23403[(23)]);
var inst_23375 = done.call(null,null);
var inst_23376 = cljs.core.async.untap_STAR_.call(null,m,inst_23371);
var state_23403__$1 = (function (){var statearr_23432 = state_23403;
(statearr_23432[(24)] = inst_23375);

return statearr_23432;
})();
var statearr_23433_23503 = state_23403__$1;
(statearr_23433_23503[(2)] = inst_23376);

(statearr_23433_23503[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (33))){
var inst_23362 = (state_23403[(25)]);
var inst_23364 = cljs.core.chunked_seq_QMARK_.call(null,inst_23362);
var state_23403__$1 = state_23403;
if(inst_23364){
var statearr_23434_23504 = state_23403__$1;
(statearr_23434_23504[(1)] = (36));

} else {
var statearr_23435_23505 = state_23403__$1;
(statearr_23435_23505[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (13))){
var inst_23292 = (state_23403[(26)]);
var inst_23295 = cljs.core.async.close_BANG_.call(null,inst_23292);
var state_23403__$1 = state_23403;
var statearr_23436_23506 = state_23403__$1;
(statearr_23436_23506[(2)] = inst_23295);

(statearr_23436_23506[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (22))){
var inst_23315 = (state_23403[(8)]);
var inst_23318 = cljs.core.async.close_BANG_.call(null,inst_23315);
var state_23403__$1 = state_23403;
var statearr_23437_23507 = state_23403__$1;
(statearr_23437_23507[(2)] = inst_23318);

(statearr_23437_23507[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (36))){
var inst_23362 = (state_23403[(25)]);
var inst_23366 = cljs.core.chunk_first.call(null,inst_23362);
var inst_23367 = cljs.core.chunk_rest.call(null,inst_23362);
var inst_23368 = cljs.core.count.call(null,inst_23366);
var inst_23343 = inst_23367;
var inst_23344 = inst_23366;
var inst_23345 = inst_23368;
var inst_23346 = (0);
var state_23403__$1 = (function (){var statearr_23438 = state_23403;
(statearr_23438[(20)] = inst_23343);

(statearr_23438[(21)] = inst_23345);

(statearr_23438[(10)] = inst_23344);

(statearr_23438[(12)] = inst_23346);

return statearr_23438;
})();
var statearr_23439_23508 = state_23403__$1;
(statearr_23439_23508[(2)] = null);

(statearr_23439_23508[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (41))){
var inst_23362 = (state_23403[(25)]);
var inst_23378 = (state_23403[(2)]);
var inst_23379 = cljs.core.next.call(null,inst_23362);
var inst_23343 = inst_23379;
var inst_23344 = null;
var inst_23345 = (0);
var inst_23346 = (0);
var state_23403__$1 = (function (){var statearr_23440 = state_23403;
(statearr_23440[(20)] = inst_23343);

(statearr_23440[(21)] = inst_23345);

(statearr_23440[(10)] = inst_23344);

(statearr_23440[(27)] = inst_23378);

(statearr_23440[(12)] = inst_23346);

return statearr_23440;
})();
var statearr_23441_23509 = state_23403__$1;
(statearr_23441_23509[(2)] = null);

(statearr_23441_23509[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (43))){
var state_23403__$1 = state_23403;
var statearr_23442_23510 = state_23403__$1;
(statearr_23442_23510[(2)] = null);

(statearr_23442_23510[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (29))){
var inst_23387 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23443_23511 = state_23403__$1;
(statearr_23443_23511[(2)] = inst_23387);

(statearr_23443_23511[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (44))){
var inst_23396 = (state_23403[(2)]);
var state_23403__$1 = (function (){var statearr_23444 = state_23403;
(statearr_23444[(28)] = inst_23396);

return statearr_23444;
})();
var statearr_23445_23512 = state_23403__$1;
(statearr_23445_23512[(2)] = null);

(statearr_23445_23512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (6))){
var inst_23335 = (state_23403[(29)]);
var inst_23334 = cljs.core.deref.call(null,cs);
var inst_23335__$1 = cljs.core.keys.call(null,inst_23334);
var inst_23336 = cljs.core.count.call(null,inst_23335__$1);
var inst_23337 = cljs.core.reset_BANG_.call(null,dctr,inst_23336);
var inst_23342 = cljs.core.seq.call(null,inst_23335__$1);
var inst_23343 = inst_23342;
var inst_23344 = null;
var inst_23345 = (0);
var inst_23346 = (0);
var state_23403__$1 = (function (){var statearr_23446 = state_23403;
(statearr_23446[(20)] = inst_23343);

(statearr_23446[(30)] = inst_23337);

(statearr_23446[(29)] = inst_23335__$1);

(statearr_23446[(21)] = inst_23345);

(statearr_23446[(10)] = inst_23344);

(statearr_23446[(12)] = inst_23346);

return statearr_23446;
})();
var statearr_23447_23513 = state_23403__$1;
(statearr_23447_23513[(2)] = null);

(statearr_23447_23513[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (28))){
var inst_23343 = (state_23403[(20)]);
var inst_23362 = (state_23403[(25)]);
var inst_23362__$1 = cljs.core.seq.call(null,inst_23343);
var state_23403__$1 = (function (){var statearr_23448 = state_23403;
(statearr_23448[(25)] = inst_23362__$1);

return statearr_23448;
})();
if(inst_23362__$1){
var statearr_23449_23514 = state_23403__$1;
(statearr_23449_23514[(1)] = (33));

} else {
var statearr_23450_23515 = state_23403__$1;
(statearr_23450_23515[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (25))){
var inst_23345 = (state_23403[(21)]);
var inst_23346 = (state_23403[(12)]);
var inst_23348 = (inst_23346 < inst_23345);
var inst_23349 = inst_23348;
var state_23403__$1 = state_23403;
if(cljs.core.truth_(inst_23349)){
var statearr_23451_23516 = state_23403__$1;
(statearr_23451_23516[(1)] = (27));

} else {
var statearr_23452_23517 = state_23403__$1;
(statearr_23452_23517[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (34))){
var state_23403__$1 = state_23403;
var statearr_23453_23518 = state_23403__$1;
(statearr_23453_23518[(2)] = null);

(statearr_23453_23518[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (17))){
var state_23403__$1 = state_23403;
var statearr_23454_23519 = state_23403__$1;
(statearr_23454_23519[(2)] = null);

(statearr_23454_23519[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (3))){
var inst_23401 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23403__$1,inst_23401);
} else {
if((state_val_23404 === (12))){
var inst_23330 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23455_23520 = state_23403__$1;
(statearr_23455_23520[(2)] = inst_23330);

(statearr_23455_23520[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (2))){
var state_23403__$1 = state_23403;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23403__$1,(4),ch);
} else {
if((state_val_23404 === (23))){
var state_23403__$1 = state_23403;
var statearr_23456_23521 = state_23403__$1;
(statearr_23456_23521[(2)] = null);

(statearr_23456_23521[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (35))){
var inst_23385 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23457_23522 = state_23403__$1;
(statearr_23457_23522[(2)] = inst_23385);

(statearr_23457_23522[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (19))){
var inst_23302 = (state_23403[(7)]);
var inst_23306 = cljs.core.chunk_first.call(null,inst_23302);
var inst_23307 = cljs.core.chunk_rest.call(null,inst_23302);
var inst_23308 = cljs.core.count.call(null,inst_23306);
var inst_23280 = inst_23307;
var inst_23281 = inst_23306;
var inst_23282 = inst_23308;
var inst_23283 = (0);
var state_23403__$1 = (function (){var statearr_23458 = state_23403;
(statearr_23458[(14)] = inst_23282);

(statearr_23458[(15)] = inst_23281);

(statearr_23458[(16)] = inst_23280);

(statearr_23458[(17)] = inst_23283);

return statearr_23458;
})();
var statearr_23459_23523 = state_23403__$1;
(statearr_23459_23523[(2)] = null);

(statearr_23459_23523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (11))){
var inst_23302 = (state_23403[(7)]);
var inst_23280 = (state_23403[(16)]);
var inst_23302__$1 = cljs.core.seq.call(null,inst_23280);
var state_23403__$1 = (function (){var statearr_23460 = state_23403;
(statearr_23460[(7)] = inst_23302__$1);

return statearr_23460;
})();
if(inst_23302__$1){
var statearr_23461_23524 = state_23403__$1;
(statearr_23461_23524[(1)] = (16));

} else {
var statearr_23462_23525 = state_23403__$1;
(statearr_23462_23525[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (9))){
var inst_23332 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23463_23526 = state_23403__$1;
(statearr_23463_23526[(2)] = inst_23332);

(statearr_23463_23526[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (5))){
var inst_23278 = cljs.core.deref.call(null,cs);
var inst_23279 = cljs.core.seq.call(null,inst_23278);
var inst_23280 = inst_23279;
var inst_23281 = null;
var inst_23282 = (0);
var inst_23283 = (0);
var state_23403__$1 = (function (){var statearr_23464 = state_23403;
(statearr_23464[(14)] = inst_23282);

(statearr_23464[(15)] = inst_23281);

(statearr_23464[(16)] = inst_23280);

(statearr_23464[(17)] = inst_23283);

return statearr_23464;
})();
var statearr_23465_23527 = state_23403__$1;
(statearr_23465_23527[(2)] = null);

(statearr_23465_23527[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (14))){
var state_23403__$1 = state_23403;
var statearr_23466_23528 = state_23403__$1;
(statearr_23466_23528[(2)] = null);

(statearr_23466_23528[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (45))){
var inst_23393 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23467_23529 = state_23403__$1;
(statearr_23467_23529[(2)] = inst_23393);

(statearr_23467_23529[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (26))){
var inst_23335 = (state_23403[(29)]);
var inst_23389 = (state_23403[(2)]);
var inst_23390 = cljs.core.seq.call(null,inst_23335);
var state_23403__$1 = (function (){var statearr_23468 = state_23403;
(statearr_23468[(31)] = inst_23389);

return statearr_23468;
})();
if(inst_23390){
var statearr_23469_23530 = state_23403__$1;
(statearr_23469_23530[(1)] = (42));

} else {
var statearr_23470_23531 = state_23403__$1;
(statearr_23470_23531[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (16))){
var inst_23302 = (state_23403[(7)]);
var inst_23304 = cljs.core.chunked_seq_QMARK_.call(null,inst_23302);
var state_23403__$1 = state_23403;
if(inst_23304){
var statearr_23471_23532 = state_23403__$1;
(statearr_23471_23532[(1)] = (19));

} else {
var statearr_23472_23533 = state_23403__$1;
(statearr_23472_23533[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (38))){
var inst_23382 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23473_23534 = state_23403__$1;
(statearr_23473_23534[(2)] = inst_23382);

(statearr_23473_23534[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (30))){
var state_23403__$1 = state_23403;
var statearr_23474_23535 = state_23403__$1;
(statearr_23474_23535[(2)] = null);

(statearr_23474_23535[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (10))){
var inst_23281 = (state_23403[(15)]);
var inst_23283 = (state_23403[(17)]);
var inst_23291 = cljs.core._nth.call(null,inst_23281,inst_23283);
var inst_23292 = cljs.core.nth.call(null,inst_23291,(0),null);
var inst_23293 = cljs.core.nth.call(null,inst_23291,(1),null);
var state_23403__$1 = (function (){var statearr_23475 = state_23403;
(statearr_23475[(26)] = inst_23292);

return statearr_23475;
})();
if(cljs.core.truth_(inst_23293)){
var statearr_23476_23536 = state_23403__$1;
(statearr_23476_23536[(1)] = (13));

} else {
var statearr_23477_23537 = state_23403__$1;
(statearr_23477_23537[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (18))){
var inst_23328 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23478_23538 = state_23403__$1;
(statearr_23478_23538[(2)] = inst_23328);

(statearr_23478_23538[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (42))){
var state_23403__$1 = state_23403;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23403__$1,(45),dchan);
} else {
if((state_val_23404 === (37))){
var inst_23371 = (state_23403[(23)]);
var inst_23362 = (state_23403[(25)]);
var inst_23271 = (state_23403[(11)]);
var inst_23371__$1 = cljs.core.first.call(null,inst_23362);
var inst_23372 = cljs.core.async.put_BANG_.call(null,inst_23371__$1,inst_23271,done);
var state_23403__$1 = (function (){var statearr_23479 = state_23403;
(statearr_23479[(23)] = inst_23371__$1);

return statearr_23479;
})();
if(cljs.core.truth_(inst_23372)){
var statearr_23480_23539 = state_23403__$1;
(statearr_23480_23539[(1)] = (39));

} else {
var statearr_23481_23540 = state_23403__$1;
(statearr_23481_23540[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (8))){
var inst_23282 = (state_23403[(14)]);
var inst_23283 = (state_23403[(17)]);
var inst_23285 = (inst_23283 < inst_23282);
var inst_23286 = inst_23285;
var state_23403__$1 = state_23403;
if(cljs.core.truth_(inst_23286)){
var statearr_23482_23541 = state_23403__$1;
(statearr_23482_23541[(1)] = (10));

} else {
var statearr_23483_23542 = state_23403__$1;
(statearr_23483_23542[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__22570__auto__ = null;
var cljs$core$async$mult_$_state_machine__22570__auto____0 = (function (){
var statearr_23484 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23484[(0)] = cljs$core$async$mult_$_state_machine__22570__auto__);

(statearr_23484[(1)] = (1));

return statearr_23484;
});
var cljs$core$async$mult_$_state_machine__22570__auto____1 = (function (state_23403){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_23403);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e23485){if((e23485 instanceof Object)){
var ex__22573__auto__ = e23485;
var statearr_23486_23543 = state_23403;
(statearr_23486_23543[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23403);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23485;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23544 = state_23403;
state_23403 = G__23544;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__22570__auto__ = function(state_23403){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__22570__auto____1.call(this,state_23403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__22570__auto____0;
cljs$core$async$mult_$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__22570__auto____1;
return cljs$core$async$mult_$_state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_23487 = f__22667__auto__.call(null);
(statearr_23487[(6)] = c__22666__auto___23488);

return statearr_23487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__23546 = arguments.length;
switch (G__23546) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_23548 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m,ch);
} else {
var m__4519__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_23548.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_23549 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m,ch);
} else {
var m__4519__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_23549.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_23550 = (function (m){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m);
} else {
var m__4519__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_23550.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_23551 = (function (m,state_map){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m,state_map);
} else {
var m__4519__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_23551.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_23552 = (function (m,mode){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m,mode);
} else {
var m__4519__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_23552.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___23562 = arguments.length;
var i__4830__auto___23563 = (0);
while(true){
if((i__4830__auto___23563 < len__4829__auto___23562)){
args__4835__auto__.push((arguments[i__4830__auto___23563]));

var G__23564 = (i__4830__auto___23563 + (1));
i__4830__auto___23563 = G__23564;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((3) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4836__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__23557){
var map__23558 = p__23557;
var map__23558__$1 = cljs.core.__destructure_map.call(null,map__23558);
var opts = map__23558__$1;
var statearr_23559_23565 = state;
(statearr_23559_23565[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_23560_23566 = state;
(statearr_23560_23566[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_23561_23567 = state;
(statearr_23561_23567[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq23553){
var G__23554 = cljs.core.first.call(null,seq23553);
var seq23553__$1 = cljs.core.next.call(null,seq23553);
var G__23555 = cljs.core.first.call(null,seq23553__$1);
var seq23553__$2 = cljs.core.next.call(null,seq23553__$1);
var G__23556 = cljs.core.first.call(null,seq23553__$2);
var seq23553__$3 = cljs.core.next.call(null,seq23553__$2);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__23554,G__23555,G__23556,seq23553__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23568 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23568 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta23569){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta23569 = meta23569;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23568.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23570,meta23569__$1){
var self__ = this;
var _23570__$1 = this;
return (new cljs.core.async.t_cljs$core$async23568(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta23569__$1));
}));

(cljs.core.async.t_cljs$core$async23568.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23570){
var self__ = this;
var _23570__$1 = this;
return self__.meta23569;
}));

(cljs.core.async.t_cljs$core$async23568.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23568.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async23568.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23568.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async23568.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async23568.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async23568.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async23568.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async23568.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta23569","meta23569",-1130406199,null)], null);
}));

(cljs.core.async.t_cljs$core$async23568.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23568.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23568");

(cljs.core.async.t_cljs$core$async23568.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async23568");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23568.
 */
cljs.core.async.__GT_t_cljs$core$async23568 = (function cljs$core$async$mix_$___GT_t_cljs$core$async23568(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta23569){
return (new cljs.core.async.t_cljs$core$async23568(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta23569));
});

}

return (new cljs.core.async.t_cljs$core$async23568(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__22666__auto___23682 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_23638){
var state_val_23639 = (state_23638[(1)]);
if((state_val_23639 === (7))){
var inst_23598 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
if(cljs.core.truth_(inst_23598)){
var statearr_23640_23683 = state_23638__$1;
(statearr_23640_23683[(1)] = (8));

} else {
var statearr_23641_23684 = state_23638__$1;
(statearr_23641_23684[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (20))){
var inst_23591 = (state_23638[(7)]);
var state_23638__$1 = state_23638;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23638__$1,(23),out,inst_23591);
} else {
if((state_val_23639 === (1))){
var inst_23574 = calc_state.call(null);
var inst_23575 = cljs.core.__destructure_map.call(null,inst_23574);
var inst_23576 = cljs.core.get.call(null,inst_23575,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_23577 = cljs.core.get.call(null,inst_23575,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_23578 = cljs.core.get.call(null,inst_23575,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_23579 = inst_23574;
var state_23638__$1 = (function (){var statearr_23642 = state_23638;
(statearr_23642[(8)] = inst_23578);

(statearr_23642[(9)] = inst_23579);

(statearr_23642[(10)] = inst_23577);

(statearr_23642[(11)] = inst_23576);

return statearr_23642;
})();
var statearr_23643_23685 = state_23638__$1;
(statearr_23643_23685[(2)] = null);

(statearr_23643_23685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (24))){
var inst_23582 = (state_23638[(12)]);
var inst_23579 = inst_23582;
var state_23638__$1 = (function (){var statearr_23644 = state_23638;
(statearr_23644[(9)] = inst_23579);

return statearr_23644;
})();
var statearr_23645_23686 = state_23638__$1;
(statearr_23645_23686[(2)] = null);

(statearr_23645_23686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (4))){
var inst_23593 = (state_23638[(13)]);
var inst_23591 = (state_23638[(7)]);
var inst_23590 = (state_23638[(2)]);
var inst_23591__$1 = cljs.core.nth.call(null,inst_23590,(0),null);
var inst_23592 = cljs.core.nth.call(null,inst_23590,(1),null);
var inst_23593__$1 = (inst_23591__$1 == null);
var state_23638__$1 = (function (){var statearr_23646 = state_23638;
(statearr_23646[(14)] = inst_23592);

(statearr_23646[(13)] = inst_23593__$1);

(statearr_23646[(7)] = inst_23591__$1);

return statearr_23646;
})();
if(cljs.core.truth_(inst_23593__$1)){
var statearr_23647_23687 = state_23638__$1;
(statearr_23647_23687[(1)] = (5));

} else {
var statearr_23648_23688 = state_23638__$1;
(statearr_23648_23688[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (15))){
var inst_23583 = (state_23638[(15)]);
var inst_23612 = (state_23638[(16)]);
var inst_23612__$1 = cljs.core.empty_QMARK_.call(null,inst_23583);
var state_23638__$1 = (function (){var statearr_23649 = state_23638;
(statearr_23649[(16)] = inst_23612__$1);

return statearr_23649;
})();
if(inst_23612__$1){
var statearr_23650_23689 = state_23638__$1;
(statearr_23650_23689[(1)] = (17));

} else {
var statearr_23651_23690 = state_23638__$1;
(statearr_23651_23690[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (21))){
var inst_23582 = (state_23638[(12)]);
var inst_23579 = inst_23582;
var state_23638__$1 = (function (){var statearr_23652 = state_23638;
(statearr_23652[(9)] = inst_23579);

return statearr_23652;
})();
var statearr_23653_23691 = state_23638__$1;
(statearr_23653_23691[(2)] = null);

(statearr_23653_23691[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (13))){
var inst_23605 = (state_23638[(2)]);
var inst_23606 = calc_state.call(null);
var inst_23579 = inst_23606;
var state_23638__$1 = (function (){var statearr_23654 = state_23638;
(statearr_23654[(9)] = inst_23579);

(statearr_23654[(17)] = inst_23605);

return statearr_23654;
})();
var statearr_23655_23692 = state_23638__$1;
(statearr_23655_23692[(2)] = null);

(statearr_23655_23692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (22))){
var inst_23632 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
var statearr_23656_23693 = state_23638__$1;
(statearr_23656_23693[(2)] = inst_23632);

(statearr_23656_23693[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (6))){
var inst_23592 = (state_23638[(14)]);
var inst_23596 = cljs.core._EQ_.call(null,inst_23592,change);
var state_23638__$1 = state_23638;
var statearr_23657_23694 = state_23638__$1;
(statearr_23657_23694[(2)] = inst_23596);

(statearr_23657_23694[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (25))){
var state_23638__$1 = state_23638;
var statearr_23658_23695 = state_23638__$1;
(statearr_23658_23695[(2)] = null);

(statearr_23658_23695[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (17))){
var inst_23592 = (state_23638[(14)]);
var inst_23584 = (state_23638[(18)]);
var inst_23614 = inst_23584.call(null,inst_23592);
var inst_23615 = cljs.core.not.call(null,inst_23614);
var state_23638__$1 = state_23638;
var statearr_23659_23696 = state_23638__$1;
(statearr_23659_23696[(2)] = inst_23615);

(statearr_23659_23696[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (3))){
var inst_23636 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23638__$1,inst_23636);
} else {
if((state_val_23639 === (12))){
var state_23638__$1 = state_23638;
var statearr_23660_23697 = state_23638__$1;
(statearr_23660_23697[(2)] = null);

(statearr_23660_23697[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (2))){
var inst_23582 = (state_23638[(12)]);
var inst_23579 = (state_23638[(9)]);
var inst_23582__$1 = cljs.core.__destructure_map.call(null,inst_23579);
var inst_23583 = cljs.core.get.call(null,inst_23582__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_23584 = cljs.core.get.call(null,inst_23582__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_23585 = cljs.core.get.call(null,inst_23582__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_23638__$1 = (function (){var statearr_23661 = state_23638;
(statearr_23661[(12)] = inst_23582__$1);

(statearr_23661[(15)] = inst_23583);

(statearr_23661[(18)] = inst_23584);

return statearr_23661;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_23638__$1,(4),inst_23585);
} else {
if((state_val_23639 === (23))){
var inst_23623 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
if(cljs.core.truth_(inst_23623)){
var statearr_23662_23698 = state_23638__$1;
(statearr_23662_23698[(1)] = (24));

} else {
var statearr_23663_23699 = state_23638__$1;
(statearr_23663_23699[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (19))){
var inst_23618 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
var statearr_23664_23700 = state_23638__$1;
(statearr_23664_23700[(2)] = inst_23618);

(statearr_23664_23700[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (11))){
var inst_23592 = (state_23638[(14)]);
var inst_23602 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_23592);
var state_23638__$1 = state_23638;
var statearr_23665_23701 = state_23638__$1;
(statearr_23665_23701[(2)] = inst_23602);

(statearr_23665_23701[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (9))){
var inst_23609 = (state_23638[(19)]);
var inst_23592 = (state_23638[(14)]);
var inst_23583 = (state_23638[(15)]);
var inst_23609__$1 = inst_23583.call(null,inst_23592);
var state_23638__$1 = (function (){var statearr_23666 = state_23638;
(statearr_23666[(19)] = inst_23609__$1);

return statearr_23666;
})();
if(cljs.core.truth_(inst_23609__$1)){
var statearr_23667_23702 = state_23638__$1;
(statearr_23667_23702[(1)] = (14));

} else {
var statearr_23668_23703 = state_23638__$1;
(statearr_23668_23703[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (5))){
var inst_23593 = (state_23638[(13)]);
var state_23638__$1 = state_23638;
var statearr_23669_23704 = state_23638__$1;
(statearr_23669_23704[(2)] = inst_23593);

(statearr_23669_23704[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (14))){
var inst_23609 = (state_23638[(19)]);
var state_23638__$1 = state_23638;
var statearr_23670_23705 = state_23638__$1;
(statearr_23670_23705[(2)] = inst_23609);

(statearr_23670_23705[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (26))){
var inst_23628 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
var statearr_23671_23706 = state_23638__$1;
(statearr_23671_23706[(2)] = inst_23628);

(statearr_23671_23706[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (16))){
var inst_23620 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
if(cljs.core.truth_(inst_23620)){
var statearr_23672_23707 = state_23638__$1;
(statearr_23672_23707[(1)] = (20));

} else {
var statearr_23673_23708 = state_23638__$1;
(statearr_23673_23708[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (10))){
var inst_23634 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
var statearr_23674_23709 = state_23638__$1;
(statearr_23674_23709[(2)] = inst_23634);

(statearr_23674_23709[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (18))){
var inst_23612 = (state_23638[(16)]);
var state_23638__$1 = state_23638;
var statearr_23675_23710 = state_23638__$1;
(statearr_23675_23710[(2)] = inst_23612);

(statearr_23675_23710[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23639 === (8))){
var inst_23591 = (state_23638[(7)]);
var inst_23600 = (inst_23591 == null);
var state_23638__$1 = state_23638;
if(cljs.core.truth_(inst_23600)){
var statearr_23676_23711 = state_23638__$1;
(statearr_23676_23711[(1)] = (11));

} else {
var statearr_23677_23712 = state_23638__$1;
(statearr_23677_23712[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__22570__auto__ = null;
var cljs$core$async$mix_$_state_machine__22570__auto____0 = (function (){
var statearr_23678 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23678[(0)] = cljs$core$async$mix_$_state_machine__22570__auto__);

(statearr_23678[(1)] = (1));

return statearr_23678;
});
var cljs$core$async$mix_$_state_machine__22570__auto____1 = (function (state_23638){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_23638);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e23679){if((e23679 instanceof Object)){
var ex__22573__auto__ = e23679;
var statearr_23680_23713 = state_23638;
(statearr_23680_23713[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23638);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23679;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23714 = state_23638;
state_23638 = G__23714;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__22570__auto__ = function(state_23638){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__22570__auto____1.call(this,state_23638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__22570__auto____0;
cljs$core$async$mix_$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__22570__auto____1;
return cljs$core$async$mix_$_state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_23681 = f__22667__auto__.call(null);
(statearr_23681[(6)] = c__22666__auto___23682);

return statearr_23681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_23717 = (function (p,v,ch,close_QMARK_){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4519__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_23717.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_23718 = (function (p,v,ch){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,p,v,ch);
} else {
var m__4519__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_23718.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_23719 = (function() {
var G__23720 = null;
var G__23720__1 = (function (p){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,p);
} else {
var m__4519__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__23720__2 = (function (p,v){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,p,v);
} else {
var m__4519__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__23720 = function(p,v){
switch(arguments.length){
case 1:
return G__23720__1.call(this,p);
case 2:
return G__23720__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23720.cljs$core$IFn$_invoke$arity$1 = G__23720__1;
G__23720.cljs$core$IFn$_invoke$arity$2 = G__23720__2;
return G__23720;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__23716 = arguments.length;
switch (G__23716) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_23719.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_23719.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__23724 = arguments.length;
switch (G__23724) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4223__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__23722_SHARP_){
if(cljs.core.truth_(p1__23722_SHARP_.call(null,topic))){
return p1__23722_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__23722_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23725 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23725 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta23726){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta23726 = meta23726;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23725.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23727,meta23726__$1){
var self__ = this;
var _23727__$1 = this;
return (new cljs.core.async.t_cljs$core$async23725(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta23726__$1));
}));

(cljs.core.async.t_cljs$core$async23725.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23727){
var self__ = this;
var _23727__$1 = this;
return self__.meta23726;
}));

(cljs.core.async.t_cljs$core$async23725.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23725.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async23725.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23725.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async23725.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async23725.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async23725.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async23725.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta23726","meta23726",-1732475887,null)], null);
}));

(cljs.core.async.t_cljs$core$async23725.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23725.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23725");

(cljs.core.async.t_cljs$core$async23725.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async23725");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23725.
 */
cljs.core.async.__GT_t_cljs$core$async23725 = (function cljs$core$async$__GT_t_cljs$core$async23725(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta23726){
return (new cljs.core.async.t_cljs$core$async23725(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta23726));
});

}

return (new cljs.core.async.t_cljs$core$async23725(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__22666__auto___23845 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_23799){
var state_val_23800 = (state_23799[(1)]);
if((state_val_23800 === (7))){
var inst_23795 = (state_23799[(2)]);
var state_23799__$1 = state_23799;
var statearr_23801_23846 = state_23799__$1;
(statearr_23801_23846[(2)] = inst_23795);

(statearr_23801_23846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (20))){
var state_23799__$1 = state_23799;
var statearr_23802_23847 = state_23799__$1;
(statearr_23802_23847[(2)] = null);

(statearr_23802_23847[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (1))){
var state_23799__$1 = state_23799;
var statearr_23803_23848 = state_23799__$1;
(statearr_23803_23848[(2)] = null);

(statearr_23803_23848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (24))){
var inst_23778 = (state_23799[(7)]);
var inst_23787 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_23778);
var state_23799__$1 = state_23799;
var statearr_23804_23849 = state_23799__$1;
(statearr_23804_23849[(2)] = inst_23787);

(statearr_23804_23849[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (4))){
var inst_23730 = (state_23799[(8)]);
var inst_23730__$1 = (state_23799[(2)]);
var inst_23731 = (inst_23730__$1 == null);
var state_23799__$1 = (function (){var statearr_23805 = state_23799;
(statearr_23805[(8)] = inst_23730__$1);

return statearr_23805;
})();
if(cljs.core.truth_(inst_23731)){
var statearr_23806_23850 = state_23799__$1;
(statearr_23806_23850[(1)] = (5));

} else {
var statearr_23807_23851 = state_23799__$1;
(statearr_23807_23851[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (15))){
var inst_23772 = (state_23799[(2)]);
var state_23799__$1 = state_23799;
var statearr_23808_23852 = state_23799__$1;
(statearr_23808_23852[(2)] = inst_23772);

(statearr_23808_23852[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (21))){
var inst_23792 = (state_23799[(2)]);
var state_23799__$1 = (function (){var statearr_23809 = state_23799;
(statearr_23809[(9)] = inst_23792);

return statearr_23809;
})();
var statearr_23810_23853 = state_23799__$1;
(statearr_23810_23853[(2)] = null);

(statearr_23810_23853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (13))){
var inst_23754 = (state_23799[(10)]);
var inst_23756 = cljs.core.chunked_seq_QMARK_.call(null,inst_23754);
var state_23799__$1 = state_23799;
if(inst_23756){
var statearr_23811_23854 = state_23799__$1;
(statearr_23811_23854[(1)] = (16));

} else {
var statearr_23812_23855 = state_23799__$1;
(statearr_23812_23855[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (22))){
var inst_23784 = (state_23799[(2)]);
var state_23799__$1 = state_23799;
if(cljs.core.truth_(inst_23784)){
var statearr_23813_23856 = state_23799__$1;
(statearr_23813_23856[(1)] = (23));

} else {
var statearr_23814_23857 = state_23799__$1;
(statearr_23814_23857[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (6))){
var inst_23778 = (state_23799[(7)]);
var inst_23780 = (state_23799[(11)]);
var inst_23730 = (state_23799[(8)]);
var inst_23778__$1 = topic_fn.call(null,inst_23730);
var inst_23779 = cljs.core.deref.call(null,mults);
var inst_23780__$1 = cljs.core.get.call(null,inst_23779,inst_23778__$1);
var state_23799__$1 = (function (){var statearr_23815 = state_23799;
(statearr_23815[(7)] = inst_23778__$1);

(statearr_23815[(11)] = inst_23780__$1);

return statearr_23815;
})();
if(cljs.core.truth_(inst_23780__$1)){
var statearr_23816_23858 = state_23799__$1;
(statearr_23816_23858[(1)] = (19));

} else {
var statearr_23817_23859 = state_23799__$1;
(statearr_23817_23859[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (25))){
var inst_23789 = (state_23799[(2)]);
var state_23799__$1 = state_23799;
var statearr_23818_23860 = state_23799__$1;
(statearr_23818_23860[(2)] = inst_23789);

(statearr_23818_23860[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (17))){
var inst_23754 = (state_23799[(10)]);
var inst_23763 = cljs.core.first.call(null,inst_23754);
var inst_23764 = cljs.core.async.muxch_STAR_.call(null,inst_23763);
var inst_23765 = cljs.core.async.close_BANG_.call(null,inst_23764);
var inst_23766 = cljs.core.next.call(null,inst_23754);
var inst_23740 = inst_23766;
var inst_23741 = null;
var inst_23742 = (0);
var inst_23743 = (0);
var state_23799__$1 = (function (){var statearr_23819 = state_23799;
(statearr_23819[(12)] = inst_23741);

(statearr_23819[(13)] = inst_23742);

(statearr_23819[(14)] = inst_23740);

(statearr_23819[(15)] = inst_23765);

(statearr_23819[(16)] = inst_23743);

return statearr_23819;
})();
var statearr_23820_23861 = state_23799__$1;
(statearr_23820_23861[(2)] = null);

(statearr_23820_23861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (3))){
var inst_23797 = (state_23799[(2)]);
var state_23799__$1 = state_23799;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23799__$1,inst_23797);
} else {
if((state_val_23800 === (12))){
var inst_23774 = (state_23799[(2)]);
var state_23799__$1 = state_23799;
var statearr_23821_23862 = state_23799__$1;
(statearr_23821_23862[(2)] = inst_23774);

(statearr_23821_23862[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (2))){
var state_23799__$1 = state_23799;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23799__$1,(4),ch);
} else {
if((state_val_23800 === (23))){
var state_23799__$1 = state_23799;
var statearr_23822_23863 = state_23799__$1;
(statearr_23822_23863[(2)] = null);

(statearr_23822_23863[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (19))){
var inst_23780 = (state_23799[(11)]);
var inst_23730 = (state_23799[(8)]);
var inst_23782 = cljs.core.async.muxch_STAR_.call(null,inst_23780);
var state_23799__$1 = state_23799;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23799__$1,(22),inst_23782,inst_23730);
} else {
if((state_val_23800 === (11))){
var inst_23754 = (state_23799[(10)]);
var inst_23740 = (state_23799[(14)]);
var inst_23754__$1 = cljs.core.seq.call(null,inst_23740);
var state_23799__$1 = (function (){var statearr_23823 = state_23799;
(statearr_23823[(10)] = inst_23754__$1);

return statearr_23823;
})();
if(inst_23754__$1){
var statearr_23824_23864 = state_23799__$1;
(statearr_23824_23864[(1)] = (13));

} else {
var statearr_23825_23865 = state_23799__$1;
(statearr_23825_23865[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (9))){
var inst_23776 = (state_23799[(2)]);
var state_23799__$1 = state_23799;
var statearr_23826_23866 = state_23799__$1;
(statearr_23826_23866[(2)] = inst_23776);

(statearr_23826_23866[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (5))){
var inst_23737 = cljs.core.deref.call(null,mults);
var inst_23738 = cljs.core.vals.call(null,inst_23737);
var inst_23739 = cljs.core.seq.call(null,inst_23738);
var inst_23740 = inst_23739;
var inst_23741 = null;
var inst_23742 = (0);
var inst_23743 = (0);
var state_23799__$1 = (function (){var statearr_23827 = state_23799;
(statearr_23827[(12)] = inst_23741);

(statearr_23827[(13)] = inst_23742);

(statearr_23827[(14)] = inst_23740);

(statearr_23827[(16)] = inst_23743);

return statearr_23827;
})();
var statearr_23828_23867 = state_23799__$1;
(statearr_23828_23867[(2)] = null);

(statearr_23828_23867[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (14))){
var state_23799__$1 = state_23799;
var statearr_23832_23868 = state_23799__$1;
(statearr_23832_23868[(2)] = null);

(statearr_23832_23868[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (16))){
var inst_23754 = (state_23799[(10)]);
var inst_23758 = cljs.core.chunk_first.call(null,inst_23754);
var inst_23759 = cljs.core.chunk_rest.call(null,inst_23754);
var inst_23760 = cljs.core.count.call(null,inst_23758);
var inst_23740 = inst_23759;
var inst_23741 = inst_23758;
var inst_23742 = inst_23760;
var inst_23743 = (0);
var state_23799__$1 = (function (){var statearr_23833 = state_23799;
(statearr_23833[(12)] = inst_23741);

(statearr_23833[(13)] = inst_23742);

(statearr_23833[(14)] = inst_23740);

(statearr_23833[(16)] = inst_23743);

return statearr_23833;
})();
var statearr_23834_23869 = state_23799__$1;
(statearr_23834_23869[(2)] = null);

(statearr_23834_23869[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (10))){
var inst_23741 = (state_23799[(12)]);
var inst_23742 = (state_23799[(13)]);
var inst_23740 = (state_23799[(14)]);
var inst_23743 = (state_23799[(16)]);
var inst_23748 = cljs.core._nth.call(null,inst_23741,inst_23743);
var inst_23749 = cljs.core.async.muxch_STAR_.call(null,inst_23748);
var inst_23750 = cljs.core.async.close_BANG_.call(null,inst_23749);
var inst_23751 = (inst_23743 + (1));
var tmp23829 = inst_23741;
var tmp23830 = inst_23742;
var tmp23831 = inst_23740;
var inst_23740__$1 = tmp23831;
var inst_23741__$1 = tmp23829;
var inst_23742__$1 = tmp23830;
var inst_23743__$1 = inst_23751;
var state_23799__$1 = (function (){var statearr_23835 = state_23799;
(statearr_23835[(12)] = inst_23741__$1);

(statearr_23835[(17)] = inst_23750);

(statearr_23835[(13)] = inst_23742__$1);

(statearr_23835[(14)] = inst_23740__$1);

(statearr_23835[(16)] = inst_23743__$1);

return statearr_23835;
})();
var statearr_23836_23870 = state_23799__$1;
(statearr_23836_23870[(2)] = null);

(statearr_23836_23870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (18))){
var inst_23769 = (state_23799[(2)]);
var state_23799__$1 = state_23799;
var statearr_23837_23871 = state_23799__$1;
(statearr_23837_23871[(2)] = inst_23769);

(statearr_23837_23871[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23800 === (8))){
var inst_23742 = (state_23799[(13)]);
var inst_23743 = (state_23799[(16)]);
var inst_23745 = (inst_23743 < inst_23742);
var inst_23746 = inst_23745;
var state_23799__$1 = state_23799;
if(cljs.core.truth_(inst_23746)){
var statearr_23838_23872 = state_23799__$1;
(statearr_23838_23872[(1)] = (10));

} else {
var statearr_23839_23873 = state_23799__$1;
(statearr_23839_23873[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__22570__auto__ = null;
var cljs$core$async$state_machine__22570__auto____0 = (function (){
var statearr_23840 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23840[(0)] = cljs$core$async$state_machine__22570__auto__);

(statearr_23840[(1)] = (1));

return statearr_23840;
});
var cljs$core$async$state_machine__22570__auto____1 = (function (state_23799){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_23799);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e23841){if((e23841 instanceof Object)){
var ex__22573__auto__ = e23841;
var statearr_23842_23874 = state_23799;
(statearr_23842_23874[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23799);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23841;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23875 = state_23799;
state_23799 = G__23875;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$state_machine__22570__auto__ = function(state_23799){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22570__auto____1.call(this,state_23799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22570__auto____0;
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22570__auto____1;
return cljs$core$async$state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_23843 = f__22667__auto__.call(null);
(statearr_23843[(6)] = c__22666__auto___23845);

return statearr_23843;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__23877 = arguments.length;
switch (G__23877) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__23880 = arguments.length;
switch (G__23880) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__23883 = arguments.length;
switch (G__23883) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
var c__22666__auto___23950 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_23922){
var state_val_23923 = (state_23922[(1)]);
if((state_val_23923 === (7))){
var state_23922__$1 = state_23922;
var statearr_23924_23951 = state_23922__$1;
(statearr_23924_23951[(2)] = null);

(statearr_23924_23951[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23923 === (1))){
var state_23922__$1 = state_23922;
var statearr_23925_23952 = state_23922__$1;
(statearr_23925_23952[(2)] = null);

(statearr_23925_23952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23923 === (4))){
var inst_23886 = (state_23922[(7)]);
var inst_23888 = (inst_23886 < cnt);
var state_23922__$1 = state_23922;
if(cljs.core.truth_(inst_23888)){
var statearr_23926_23953 = state_23922__$1;
(statearr_23926_23953[(1)] = (6));

} else {
var statearr_23927_23954 = state_23922__$1;
(statearr_23927_23954[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23923 === (15))){
var inst_23918 = (state_23922[(2)]);
var state_23922__$1 = state_23922;
var statearr_23928_23955 = state_23922__$1;
(statearr_23928_23955[(2)] = inst_23918);

(statearr_23928_23955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23923 === (13))){
var inst_23911 = cljs.core.async.close_BANG_.call(null,out);
var state_23922__$1 = state_23922;
var statearr_23929_23956 = state_23922__$1;
(statearr_23929_23956[(2)] = inst_23911);

(statearr_23929_23956[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23923 === (6))){
var state_23922__$1 = state_23922;
var statearr_23930_23957 = state_23922__$1;
(statearr_23930_23957[(2)] = null);

(statearr_23930_23957[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23923 === (3))){
var inst_23920 = (state_23922[(2)]);
var state_23922__$1 = state_23922;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23922__$1,inst_23920);
} else {
if((state_val_23923 === (12))){
var inst_23908 = (state_23922[(8)]);
var inst_23908__$1 = (state_23922[(2)]);
var inst_23909 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_23908__$1);
var state_23922__$1 = (function (){var statearr_23931 = state_23922;
(statearr_23931[(8)] = inst_23908__$1);

return statearr_23931;
})();
if(cljs.core.truth_(inst_23909)){
var statearr_23932_23958 = state_23922__$1;
(statearr_23932_23958[(1)] = (13));

} else {
var statearr_23933_23959 = state_23922__$1;
(statearr_23933_23959[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23923 === (2))){
var inst_23885 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_23886 = (0);
var state_23922__$1 = (function (){var statearr_23934 = state_23922;
(statearr_23934[(9)] = inst_23885);

(statearr_23934[(7)] = inst_23886);

return statearr_23934;
})();
var statearr_23935_23960 = state_23922__$1;
(statearr_23935_23960[(2)] = null);

(statearr_23935_23960[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23923 === (11))){
var inst_23886 = (state_23922[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_23922,(10),Object,null,(9));
var inst_23895 = chs__$1.call(null,inst_23886);
var inst_23896 = done.call(null,inst_23886);
var inst_23897 = cljs.core.async.take_BANG_.call(null,inst_23895,inst_23896);
var state_23922__$1 = state_23922;
var statearr_23936_23961 = state_23922__$1;
(statearr_23936_23961[(2)] = inst_23897);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23922__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23923 === (9))){
var inst_23886 = (state_23922[(7)]);
var inst_23899 = (state_23922[(2)]);
var inst_23900 = (inst_23886 + (1));
var inst_23886__$1 = inst_23900;
var state_23922__$1 = (function (){var statearr_23937 = state_23922;
(statearr_23937[(10)] = inst_23899);

(statearr_23937[(7)] = inst_23886__$1);

return statearr_23937;
})();
var statearr_23938_23962 = state_23922__$1;
(statearr_23938_23962[(2)] = null);

(statearr_23938_23962[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23923 === (5))){
var inst_23906 = (state_23922[(2)]);
var state_23922__$1 = (function (){var statearr_23939 = state_23922;
(statearr_23939[(11)] = inst_23906);

return statearr_23939;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23922__$1,(12),dchan);
} else {
if((state_val_23923 === (14))){
var inst_23908 = (state_23922[(8)]);
var inst_23913 = cljs.core.apply.call(null,f,inst_23908);
var state_23922__$1 = state_23922;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23922__$1,(16),out,inst_23913);
} else {
if((state_val_23923 === (16))){
var inst_23915 = (state_23922[(2)]);
var state_23922__$1 = (function (){var statearr_23940 = state_23922;
(statearr_23940[(12)] = inst_23915);

return statearr_23940;
})();
var statearr_23941_23963 = state_23922__$1;
(statearr_23941_23963[(2)] = null);

(statearr_23941_23963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23923 === (10))){
var inst_23890 = (state_23922[(2)]);
var inst_23891 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_23922__$1 = (function (){var statearr_23942 = state_23922;
(statearr_23942[(13)] = inst_23890);

return statearr_23942;
})();
var statearr_23943_23964 = state_23922__$1;
(statearr_23943_23964[(2)] = inst_23891);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23922__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23923 === (8))){
var inst_23904 = (state_23922[(2)]);
var state_23922__$1 = state_23922;
var statearr_23944_23965 = state_23922__$1;
(statearr_23944_23965[(2)] = inst_23904);

(statearr_23944_23965[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__22570__auto__ = null;
var cljs$core$async$state_machine__22570__auto____0 = (function (){
var statearr_23945 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23945[(0)] = cljs$core$async$state_machine__22570__auto__);

(statearr_23945[(1)] = (1));

return statearr_23945;
});
var cljs$core$async$state_machine__22570__auto____1 = (function (state_23922){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_23922);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e23946){if((e23946 instanceof Object)){
var ex__22573__auto__ = e23946;
var statearr_23947_23966 = state_23922;
(statearr_23947_23966[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23922);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23946;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23967 = state_23922;
state_23922 = G__23967;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$state_machine__22570__auto__ = function(state_23922){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22570__auto____1.call(this,state_23922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22570__auto____0;
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22570__auto____1;
return cljs$core$async$state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_23948 = f__22667__auto__.call(null);
(statearr_23948[(6)] = c__22666__auto___23950);

return statearr_23948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__23970 = arguments.length;
switch (G__23970) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22666__auto___24024 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_24002){
var state_val_24003 = (state_24002[(1)]);
if((state_val_24003 === (7))){
var inst_23982 = (state_24002[(7)]);
var inst_23981 = (state_24002[(8)]);
var inst_23981__$1 = (state_24002[(2)]);
var inst_23982__$1 = cljs.core.nth.call(null,inst_23981__$1,(0),null);
var inst_23983 = cljs.core.nth.call(null,inst_23981__$1,(1),null);
var inst_23984 = (inst_23982__$1 == null);
var state_24002__$1 = (function (){var statearr_24004 = state_24002;
(statearr_24004[(7)] = inst_23982__$1);

(statearr_24004[(9)] = inst_23983);

(statearr_24004[(8)] = inst_23981__$1);

return statearr_24004;
})();
if(cljs.core.truth_(inst_23984)){
var statearr_24005_24025 = state_24002__$1;
(statearr_24005_24025[(1)] = (8));

} else {
var statearr_24006_24026 = state_24002__$1;
(statearr_24006_24026[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24003 === (1))){
var inst_23971 = cljs.core.vec.call(null,chs);
var inst_23972 = inst_23971;
var state_24002__$1 = (function (){var statearr_24007 = state_24002;
(statearr_24007[(10)] = inst_23972);

return statearr_24007;
})();
var statearr_24008_24027 = state_24002__$1;
(statearr_24008_24027[(2)] = null);

(statearr_24008_24027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24003 === (4))){
var inst_23972 = (state_24002[(10)]);
var state_24002__$1 = state_24002;
return cljs.core.async.ioc_alts_BANG_.call(null,state_24002__$1,(7),inst_23972);
} else {
if((state_val_24003 === (6))){
var inst_23998 = (state_24002[(2)]);
var state_24002__$1 = state_24002;
var statearr_24009_24028 = state_24002__$1;
(statearr_24009_24028[(2)] = inst_23998);

(statearr_24009_24028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24003 === (3))){
var inst_24000 = (state_24002[(2)]);
var state_24002__$1 = state_24002;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24002__$1,inst_24000);
} else {
if((state_val_24003 === (2))){
var inst_23972 = (state_24002[(10)]);
var inst_23974 = cljs.core.count.call(null,inst_23972);
var inst_23975 = (inst_23974 > (0));
var state_24002__$1 = state_24002;
if(cljs.core.truth_(inst_23975)){
var statearr_24011_24029 = state_24002__$1;
(statearr_24011_24029[(1)] = (4));

} else {
var statearr_24012_24030 = state_24002__$1;
(statearr_24012_24030[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24003 === (11))){
var inst_23972 = (state_24002[(10)]);
var inst_23991 = (state_24002[(2)]);
var tmp24010 = inst_23972;
var inst_23972__$1 = tmp24010;
var state_24002__$1 = (function (){var statearr_24013 = state_24002;
(statearr_24013[(10)] = inst_23972__$1);

(statearr_24013[(11)] = inst_23991);

return statearr_24013;
})();
var statearr_24014_24031 = state_24002__$1;
(statearr_24014_24031[(2)] = null);

(statearr_24014_24031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24003 === (9))){
var inst_23982 = (state_24002[(7)]);
var state_24002__$1 = state_24002;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24002__$1,(11),out,inst_23982);
} else {
if((state_val_24003 === (5))){
var inst_23996 = cljs.core.async.close_BANG_.call(null,out);
var state_24002__$1 = state_24002;
var statearr_24015_24032 = state_24002__$1;
(statearr_24015_24032[(2)] = inst_23996);

(statearr_24015_24032[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24003 === (10))){
var inst_23994 = (state_24002[(2)]);
var state_24002__$1 = state_24002;
var statearr_24016_24033 = state_24002__$1;
(statearr_24016_24033[(2)] = inst_23994);

(statearr_24016_24033[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24003 === (8))){
var inst_23972 = (state_24002[(10)]);
var inst_23982 = (state_24002[(7)]);
var inst_23983 = (state_24002[(9)]);
var inst_23981 = (state_24002[(8)]);
var inst_23986 = (function (){var cs = inst_23972;
var vec__23977 = inst_23981;
var v = inst_23982;
var c = inst_23983;
return (function (p1__23968_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__23968_SHARP_);
});
})();
var inst_23987 = cljs.core.filterv.call(null,inst_23986,inst_23972);
var inst_23972__$1 = inst_23987;
var state_24002__$1 = (function (){var statearr_24017 = state_24002;
(statearr_24017[(10)] = inst_23972__$1);

return statearr_24017;
})();
var statearr_24018_24034 = state_24002__$1;
(statearr_24018_24034[(2)] = null);

(statearr_24018_24034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__22570__auto__ = null;
var cljs$core$async$state_machine__22570__auto____0 = (function (){
var statearr_24019 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24019[(0)] = cljs$core$async$state_machine__22570__auto__);

(statearr_24019[(1)] = (1));

return statearr_24019;
});
var cljs$core$async$state_machine__22570__auto____1 = (function (state_24002){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_24002);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e24020){if((e24020 instanceof Object)){
var ex__22573__auto__ = e24020;
var statearr_24021_24035 = state_24002;
(statearr_24021_24035[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24002);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24020;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24036 = state_24002;
state_24002 = G__24036;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$state_machine__22570__auto__ = function(state_24002){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22570__auto____1.call(this,state_24002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22570__auto____0;
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22570__auto____1;
return cljs$core$async$state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_24022 = f__22667__auto__.call(null);
(statearr_24022[(6)] = c__22666__auto___24024);

return statearr_24022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__24038 = arguments.length;
switch (G__24038) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22666__auto___24083 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_24062){
var state_val_24063 = (state_24062[(1)]);
if((state_val_24063 === (7))){
var inst_24044 = (state_24062[(7)]);
var inst_24044__$1 = (state_24062[(2)]);
var inst_24045 = (inst_24044__$1 == null);
var inst_24046 = cljs.core.not.call(null,inst_24045);
var state_24062__$1 = (function (){var statearr_24064 = state_24062;
(statearr_24064[(7)] = inst_24044__$1);

return statearr_24064;
})();
if(inst_24046){
var statearr_24065_24084 = state_24062__$1;
(statearr_24065_24084[(1)] = (8));

} else {
var statearr_24066_24085 = state_24062__$1;
(statearr_24066_24085[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (1))){
var inst_24039 = (0);
var state_24062__$1 = (function (){var statearr_24067 = state_24062;
(statearr_24067[(8)] = inst_24039);

return statearr_24067;
})();
var statearr_24068_24086 = state_24062__$1;
(statearr_24068_24086[(2)] = null);

(statearr_24068_24086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (4))){
var state_24062__$1 = state_24062;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24062__$1,(7),ch);
} else {
if((state_val_24063 === (6))){
var inst_24057 = (state_24062[(2)]);
var state_24062__$1 = state_24062;
var statearr_24069_24087 = state_24062__$1;
(statearr_24069_24087[(2)] = inst_24057);

(statearr_24069_24087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (3))){
var inst_24059 = (state_24062[(2)]);
var inst_24060 = cljs.core.async.close_BANG_.call(null,out);
var state_24062__$1 = (function (){var statearr_24070 = state_24062;
(statearr_24070[(9)] = inst_24059);

return statearr_24070;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24062__$1,inst_24060);
} else {
if((state_val_24063 === (2))){
var inst_24039 = (state_24062[(8)]);
var inst_24041 = (inst_24039 < n);
var state_24062__$1 = state_24062;
if(cljs.core.truth_(inst_24041)){
var statearr_24071_24088 = state_24062__$1;
(statearr_24071_24088[(1)] = (4));

} else {
var statearr_24072_24089 = state_24062__$1;
(statearr_24072_24089[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (11))){
var inst_24039 = (state_24062[(8)]);
var inst_24049 = (state_24062[(2)]);
var inst_24050 = (inst_24039 + (1));
var inst_24039__$1 = inst_24050;
var state_24062__$1 = (function (){var statearr_24073 = state_24062;
(statearr_24073[(10)] = inst_24049);

(statearr_24073[(8)] = inst_24039__$1);

return statearr_24073;
})();
var statearr_24074_24090 = state_24062__$1;
(statearr_24074_24090[(2)] = null);

(statearr_24074_24090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (9))){
var state_24062__$1 = state_24062;
var statearr_24075_24091 = state_24062__$1;
(statearr_24075_24091[(2)] = null);

(statearr_24075_24091[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (5))){
var state_24062__$1 = state_24062;
var statearr_24076_24092 = state_24062__$1;
(statearr_24076_24092[(2)] = null);

(statearr_24076_24092[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (10))){
var inst_24054 = (state_24062[(2)]);
var state_24062__$1 = state_24062;
var statearr_24077_24093 = state_24062__$1;
(statearr_24077_24093[(2)] = inst_24054);

(statearr_24077_24093[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (8))){
var inst_24044 = (state_24062[(7)]);
var state_24062__$1 = state_24062;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24062__$1,(11),out,inst_24044);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__22570__auto__ = null;
var cljs$core$async$state_machine__22570__auto____0 = (function (){
var statearr_24078 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24078[(0)] = cljs$core$async$state_machine__22570__auto__);

(statearr_24078[(1)] = (1));

return statearr_24078;
});
var cljs$core$async$state_machine__22570__auto____1 = (function (state_24062){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_24062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e24079){if((e24079 instanceof Object)){
var ex__22573__auto__ = e24079;
var statearr_24080_24094 = state_24062;
(statearr_24080_24094[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24062);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24079;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24095 = state_24062;
state_24062 = G__24095;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$state_machine__22570__auto__ = function(state_24062){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22570__auto____1.call(this,state_24062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22570__auto____0;
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22570__auto____1;
return cljs$core$async$state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_24081 = f__22667__auto__.call(null);
(statearr_24081[(6)] = c__22666__auto___24083);

return statearr_24081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24097 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24097 = (function (f,ch,meta24098){
this.f = f;
this.ch = ch;
this.meta24098 = meta24098;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24097.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24099,meta24098__$1){
var self__ = this;
var _24099__$1 = this;
return (new cljs.core.async.t_cljs$core$async24097(self__.f,self__.ch,meta24098__$1));
}));

(cljs.core.async.t_cljs$core$async24097.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24099){
var self__ = this;
var _24099__$1 = this;
return self__.meta24098;
}));

(cljs.core.async.t_cljs$core$async24097.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24097.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async24097.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async24097.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24097.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24100 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24100 = (function (f,ch,meta24098,_,fn1,meta24101){
this.f = f;
this.ch = ch;
this.meta24098 = meta24098;
this._ = _;
this.fn1 = fn1;
this.meta24101 = meta24101;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24100.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24102,meta24101__$1){
var self__ = this;
var _24102__$1 = this;
return (new cljs.core.async.t_cljs$core$async24100(self__.f,self__.ch,self__.meta24098,self__._,self__.fn1,meta24101__$1));
}));

(cljs.core.async.t_cljs$core$async24100.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24102){
var self__ = this;
var _24102__$1 = this;
return self__.meta24101;
}));

(cljs.core.async.t_cljs$core$async24100.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24100.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async24100.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async24100.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__24096_SHARP_){
return f1.call(null,(((p1__24096_SHARP_ == null))?null:self__.f.call(null,p1__24096_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async24100.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24098","meta24098",-2115376422,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async24097","cljs.core.async/t_cljs$core$async24097",-1025412259,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta24101","meta24101",-1866743721,null)], null);
}));

(cljs.core.async.t_cljs$core$async24100.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24100.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24100");

(cljs.core.async.t_cljs$core$async24100.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async24100");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24100.
 */
cljs.core.async.__GT_t_cljs$core$async24100 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async24100(f__$1,ch__$1,meta24098__$1,___$2,fn1__$1,meta24101){
return (new cljs.core.async.t_cljs$core$async24100(f__$1,ch__$1,meta24098__$1,___$2,fn1__$1,meta24101));
});

}

return (new cljs.core.async.t_cljs$core$async24100(self__.f,self__.ch,self__.meta24098,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4221__auto__ = ret;
if(cljs.core.truth_(and__4221__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4221__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async24097.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24097.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async24097.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24098","meta24098",-2115376422,null)], null);
}));

(cljs.core.async.t_cljs$core$async24097.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24097.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24097");

(cljs.core.async.t_cljs$core$async24097.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async24097");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24097.
 */
cljs.core.async.__GT_t_cljs$core$async24097 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async24097(f__$1,ch__$1,meta24098){
return (new cljs.core.async.t_cljs$core$async24097(f__$1,ch__$1,meta24098));
});

}

return (new cljs.core.async.t_cljs$core$async24097(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24103 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24103 = (function (f,ch,meta24104){
this.f = f;
this.ch = ch;
this.meta24104 = meta24104;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24103.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24105,meta24104__$1){
var self__ = this;
var _24105__$1 = this;
return (new cljs.core.async.t_cljs$core$async24103(self__.f,self__.ch,meta24104__$1));
}));

(cljs.core.async.t_cljs$core$async24103.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24105){
var self__ = this;
var _24105__$1 = this;
return self__.meta24104;
}));

(cljs.core.async.t_cljs$core$async24103.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24103.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async24103.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24103.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async24103.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24103.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async24103.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24104","meta24104",478022618,null)], null);
}));

(cljs.core.async.t_cljs$core$async24103.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24103.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24103");

(cljs.core.async.t_cljs$core$async24103.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async24103");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24103.
 */
cljs.core.async.__GT_t_cljs$core$async24103 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async24103(f__$1,ch__$1,meta24104){
return (new cljs.core.async.t_cljs$core$async24103(f__$1,ch__$1,meta24104));
});

}

return (new cljs.core.async.t_cljs$core$async24103(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24106 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24106 = (function (p,ch,meta24107){
this.p = p;
this.ch = ch;
this.meta24107 = meta24107;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24106.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24108,meta24107__$1){
var self__ = this;
var _24108__$1 = this;
return (new cljs.core.async.t_cljs$core$async24106(self__.p,self__.ch,meta24107__$1));
}));

(cljs.core.async.t_cljs$core$async24106.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24108){
var self__ = this;
var _24108__$1 = this;
return self__.meta24107;
}));

(cljs.core.async.t_cljs$core$async24106.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24106.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async24106.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async24106.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24106.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async24106.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24106.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async24106.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24107","meta24107",-653995411,null)], null);
}));

(cljs.core.async.t_cljs$core$async24106.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24106.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24106");

(cljs.core.async.t_cljs$core$async24106.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async24106");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24106.
 */
cljs.core.async.__GT_t_cljs$core$async24106 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async24106(p__$1,ch__$1,meta24107){
return (new cljs.core.async.t_cljs$core$async24106(p__$1,ch__$1,meta24107));
});

}

return (new cljs.core.async.t_cljs$core$async24106(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__24110 = arguments.length;
switch (G__24110) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22666__auto___24150 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_24131){
var state_val_24132 = (state_24131[(1)]);
if((state_val_24132 === (7))){
var inst_24127 = (state_24131[(2)]);
var state_24131__$1 = state_24131;
var statearr_24133_24151 = state_24131__$1;
(statearr_24133_24151[(2)] = inst_24127);

(statearr_24133_24151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24132 === (1))){
var state_24131__$1 = state_24131;
var statearr_24134_24152 = state_24131__$1;
(statearr_24134_24152[(2)] = null);

(statearr_24134_24152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24132 === (4))){
var inst_24113 = (state_24131[(7)]);
var inst_24113__$1 = (state_24131[(2)]);
var inst_24114 = (inst_24113__$1 == null);
var state_24131__$1 = (function (){var statearr_24135 = state_24131;
(statearr_24135[(7)] = inst_24113__$1);

return statearr_24135;
})();
if(cljs.core.truth_(inst_24114)){
var statearr_24136_24153 = state_24131__$1;
(statearr_24136_24153[(1)] = (5));

} else {
var statearr_24137_24154 = state_24131__$1;
(statearr_24137_24154[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24132 === (6))){
var inst_24113 = (state_24131[(7)]);
var inst_24118 = p.call(null,inst_24113);
var state_24131__$1 = state_24131;
if(cljs.core.truth_(inst_24118)){
var statearr_24138_24155 = state_24131__$1;
(statearr_24138_24155[(1)] = (8));

} else {
var statearr_24139_24156 = state_24131__$1;
(statearr_24139_24156[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24132 === (3))){
var inst_24129 = (state_24131[(2)]);
var state_24131__$1 = state_24131;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24131__$1,inst_24129);
} else {
if((state_val_24132 === (2))){
var state_24131__$1 = state_24131;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24131__$1,(4),ch);
} else {
if((state_val_24132 === (11))){
var inst_24121 = (state_24131[(2)]);
var state_24131__$1 = state_24131;
var statearr_24140_24157 = state_24131__$1;
(statearr_24140_24157[(2)] = inst_24121);

(statearr_24140_24157[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24132 === (9))){
var state_24131__$1 = state_24131;
var statearr_24141_24158 = state_24131__$1;
(statearr_24141_24158[(2)] = null);

(statearr_24141_24158[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24132 === (5))){
var inst_24116 = cljs.core.async.close_BANG_.call(null,out);
var state_24131__$1 = state_24131;
var statearr_24142_24159 = state_24131__$1;
(statearr_24142_24159[(2)] = inst_24116);

(statearr_24142_24159[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24132 === (10))){
var inst_24124 = (state_24131[(2)]);
var state_24131__$1 = (function (){var statearr_24143 = state_24131;
(statearr_24143[(8)] = inst_24124);

return statearr_24143;
})();
var statearr_24144_24160 = state_24131__$1;
(statearr_24144_24160[(2)] = null);

(statearr_24144_24160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24132 === (8))){
var inst_24113 = (state_24131[(7)]);
var state_24131__$1 = state_24131;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24131__$1,(11),out,inst_24113);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__22570__auto__ = null;
var cljs$core$async$state_machine__22570__auto____0 = (function (){
var statearr_24145 = [null,null,null,null,null,null,null,null,null];
(statearr_24145[(0)] = cljs$core$async$state_machine__22570__auto__);

(statearr_24145[(1)] = (1));

return statearr_24145;
});
var cljs$core$async$state_machine__22570__auto____1 = (function (state_24131){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_24131);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e24146){if((e24146 instanceof Object)){
var ex__22573__auto__ = e24146;
var statearr_24147_24161 = state_24131;
(statearr_24147_24161[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24131);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24146;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24162 = state_24131;
state_24131 = G__24162;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$state_machine__22570__auto__ = function(state_24131){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22570__auto____1.call(this,state_24131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22570__auto____0;
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22570__auto____1;
return cljs$core$async$state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_24148 = f__22667__auto__.call(null);
(statearr_24148[(6)] = c__22666__auto___24150);

return statearr_24148;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__24164 = arguments.length;
switch (G__24164) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__22666__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_24227){
var state_val_24228 = (state_24227[(1)]);
if((state_val_24228 === (7))){
var inst_24223 = (state_24227[(2)]);
var state_24227__$1 = state_24227;
var statearr_24229_24267 = state_24227__$1;
(statearr_24229_24267[(2)] = inst_24223);

(statearr_24229_24267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (20))){
var inst_24193 = (state_24227[(7)]);
var inst_24204 = (state_24227[(2)]);
var inst_24205 = cljs.core.next.call(null,inst_24193);
var inst_24179 = inst_24205;
var inst_24180 = null;
var inst_24181 = (0);
var inst_24182 = (0);
var state_24227__$1 = (function (){var statearr_24230 = state_24227;
(statearr_24230[(8)] = inst_24180);

(statearr_24230[(9)] = inst_24204);

(statearr_24230[(10)] = inst_24179);

(statearr_24230[(11)] = inst_24182);

(statearr_24230[(12)] = inst_24181);

return statearr_24230;
})();
var statearr_24231_24268 = state_24227__$1;
(statearr_24231_24268[(2)] = null);

(statearr_24231_24268[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (1))){
var state_24227__$1 = state_24227;
var statearr_24232_24269 = state_24227__$1;
(statearr_24232_24269[(2)] = null);

(statearr_24232_24269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (4))){
var inst_24168 = (state_24227[(13)]);
var inst_24168__$1 = (state_24227[(2)]);
var inst_24169 = (inst_24168__$1 == null);
var state_24227__$1 = (function (){var statearr_24233 = state_24227;
(statearr_24233[(13)] = inst_24168__$1);

return statearr_24233;
})();
if(cljs.core.truth_(inst_24169)){
var statearr_24234_24270 = state_24227__$1;
(statearr_24234_24270[(1)] = (5));

} else {
var statearr_24235_24271 = state_24227__$1;
(statearr_24235_24271[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (15))){
var state_24227__$1 = state_24227;
var statearr_24239_24272 = state_24227__$1;
(statearr_24239_24272[(2)] = null);

(statearr_24239_24272[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (21))){
var state_24227__$1 = state_24227;
var statearr_24240_24273 = state_24227__$1;
(statearr_24240_24273[(2)] = null);

(statearr_24240_24273[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (13))){
var inst_24180 = (state_24227[(8)]);
var inst_24179 = (state_24227[(10)]);
var inst_24182 = (state_24227[(11)]);
var inst_24181 = (state_24227[(12)]);
var inst_24189 = (state_24227[(2)]);
var inst_24190 = (inst_24182 + (1));
var tmp24236 = inst_24180;
var tmp24237 = inst_24179;
var tmp24238 = inst_24181;
var inst_24179__$1 = tmp24237;
var inst_24180__$1 = tmp24236;
var inst_24181__$1 = tmp24238;
var inst_24182__$1 = inst_24190;
var state_24227__$1 = (function (){var statearr_24241 = state_24227;
(statearr_24241[(14)] = inst_24189);

(statearr_24241[(8)] = inst_24180__$1);

(statearr_24241[(10)] = inst_24179__$1);

(statearr_24241[(11)] = inst_24182__$1);

(statearr_24241[(12)] = inst_24181__$1);

return statearr_24241;
})();
var statearr_24242_24274 = state_24227__$1;
(statearr_24242_24274[(2)] = null);

(statearr_24242_24274[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (22))){
var state_24227__$1 = state_24227;
var statearr_24243_24275 = state_24227__$1;
(statearr_24243_24275[(2)] = null);

(statearr_24243_24275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (6))){
var inst_24168 = (state_24227[(13)]);
var inst_24177 = f.call(null,inst_24168);
var inst_24178 = cljs.core.seq.call(null,inst_24177);
var inst_24179 = inst_24178;
var inst_24180 = null;
var inst_24181 = (0);
var inst_24182 = (0);
var state_24227__$1 = (function (){var statearr_24244 = state_24227;
(statearr_24244[(8)] = inst_24180);

(statearr_24244[(10)] = inst_24179);

(statearr_24244[(11)] = inst_24182);

(statearr_24244[(12)] = inst_24181);

return statearr_24244;
})();
var statearr_24245_24276 = state_24227__$1;
(statearr_24245_24276[(2)] = null);

(statearr_24245_24276[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (17))){
var inst_24193 = (state_24227[(7)]);
var inst_24197 = cljs.core.chunk_first.call(null,inst_24193);
var inst_24198 = cljs.core.chunk_rest.call(null,inst_24193);
var inst_24199 = cljs.core.count.call(null,inst_24197);
var inst_24179 = inst_24198;
var inst_24180 = inst_24197;
var inst_24181 = inst_24199;
var inst_24182 = (0);
var state_24227__$1 = (function (){var statearr_24246 = state_24227;
(statearr_24246[(8)] = inst_24180);

(statearr_24246[(10)] = inst_24179);

(statearr_24246[(11)] = inst_24182);

(statearr_24246[(12)] = inst_24181);

return statearr_24246;
})();
var statearr_24247_24277 = state_24227__$1;
(statearr_24247_24277[(2)] = null);

(statearr_24247_24277[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (3))){
var inst_24225 = (state_24227[(2)]);
var state_24227__$1 = state_24227;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24227__$1,inst_24225);
} else {
if((state_val_24228 === (12))){
var inst_24213 = (state_24227[(2)]);
var state_24227__$1 = state_24227;
var statearr_24248_24278 = state_24227__$1;
(statearr_24248_24278[(2)] = inst_24213);

(statearr_24248_24278[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (2))){
var state_24227__$1 = state_24227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24227__$1,(4),in$);
} else {
if((state_val_24228 === (23))){
var inst_24221 = (state_24227[(2)]);
var state_24227__$1 = state_24227;
var statearr_24249_24279 = state_24227__$1;
(statearr_24249_24279[(2)] = inst_24221);

(statearr_24249_24279[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (19))){
var inst_24208 = (state_24227[(2)]);
var state_24227__$1 = state_24227;
var statearr_24250_24280 = state_24227__$1;
(statearr_24250_24280[(2)] = inst_24208);

(statearr_24250_24280[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (11))){
var inst_24179 = (state_24227[(10)]);
var inst_24193 = (state_24227[(7)]);
var inst_24193__$1 = cljs.core.seq.call(null,inst_24179);
var state_24227__$1 = (function (){var statearr_24251 = state_24227;
(statearr_24251[(7)] = inst_24193__$1);

return statearr_24251;
})();
if(inst_24193__$1){
var statearr_24252_24281 = state_24227__$1;
(statearr_24252_24281[(1)] = (14));

} else {
var statearr_24253_24282 = state_24227__$1;
(statearr_24253_24282[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (9))){
var inst_24215 = (state_24227[(2)]);
var inst_24216 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_24227__$1 = (function (){var statearr_24254 = state_24227;
(statearr_24254[(15)] = inst_24215);

return statearr_24254;
})();
if(cljs.core.truth_(inst_24216)){
var statearr_24255_24283 = state_24227__$1;
(statearr_24255_24283[(1)] = (21));

} else {
var statearr_24256_24284 = state_24227__$1;
(statearr_24256_24284[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (5))){
var inst_24171 = cljs.core.async.close_BANG_.call(null,out);
var state_24227__$1 = state_24227;
var statearr_24257_24285 = state_24227__$1;
(statearr_24257_24285[(2)] = inst_24171);

(statearr_24257_24285[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (14))){
var inst_24193 = (state_24227[(7)]);
var inst_24195 = cljs.core.chunked_seq_QMARK_.call(null,inst_24193);
var state_24227__$1 = state_24227;
if(inst_24195){
var statearr_24258_24286 = state_24227__$1;
(statearr_24258_24286[(1)] = (17));

} else {
var statearr_24259_24287 = state_24227__$1;
(statearr_24259_24287[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (16))){
var inst_24211 = (state_24227[(2)]);
var state_24227__$1 = state_24227;
var statearr_24260_24288 = state_24227__$1;
(statearr_24260_24288[(2)] = inst_24211);

(statearr_24260_24288[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24228 === (10))){
var inst_24180 = (state_24227[(8)]);
var inst_24182 = (state_24227[(11)]);
var inst_24187 = cljs.core._nth.call(null,inst_24180,inst_24182);
var state_24227__$1 = state_24227;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24227__$1,(13),out,inst_24187);
} else {
if((state_val_24228 === (18))){
var inst_24193 = (state_24227[(7)]);
var inst_24202 = cljs.core.first.call(null,inst_24193);
var state_24227__$1 = state_24227;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24227__$1,(20),out,inst_24202);
} else {
if((state_val_24228 === (8))){
var inst_24182 = (state_24227[(11)]);
var inst_24181 = (state_24227[(12)]);
var inst_24184 = (inst_24182 < inst_24181);
var inst_24185 = inst_24184;
var state_24227__$1 = state_24227;
if(cljs.core.truth_(inst_24185)){
var statearr_24261_24289 = state_24227__$1;
(statearr_24261_24289[(1)] = (10));

} else {
var statearr_24262_24290 = state_24227__$1;
(statearr_24262_24290[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__22570__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__22570__auto____0 = (function (){
var statearr_24263 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24263[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__22570__auto__);

(statearr_24263[(1)] = (1));

return statearr_24263;
});
var cljs$core$async$mapcat_STAR__$_state_machine__22570__auto____1 = (function (state_24227){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_24227);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e24264){if((e24264 instanceof Object)){
var ex__22573__auto__ = e24264;
var statearr_24265_24291 = state_24227;
(statearr_24265_24291[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24227);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24264;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24292 = state_24227;
state_24227 = G__24292;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__22570__auto__ = function(state_24227){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__22570__auto____1.call(this,state_24227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__22570__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__22570__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_24266 = f__22667__auto__.call(null);
(statearr_24266[(6)] = c__22666__auto__);

return statearr_24266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));

return c__22666__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__24294 = arguments.length;
switch (G__24294) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__24297 = arguments.length;
switch (G__24297) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__24300 = arguments.length;
switch (G__24300) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22666__auto___24347 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_24324){
var state_val_24325 = (state_24324[(1)]);
if((state_val_24325 === (7))){
var inst_24319 = (state_24324[(2)]);
var state_24324__$1 = state_24324;
var statearr_24326_24348 = state_24324__$1;
(statearr_24326_24348[(2)] = inst_24319);

(statearr_24326_24348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24325 === (1))){
var inst_24301 = null;
var state_24324__$1 = (function (){var statearr_24327 = state_24324;
(statearr_24327[(7)] = inst_24301);

return statearr_24327;
})();
var statearr_24328_24349 = state_24324__$1;
(statearr_24328_24349[(2)] = null);

(statearr_24328_24349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24325 === (4))){
var inst_24304 = (state_24324[(8)]);
var inst_24304__$1 = (state_24324[(2)]);
var inst_24305 = (inst_24304__$1 == null);
var inst_24306 = cljs.core.not.call(null,inst_24305);
var state_24324__$1 = (function (){var statearr_24329 = state_24324;
(statearr_24329[(8)] = inst_24304__$1);

return statearr_24329;
})();
if(inst_24306){
var statearr_24330_24350 = state_24324__$1;
(statearr_24330_24350[(1)] = (5));

} else {
var statearr_24331_24351 = state_24324__$1;
(statearr_24331_24351[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24325 === (6))){
var state_24324__$1 = state_24324;
var statearr_24332_24352 = state_24324__$1;
(statearr_24332_24352[(2)] = null);

(statearr_24332_24352[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24325 === (3))){
var inst_24321 = (state_24324[(2)]);
var inst_24322 = cljs.core.async.close_BANG_.call(null,out);
var state_24324__$1 = (function (){var statearr_24333 = state_24324;
(statearr_24333[(9)] = inst_24321);

return statearr_24333;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24324__$1,inst_24322);
} else {
if((state_val_24325 === (2))){
var state_24324__$1 = state_24324;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24324__$1,(4),ch);
} else {
if((state_val_24325 === (11))){
var inst_24304 = (state_24324[(8)]);
var inst_24313 = (state_24324[(2)]);
var inst_24301 = inst_24304;
var state_24324__$1 = (function (){var statearr_24334 = state_24324;
(statearr_24334[(7)] = inst_24301);

(statearr_24334[(10)] = inst_24313);

return statearr_24334;
})();
var statearr_24335_24353 = state_24324__$1;
(statearr_24335_24353[(2)] = null);

(statearr_24335_24353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24325 === (9))){
var inst_24304 = (state_24324[(8)]);
var state_24324__$1 = state_24324;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24324__$1,(11),out,inst_24304);
} else {
if((state_val_24325 === (5))){
var inst_24301 = (state_24324[(7)]);
var inst_24304 = (state_24324[(8)]);
var inst_24308 = cljs.core._EQ_.call(null,inst_24304,inst_24301);
var state_24324__$1 = state_24324;
if(inst_24308){
var statearr_24337_24354 = state_24324__$1;
(statearr_24337_24354[(1)] = (8));

} else {
var statearr_24338_24355 = state_24324__$1;
(statearr_24338_24355[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24325 === (10))){
var inst_24316 = (state_24324[(2)]);
var state_24324__$1 = state_24324;
var statearr_24339_24356 = state_24324__$1;
(statearr_24339_24356[(2)] = inst_24316);

(statearr_24339_24356[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24325 === (8))){
var inst_24301 = (state_24324[(7)]);
var tmp24336 = inst_24301;
var inst_24301__$1 = tmp24336;
var state_24324__$1 = (function (){var statearr_24340 = state_24324;
(statearr_24340[(7)] = inst_24301__$1);

return statearr_24340;
})();
var statearr_24341_24357 = state_24324__$1;
(statearr_24341_24357[(2)] = null);

(statearr_24341_24357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__22570__auto__ = null;
var cljs$core$async$state_machine__22570__auto____0 = (function (){
var statearr_24342 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24342[(0)] = cljs$core$async$state_machine__22570__auto__);

(statearr_24342[(1)] = (1));

return statearr_24342;
});
var cljs$core$async$state_machine__22570__auto____1 = (function (state_24324){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_24324);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e24343){if((e24343 instanceof Object)){
var ex__22573__auto__ = e24343;
var statearr_24344_24358 = state_24324;
(statearr_24344_24358[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24324);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24343;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24359 = state_24324;
state_24324 = G__24359;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$state_machine__22570__auto__ = function(state_24324){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22570__auto____1.call(this,state_24324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22570__auto____0;
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22570__auto____1;
return cljs$core$async$state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_24345 = f__22667__auto__.call(null);
(statearr_24345[(6)] = c__22666__auto___24347);

return statearr_24345;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__24361 = arguments.length;
switch (G__24361) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22666__auto___24427 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_24399){
var state_val_24400 = (state_24399[(1)]);
if((state_val_24400 === (7))){
var inst_24395 = (state_24399[(2)]);
var state_24399__$1 = state_24399;
var statearr_24401_24428 = state_24399__$1;
(statearr_24401_24428[(2)] = inst_24395);

(statearr_24401_24428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24400 === (1))){
var inst_24362 = (new Array(n));
var inst_24363 = inst_24362;
var inst_24364 = (0);
var state_24399__$1 = (function (){var statearr_24402 = state_24399;
(statearr_24402[(7)] = inst_24363);

(statearr_24402[(8)] = inst_24364);

return statearr_24402;
})();
var statearr_24403_24429 = state_24399__$1;
(statearr_24403_24429[(2)] = null);

(statearr_24403_24429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24400 === (4))){
var inst_24367 = (state_24399[(9)]);
var inst_24367__$1 = (state_24399[(2)]);
var inst_24368 = (inst_24367__$1 == null);
var inst_24369 = cljs.core.not.call(null,inst_24368);
var state_24399__$1 = (function (){var statearr_24404 = state_24399;
(statearr_24404[(9)] = inst_24367__$1);

return statearr_24404;
})();
if(inst_24369){
var statearr_24405_24430 = state_24399__$1;
(statearr_24405_24430[(1)] = (5));

} else {
var statearr_24406_24431 = state_24399__$1;
(statearr_24406_24431[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24400 === (15))){
var inst_24389 = (state_24399[(2)]);
var state_24399__$1 = state_24399;
var statearr_24407_24432 = state_24399__$1;
(statearr_24407_24432[(2)] = inst_24389);

(statearr_24407_24432[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24400 === (13))){
var state_24399__$1 = state_24399;
var statearr_24408_24433 = state_24399__$1;
(statearr_24408_24433[(2)] = null);

(statearr_24408_24433[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24400 === (6))){
var inst_24364 = (state_24399[(8)]);
var inst_24385 = (inst_24364 > (0));
var state_24399__$1 = state_24399;
if(cljs.core.truth_(inst_24385)){
var statearr_24409_24434 = state_24399__$1;
(statearr_24409_24434[(1)] = (12));

} else {
var statearr_24410_24435 = state_24399__$1;
(statearr_24410_24435[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24400 === (3))){
var inst_24397 = (state_24399[(2)]);
var state_24399__$1 = state_24399;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24399__$1,inst_24397);
} else {
if((state_val_24400 === (12))){
var inst_24363 = (state_24399[(7)]);
var inst_24387 = cljs.core.vec.call(null,inst_24363);
var state_24399__$1 = state_24399;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24399__$1,(15),out,inst_24387);
} else {
if((state_val_24400 === (2))){
var state_24399__$1 = state_24399;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24399__$1,(4),ch);
} else {
if((state_val_24400 === (11))){
var inst_24379 = (state_24399[(2)]);
var inst_24380 = (new Array(n));
var inst_24363 = inst_24380;
var inst_24364 = (0);
var state_24399__$1 = (function (){var statearr_24411 = state_24399;
(statearr_24411[(7)] = inst_24363);

(statearr_24411[(8)] = inst_24364);

(statearr_24411[(10)] = inst_24379);

return statearr_24411;
})();
var statearr_24412_24436 = state_24399__$1;
(statearr_24412_24436[(2)] = null);

(statearr_24412_24436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24400 === (9))){
var inst_24363 = (state_24399[(7)]);
var inst_24377 = cljs.core.vec.call(null,inst_24363);
var state_24399__$1 = state_24399;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24399__$1,(11),out,inst_24377);
} else {
if((state_val_24400 === (5))){
var inst_24372 = (state_24399[(11)]);
var inst_24363 = (state_24399[(7)]);
var inst_24367 = (state_24399[(9)]);
var inst_24364 = (state_24399[(8)]);
var inst_24371 = (inst_24363[inst_24364] = inst_24367);
var inst_24372__$1 = (inst_24364 + (1));
var inst_24373 = (inst_24372__$1 < n);
var state_24399__$1 = (function (){var statearr_24413 = state_24399;
(statearr_24413[(11)] = inst_24372__$1);

(statearr_24413[(12)] = inst_24371);

return statearr_24413;
})();
if(cljs.core.truth_(inst_24373)){
var statearr_24414_24437 = state_24399__$1;
(statearr_24414_24437[(1)] = (8));

} else {
var statearr_24415_24438 = state_24399__$1;
(statearr_24415_24438[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24400 === (14))){
var inst_24392 = (state_24399[(2)]);
var inst_24393 = cljs.core.async.close_BANG_.call(null,out);
var state_24399__$1 = (function (){var statearr_24417 = state_24399;
(statearr_24417[(13)] = inst_24392);

return statearr_24417;
})();
var statearr_24418_24439 = state_24399__$1;
(statearr_24418_24439[(2)] = inst_24393);

(statearr_24418_24439[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24400 === (10))){
var inst_24383 = (state_24399[(2)]);
var state_24399__$1 = state_24399;
var statearr_24419_24440 = state_24399__$1;
(statearr_24419_24440[(2)] = inst_24383);

(statearr_24419_24440[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24400 === (8))){
var inst_24372 = (state_24399[(11)]);
var inst_24363 = (state_24399[(7)]);
var tmp24416 = inst_24363;
var inst_24363__$1 = tmp24416;
var inst_24364 = inst_24372;
var state_24399__$1 = (function (){var statearr_24420 = state_24399;
(statearr_24420[(7)] = inst_24363__$1);

(statearr_24420[(8)] = inst_24364);

return statearr_24420;
})();
var statearr_24421_24441 = state_24399__$1;
(statearr_24421_24441[(2)] = null);

(statearr_24421_24441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__22570__auto__ = null;
var cljs$core$async$state_machine__22570__auto____0 = (function (){
var statearr_24422 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24422[(0)] = cljs$core$async$state_machine__22570__auto__);

(statearr_24422[(1)] = (1));

return statearr_24422;
});
var cljs$core$async$state_machine__22570__auto____1 = (function (state_24399){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_24399);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e24423){if((e24423 instanceof Object)){
var ex__22573__auto__ = e24423;
var statearr_24424_24442 = state_24399;
(statearr_24424_24442[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24399);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24423;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24443 = state_24399;
state_24399 = G__24443;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$state_machine__22570__auto__ = function(state_24399){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22570__auto____1.call(this,state_24399);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22570__auto____0;
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22570__auto____1;
return cljs$core$async$state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_24425 = f__22667__auto__.call(null);
(statearr_24425[(6)] = c__22666__auto___24427);

return statearr_24425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__24445 = arguments.length;
switch (G__24445) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22666__auto___24522 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22667__auto__ = (function (){var switch__22569__auto__ = (function (state_24490){
var state_val_24491 = (state_24490[(1)]);
if((state_val_24491 === (7))){
var inst_24486 = (state_24490[(2)]);
var state_24490__$1 = state_24490;
var statearr_24492_24523 = state_24490__$1;
(statearr_24492_24523[(2)] = inst_24486);

(statearr_24492_24523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24491 === (1))){
var inst_24446 = [];
var inst_24447 = inst_24446;
var inst_24448 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_24490__$1 = (function (){var statearr_24493 = state_24490;
(statearr_24493[(7)] = inst_24448);

(statearr_24493[(8)] = inst_24447);

return statearr_24493;
})();
var statearr_24494_24524 = state_24490__$1;
(statearr_24494_24524[(2)] = null);

(statearr_24494_24524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24491 === (4))){
var inst_24451 = (state_24490[(9)]);
var inst_24451__$1 = (state_24490[(2)]);
var inst_24452 = (inst_24451__$1 == null);
var inst_24453 = cljs.core.not.call(null,inst_24452);
var state_24490__$1 = (function (){var statearr_24495 = state_24490;
(statearr_24495[(9)] = inst_24451__$1);

return statearr_24495;
})();
if(inst_24453){
var statearr_24496_24525 = state_24490__$1;
(statearr_24496_24525[(1)] = (5));

} else {
var statearr_24497_24526 = state_24490__$1;
(statearr_24497_24526[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24491 === (15))){
var inst_24447 = (state_24490[(8)]);
var inst_24478 = cljs.core.vec.call(null,inst_24447);
var state_24490__$1 = state_24490;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24490__$1,(18),out,inst_24478);
} else {
if((state_val_24491 === (13))){
var inst_24473 = (state_24490[(2)]);
var state_24490__$1 = state_24490;
var statearr_24498_24527 = state_24490__$1;
(statearr_24498_24527[(2)] = inst_24473);

(statearr_24498_24527[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24491 === (6))){
var inst_24447 = (state_24490[(8)]);
var inst_24475 = inst_24447.length;
var inst_24476 = (inst_24475 > (0));
var state_24490__$1 = state_24490;
if(cljs.core.truth_(inst_24476)){
var statearr_24499_24528 = state_24490__$1;
(statearr_24499_24528[(1)] = (15));

} else {
var statearr_24500_24529 = state_24490__$1;
(statearr_24500_24529[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24491 === (17))){
var inst_24483 = (state_24490[(2)]);
var inst_24484 = cljs.core.async.close_BANG_.call(null,out);
var state_24490__$1 = (function (){var statearr_24501 = state_24490;
(statearr_24501[(10)] = inst_24483);

return statearr_24501;
})();
var statearr_24502_24530 = state_24490__$1;
(statearr_24502_24530[(2)] = inst_24484);

(statearr_24502_24530[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24491 === (3))){
var inst_24488 = (state_24490[(2)]);
var state_24490__$1 = state_24490;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24490__$1,inst_24488);
} else {
if((state_val_24491 === (12))){
var inst_24447 = (state_24490[(8)]);
var inst_24466 = cljs.core.vec.call(null,inst_24447);
var state_24490__$1 = state_24490;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24490__$1,(14),out,inst_24466);
} else {
if((state_val_24491 === (2))){
var state_24490__$1 = state_24490;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24490__$1,(4),ch);
} else {
if((state_val_24491 === (11))){
var inst_24455 = (state_24490[(11)]);
var inst_24447 = (state_24490[(8)]);
var inst_24451 = (state_24490[(9)]);
var inst_24463 = inst_24447.push(inst_24451);
var tmp24503 = inst_24447;
var inst_24447__$1 = tmp24503;
var inst_24448 = inst_24455;
var state_24490__$1 = (function (){var statearr_24504 = state_24490;
(statearr_24504[(12)] = inst_24463);

(statearr_24504[(7)] = inst_24448);

(statearr_24504[(8)] = inst_24447__$1);

return statearr_24504;
})();
var statearr_24505_24531 = state_24490__$1;
(statearr_24505_24531[(2)] = null);

(statearr_24505_24531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24491 === (9))){
var inst_24448 = (state_24490[(7)]);
var inst_24459 = cljs.core.keyword_identical_QMARK_.call(null,inst_24448,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_24490__$1 = state_24490;
var statearr_24506_24532 = state_24490__$1;
(statearr_24506_24532[(2)] = inst_24459);

(statearr_24506_24532[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24491 === (5))){
var inst_24456 = (state_24490[(13)]);
var inst_24455 = (state_24490[(11)]);
var inst_24448 = (state_24490[(7)]);
var inst_24451 = (state_24490[(9)]);
var inst_24455__$1 = f.call(null,inst_24451);
var inst_24456__$1 = cljs.core._EQ_.call(null,inst_24455__$1,inst_24448);
var state_24490__$1 = (function (){var statearr_24507 = state_24490;
(statearr_24507[(13)] = inst_24456__$1);

(statearr_24507[(11)] = inst_24455__$1);

return statearr_24507;
})();
if(inst_24456__$1){
var statearr_24508_24533 = state_24490__$1;
(statearr_24508_24533[(1)] = (8));

} else {
var statearr_24509_24534 = state_24490__$1;
(statearr_24509_24534[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24491 === (14))){
var inst_24455 = (state_24490[(11)]);
var inst_24451 = (state_24490[(9)]);
var inst_24468 = (state_24490[(2)]);
var inst_24469 = [];
var inst_24470 = inst_24469.push(inst_24451);
var inst_24447 = inst_24469;
var inst_24448 = inst_24455;
var state_24490__$1 = (function (){var statearr_24510 = state_24490;
(statearr_24510[(14)] = inst_24470);

(statearr_24510[(15)] = inst_24468);

(statearr_24510[(7)] = inst_24448);

(statearr_24510[(8)] = inst_24447);

return statearr_24510;
})();
var statearr_24511_24535 = state_24490__$1;
(statearr_24511_24535[(2)] = null);

(statearr_24511_24535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24491 === (16))){
var state_24490__$1 = state_24490;
var statearr_24512_24536 = state_24490__$1;
(statearr_24512_24536[(2)] = null);

(statearr_24512_24536[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24491 === (10))){
var inst_24461 = (state_24490[(2)]);
var state_24490__$1 = state_24490;
if(cljs.core.truth_(inst_24461)){
var statearr_24513_24537 = state_24490__$1;
(statearr_24513_24537[(1)] = (11));

} else {
var statearr_24514_24538 = state_24490__$1;
(statearr_24514_24538[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24491 === (18))){
var inst_24480 = (state_24490[(2)]);
var state_24490__$1 = state_24490;
var statearr_24515_24539 = state_24490__$1;
(statearr_24515_24539[(2)] = inst_24480);

(statearr_24515_24539[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24491 === (8))){
var inst_24456 = (state_24490[(13)]);
var state_24490__$1 = state_24490;
var statearr_24516_24540 = state_24490__$1;
(statearr_24516_24540[(2)] = inst_24456);

(statearr_24516_24540[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__22570__auto__ = null;
var cljs$core$async$state_machine__22570__auto____0 = (function (){
var statearr_24517 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24517[(0)] = cljs$core$async$state_machine__22570__auto__);

(statearr_24517[(1)] = (1));

return statearr_24517;
});
var cljs$core$async$state_machine__22570__auto____1 = (function (state_24490){
while(true){
var ret_value__22571__auto__ = (function (){try{while(true){
var result__22572__auto__ = switch__22569__auto__.call(null,state_24490);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22572__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22572__auto__;
}
break;
}
}catch (e24518){if((e24518 instanceof Object)){
var ex__22573__auto__ = e24518;
var statearr_24519_24541 = state_24490;
(statearr_24519_24541[(5)] = ex__22573__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24490);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24518;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22571__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24542 = state_24490;
state_24490 = G__24542;
continue;
} else {
return ret_value__22571__auto__;
}
break;
}
});
cljs$core$async$state_machine__22570__auto__ = function(state_24490){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22570__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22570__auto____1.call(this,state_24490);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22570__auto____0;
cljs$core$async$state_machine__22570__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22570__auto____1;
return cljs$core$async$state_machine__22570__auto__;
})()
})();
var state__22668__auto__ = (function (){var statearr_24520 = f__22667__auto__.call(null);
(statearr_24520[(6)] = c__22666__auto___24522);

return statearr_24520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22668__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=async.js.map
